/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PlatformUtils;

public class StructureViewSelectInTarget
implements SelectInTarget {
    public static final Key<StructureViewWrapper> CUSTOM_STRUCTURE_VIEW_KEY = Key.create("customStructureView");
    private final Project myProject;

    public StructureViewSelectInTarget(Project project2) {
        this.myProject = project2;
        if (PlatformUtils.isPyCharmEducational()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    @Override
    public String toString() {
        return IdeBundle.message("select.in.file.structure", new Object[0]);
    }

    @Override
    public boolean canSelect(SelectInContext context) {
        return context.getFileEditorProvider() != null && !LightEdit.owns(context.getProject());
    }

    @Override
    public void selectIn(SelectInContext context, boolean requestFocus) {
        FileEditor fileEditor = context.getFileEditorProvider().openFileEditor();
        StructureViewWrapper customStructureView = CUSTOM_STRUCTURE_VIEW_KEY.get(context.getVirtualFile());
        if (customStructureView != null) {
            customStructureView.selectCurrentElement(fileEditor, context.getVirtualFile(), requestFocus);
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance(context.getProject());
        Runnable runnable2 = () -> StructureViewFactoryEx.getInstanceEx(this.myProject).runWhenInitialized(() -> this.getStructureViewWrapper().selectCurrentElement(fileEditor, context.getVirtualFile(), requestFocus));
        if (requestFocus) {
            windowManager.getToolWindow("Structure").activate(runnable2);
        } else {
            runnable2.run();
        }
    }

    private StructureViewWrapper getStructureViewWrapper() {
        return StructureViewFactoryEx.getInstanceEx(this.myProject).getStructureViewWrapper();
    }

    @Override
    public String getToolWindowId() {
        return "Structure";
    }

    @Override
    public String getMinorViewId() {
        return null;
    }

    @Override
    public float getWeight() {
        return 4.0f;
    }
}

