/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;

public class LightEditFeatureUsagesUtil {
    private static final String USAGE_GROUP_ID = "light.edit";
    private static final String OPEN_FILE_EVENT_ID = "open.file";
    private static final String OPEN_FILE_EVENT_PLACE = "open_place";
    private static final String AUTOSAVE_MODE_EVENT_ID = "autosave.mode";
    private static final String AUTOSAVE_MODE_ENABLED_FLAG = "enabled";
    private static final String OPEN_IN_PROJECT_EVENT_ID = "open.in.project";
    private static final String OPEN_IN_PROJECT_STATUS = "project_status";

    private LightEditFeatureUsagesUtil() {
    }

    public static void logFileOpen(OpenPlace openPlace) {
        FUCounterUsageLogger.getInstance().logEvent(USAGE_GROUP_ID, OPEN_FILE_EVENT_ID, new FeatureUsageData().addData(OPEN_FILE_EVENT_PLACE, openPlace.name()));
    }

    public static void logAutosaveModeChanged(boolean isAutosave) {
        FUCounterUsageLogger.getInstance().logEvent(USAGE_GROUP_ID, AUTOSAVE_MODE_EVENT_ID, new FeatureUsageData().addData(AUTOSAVE_MODE_ENABLED_FLAG, isAutosave));
    }

    public static void logOpenFileInProject(ProjectStatus projectStatus) {
        FUCounterUsageLogger.getInstance().logEvent(USAGE_GROUP_ID, OPEN_IN_PROJECT_EVENT_ID, new FeatureUsageData().addData(OPEN_IN_PROJECT_STATUS, projectStatus.name()));
    }

    public static enum ProjectStatus {
        Open,
        Existing,
        New;

    }

    public static enum OpenPlace {
        CommandLine,
        WelcomeScreenOpenAction,
        LightEditOpenAction,
        DragAndDrop,
        RecentFiles;

    }
}

