/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditSaveStatusIcon;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditTabAttributesProvider;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LightEditTabs
extends JBEditorTabs
implements LightEditorListener,
CloseAction.CloseTarget {
    private final LightEditorManagerImpl myEditorManager;
    private final ExecutorService myTabUpdateExecutor;

    LightEditTabs(@NotNull Disposable parentDisposable, @NotNull LightEditorManagerImpl editorManager) {
        if (parentDisposable == null) {
            LightEditTabs.$$$reportNull$$$0(0);
        }
        if (editorManager == null) {
            LightEditTabs.$$$reportNull$$$0(1);
        }
        super(LightEditUtil.getProject(), null, parentDisposable);
        this.myEditorManager = editorManager;
        this.myTabUpdateExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor("Light Edit Tabs Update", 1);
        Disposer.register(parentDisposable, () -> this.myTabUpdateExecutor.shutdown());
        this.addListener(new TabsListener(){

            @Override
            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                ObjectUtils.consumeIfNotNull(oldSelection, tabInfo -> tabInfo.setTabColor(null));
                LightEditTabs.this.asyncUpdateTab(newSelection);
                LightEditTabs.this.onSelectionChange(newSelection);
            }
        });
        this.myEditorManager.addListener(this, parentDisposable);
    }

    void addEditorTab(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(2);
        }
        this.addEditorTab(editorInfo, -1);
    }

    private void addEditorTab(@NotNull LightEditorInfo editorInfo, int index) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(3);
        }
        TabInfo tabInfo = new TabInfo(new EditorContainer(editorInfo.getFileEditor())).setText(editorInfo.getFile().getPresentableName()).setIcon(LightEditTabs.getFileTypeIcon(editorInfo));
        tabInfo.setObject(editorInfo);
        DefaultActionGroup tabActions = new DefaultActionGroup();
        tabActions.add(new CloseTabAction(editorInfo));
        tabInfo.setTabLabelActions(tabActions, "EditorTab");
        this.addTabSilently(tabInfo, index);
        this.select(tabInfo, true);
        this.asyncUpdateTab(tabInfo);
        this.myEditorManager.fireEditorSelected(editorInfo);
    }

    @Override
    public void close() {
        ObjectUtils.consumeIfNotNull(this.getSelectedInfo(), tabInfo -> this.closeTab((TabInfo)tabInfo));
    }

    private static Icon getFileTypeIcon(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(4);
        }
        return editorInfo.getFile().getFileType().getIcon();
    }

    private void onSelectionChange(@Nullable TabInfo tabInfo) {
        Object data2;
        LightEditorInfo selectedEditorInfo = null;
        if (tabInfo != null && (data2 = tabInfo.getObject()) instanceof LightEditorInfo) {
            selectedEditorInfo = (LightEditorInfo)data2;
        }
        this.myEditorManager.fireEditorSelected(selectedEditorInfo);
    }

    void selectTab(@NotNull LightEditorInfo info) {
        if (info == null) {
            LightEditTabs.$$$reportNull$$$0(5);
        }
        this.getTabs().stream().filter(tabInfo -> tabInfo.getObject().equals(info)).findFirst().ifPresent(tabInfo -> this.select((TabInfo)tabInfo, true));
    }

    private void closeTab(@NotNull TabInfo tabInfo) {
        LightEditorInfo editorInfo;
        Object data2;
        if (tabInfo == null) {
            LightEditTabs.$$$reportNull$$$0(6);
        }
        if ((data2 = tabInfo.getObject()) instanceof LightEditorInfo && (!(editorInfo = (LightEditorInfo)data2).isUnsaved() || this.autosaveDocument(editorInfo) || LightEditUtil.confirmClose(ApplicationBundle.message("light.edit.close.message", new Object[0]), ApplicationBundle.message("light.edit.close.title", new Object[0]), new LightEditSaveConfirmationHandler(){

            @Override
            public void onSave() {
                LightEditTabs.this.saveDocument(editorInfo);
            }

            @Override
            public void onDiscard() {
                FileEditor fileEditor = editorInfo.getFileEditor();
                if (fileEditor instanceof TextEditor) {
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    FileDocumentManager.getInstance().reloadFromDisk(editor.getDocument());
                }
            }
        }))) {
            this.removeTab(tabInfo).doWhenDone(() -> this.myEditorManager.closeEditor(editorInfo));
        }
    }

    private boolean autosaveDocument(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(7);
        }
        if (LightEditService.getInstance().isAutosaveMode()) {
            this.saveDocument(editorInfo);
            return true;
        }
        return false;
    }

    void closeTab(@NotNull LightEditorInfo editorInfo) {
        TabInfo tabInfo;
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(8);
        }
        if ((tabInfo = this.findInfo(editorInfo)) != null) {
            this.closeTab(tabInfo);
        }
    }

    void saveDocument(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(9);
        }
        if (editorInfo.isNew()) {
            VirtualFile targetFile = LightEditUtil.chooseTargetFile(this.getParent(), editorInfo);
            if (targetFile != null) {
                this.myEditorManager.saveAs(editorInfo, targetFile);
            }
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(editorInfo.getFile());
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
        }
    }

    void replaceTab(@NotNull LightEditorInfo oldInfo, @NotNull LightEditorInfo newInfo) {
        int oldIndex;
        TabInfo oldTabInfo;
        if (oldInfo == null) {
            LightEditTabs.$$$reportNull$$$0(10);
        }
        if (newInfo == null) {
            LightEditTabs.$$$reportNull$$$0(11);
        }
        if ((oldTabInfo = this.findInfo(oldInfo)) != null && (oldIndex = this.getIndexOf(oldTabInfo)) >= 0) {
            this.removeTab(oldTabInfo).doWhenDone(() -> this.myEditorManager.closeEditor(oldInfo));
            this.addEditorTab(newInfo, oldIndex);
        }
    }

    @Nullable
    VirtualFile getSelectedFile() {
        LightEditorInfo editorInfo;
        TabInfo info = this.getSelectedInfo();
        if (info != null && (editorInfo = ObjectUtils.tryCast(info.getObject(), LightEditorInfo.class)) != null) {
            return editorInfo.getFile();
        }
        return null;
    }

    @Nullable
    FileEditor getSelectedFileEditor() {
        LightEditorInfo editorInfo;
        TabInfo info = this.getSelectedInfo();
        if (info != null && (editorInfo = ObjectUtils.tryCast(info.getObject(), LightEditorInfo.class)) != null) {
            return editorInfo.getFileEditor();
        }
        return null;
    }

    private void asyncUpdateTab(@NotNull TabInfo tabInfo) {
        if (tabInfo == null) {
            LightEditTabs.$$$reportNull$$$0(12);
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        Object object = tabInfo.getObject();
        if (!(object instanceof LightEditorInfo)) {
            return;
        }
        this.asyncUpdateTabs(Collections.singletonList(Pair.createNonNull(tabInfo, (LightEditorInfo)object)));
    }

    private void asyncUpdateTabs(@NotNull List<Pair.NonNull<TabInfo, LightEditorInfo>> tabEditorPairs) {
        if (tabEditorPairs == null) {
            LightEditTabs.$$$reportNull$$$0(13);
        }
        this.myTabUpdateExecutor.execute(() -> {
            List<Pair.NonNull> tabAttributesPairs = ContainerUtil.map(tabEditorPairs, pair -> Pair.createNonNull(pair.first, LightEditTabs.calcAttributes((LightEditorInfo)pair.second)));
            ApplicationManager.getApplication().invokeLater(() -> {
                for (Pair.NonNull attributesPair : tabAttributesPairs) {
                    this.updateTabPresentation((TabInfo)attributesPair.first, (TextAttributes)attributesPair.second);
                }
            });
        });
    }

    private void updateTabPresentation(@NotNull TabInfo tabInfo, @NotNull TextAttributes attributes) {
        if (tabInfo == null) {
            LightEditTabs.$$$reportNull$$$0(14);
        }
        if (attributes == null) {
            LightEditTabs.$$$reportNull$$$0(15);
        }
        tabInfo.setDefaultForeground(attributes.getForegroundColor());
        tabInfo.setTabColor(tabInfo == this.getSelectedInfo() ? attributes.getBackgroundColor() : null);
    }

    @NotNull
    private static TextAttributes calcAttributes(@NotNull LightEditorInfo editorInfo) {
        if (editorInfo == null) {
            LightEditTabs.$$$reportNull$$$0(16);
        }
        TextAttributes attributes = new TextAttributes();
        attributes.setBackgroundColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        LightEditTabAttributesProvider.EP_NAME.getExtensionList().forEach(provider -> {
            TextAttributes provided = provider.calcAttributes(editorInfo);
            if (provided != null) {
                if (provided.getForegroundColor() != null) {
                    attributes.setForegroundColor(provided.getForegroundColor());
                }
                if (provided.getBackgroundColor() != null) {
                    attributes.setBackgroundColor(provided.getBackgroundColor());
                }
            }
        });
        TextAttributes textAttributes = attributes;
        if (textAttributes == null) {
            LightEditTabs.$$$reportNull$$$0(17);
        }
        return textAttributes;
    }

    @Override
    public void fileStatusChanged(@NotNull Collection<LightEditorInfo> editorInfos) {
        if (editorInfos == null) {
            LightEditTabs.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            List<Pair.NonNull<TabInfo, LightEditorInfo>> tabEditorPairs = ContainerUtil.mapNotNull(editorInfos, editorInfo -> {
                TabInfo info = this.findInfo(editorInfo);
                if (info == null) {
                    return null;
                }
                return Pair.createNonNull(info, editorInfo);
            });
            if (!tabEditorPairs.isEmpty()) {
                this.asyncUpdateTabs(tabEditorPairs);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabEditorPairs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditTabs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditTabs";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEditorTab";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "closeTab";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "autosaveDocument";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceTab";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateTab";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateTabs";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateTabPresentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcAttributes";
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fileStatusChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditorContainer
    extends JPanel
    implements DataProvider {
        private EditorContainer(FileEditor editor) {
            if (editor == null) {
                EditorContainer.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.add((Component)editor.getComponent(), "Center");
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                EditorContainer.$$$reportNull$$$0(1);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return LightEditUtil.getProject();
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return LightEditTabs.this.getSelectedFile();
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                VirtualFile selectedFile = LightEditTabs.this.getSelectedFile();
                if (selectedFile != null) {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = selectedFile;
                } else {
                    virtualFileArray = VirtualFile.EMPTY_ARRAY;
                }
                return virtualFileArray;
            }
            if (CloseAction.CloseTarget.KEY.is(dataId)) {
                return LightEditTabs.this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/lightEdit/LightEditTabs$EditorContainer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CloseTabAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final LightEditorInfo myEditorInfo;
        private final Icon myUnsavedIcon;

        private CloseTabAction(LightEditorInfo editorInfo) {
            if (editorInfo == null) {
                CloseTabAction.$$$reportNull$$$0(0);
            }
            this.myUnsavedIcon = LightEditSaveStatusIcon.create(new Color(4228041));
            this.myEditorInfo = editorInfo;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseTabAction.$$$reportNull$$$0(1);
            }
            if ((e.getModifiers() & 8) == 0) {
                this.closeCurrentTab();
            } else {
                this.closeAllTabsExceptCurrent();
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseTabAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setIcon(this.getIcon());
            e.getPresentation().setHoveredIcon(AllIcons.Actions.CloseHovered);
            e.getPresentation().setVisible(UISettings.getInstance().getShowCloseButton());
            e.getPresentation().setText(IdeBundle.messagePointer("action.presentation.LightEditTabs.text", new Object[0]));
        }

        private Icon getIcon() {
            return this.myEditorInfo.isUnsaved() ? this.myUnsavedIcon : AllIcons.Actions.Close;
        }

        private void closeCurrentTab() {
            TabInfo tabInfo = LightEditTabs.this.findInfo(this.myEditorInfo);
            if (tabInfo != null) {
                LightEditTabs.this.closeTab(tabInfo);
            }
        }

        private void closeAllTabsExceptCurrent() {
            LightEditTabs.this.getTabs().stream().filter(tabInfo -> tabInfo != LightEditTabs.this.getSelectedInfo()).forEach(tabInfo -> LightEditTabs.this.closeTab(tabInfo));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorInfo";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/lightEdit/LightEditTabs$CloseTabAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

