/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.EmptyCompletionNotifier;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditFileTypeOverrider;
import com.intellij.ide.lightEdit.LightEditSaveConfirmationHandler;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.intentions.openInProject.LightEditOpenInProjectIntention;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import java.awt.Component;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditUtil {
    private static final String ENABLED_FILE_OPEN_KEY = "light.edit.file.open.enabled";
    private static final String OPEN_FILE_IN_PROJECT_HREF = "open_file_in_project";

    private LightEditUtil() {
    }

    public static boolean openFile(@NotNull Path path2) {
        VirtualFile virtualFile2;
        if (path2 == null) {
            LightEditUtil.$$$reportNull$$$0(0);
        }
        if ((virtualFile2 = VfsUtil.findFile(path2, true)) != null && LightEdit.openFile(virtualFile2)) {
            LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.CommandLine);
            return true;
        }
        return false;
    }

    @NotNull
    public static Project getProject() {
        Project project2 = LightEditService.getInstance().getOrCreateProject();
        if (project2 == null) {
            LightEditUtil.$$$reportNull$$$0(1);
        }
        return project2;
    }

    @Nullable
    public static Project getProjectIfCreated() {
        return LightEditService.getInstance().getProject();
    }

    static boolean confirmClose(@NotNull String message, @NotNull String title, @NotNull LightEditSaveConfirmationHandler handler2) {
        if (message == null) {
            LightEditUtil.$$$reportNull$$$0(2);
        }
        if (title == null) {
            LightEditUtil.$$$reportNull$$$0(3);
        }
        if (handler2 == null) {
            LightEditUtil.$$$reportNull$$$0(4);
        }
        String[] options = new String[]{LightEditUtil.getCloseSave(), LightEditUtil.getCloseDiscard(), LightEditUtil.getCloseCancel()};
        int result2 = Messages.showDialog(LightEditUtil.getProject(), message, title, options, 0, Messages.getWarningIcon());
        if (result2 >= 0) {
            if (LightEditUtil.getCloseCancel().equals(options[result2])) {
                return false;
            }
            if (LightEditUtil.getCloseSave().equals(options[result2])) {
                handler2.onSave();
            } else if (LightEditUtil.getCloseDiscard().equals(options[result2])) {
                handler2.onDiscard();
            }
            return true;
        }
        return false;
    }

    @Nullable
    static VirtualFile chooseTargetFile(@NotNull Component parent, @NotNull LightEditorInfo editorInfo) {
        FileSaverDialog saver;
        VirtualFileWrapper fileWrapper;
        if (parent == null) {
            LightEditUtil.$$$reportNull$$$0(5);
        }
        if (editorInfo == null) {
            LightEditUtil.$$$reportNull$$$0(6);
        }
        if ((fileWrapper = (saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save as", "Choose a target file", LightEditUtil.getKnownExtensions()), parent)).save(VfsUtil.getUserHomeDir(), editorInfo.getFile().getPresentableName())) != null) {
            return fileWrapper.getVirtualFile(true);
        }
        return null;
    }

    private static String[] getKnownExtensions() {
        return ArrayUtil.toStringArray(Stream.of(FileTypeManager.getInstance().getRegisteredFileTypes()).map(fileType -> fileType.getDefaultExtension()).sorted().distinct().collect(Collectors.toList()));
    }

    private static String getCloseSave() {
        return ApplicationBundle.message("light.edit.close.save", new Object[0]);
    }

    private static String getCloseDiscard() {
        return ApplicationBundle.message("light.edit.close.discard", new Object[0]);
    }

    private static String getCloseCancel() {
        return ApplicationBundle.message("light.edit.close.cancel", new Object[0]);
    }

    public static void markUnknownFileTypeAsPlainTextIfNeeded(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            LightEditUtil.$$$reportNull$$$0(7);
        }
        if (project2 != null && !project2.isDefault() && !LightEdit.owns(project2)) {
            return;
        }
        if (LightEditUtil.isLightEditEnabled()) {
            LightEditFileTypeOverrider.markUnknownFileTypeAsPlainText(file2);
        }
    }

    public static boolean isLightEditEnabled() {
        return Registry.is(ENABLED_FILE_OPEN_KEY) && !PlatformUtils.isDataGrip();
    }

    @ApiStatus.Internal
    @NotNull
    public static EmptyCompletionNotifier createEmptyCompletionNotifier() {
        return new EmptyCompletionNotifier(){

            @Override
            public void showIncompleteHint(@NotNull Editor editor, @NotNull String text2, boolean isDumbMode) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                HintManager.getInstance().showInformationHint(editor, StringUtil.escapeXmlEntities(text2) + CodeInsightBundle.message("completion.incomplete.light.edit.suffix", LightEditUtil.OPEN_FILE_IN_PROJECT_HREF), e -> {
                    VirtualFile file2;
                    if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && LightEditUtil.OPEN_FILE_IN_PROJECT_HREF.equals(e.getDescription()) && (file2 = LightEditService.getInstance().getSelectedFile()) != null) {
                        LightEditOpenInProjectIntention.performOn(file2);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/lightEdit/LightEditUtil$1";
                objectArray[2] = "showIncompleteHint";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/LightEditUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/LightEditUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "confirmClose";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseTargetFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markUnknownFileTypeAsPlainTextIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

