/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.actions;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;

public final class LightEditGotoOpenedFileAction
extends FileChooserAction
implements LightEditCompatible {
    @Override
    protected void actionPerformed(FileSystemTree fileSystemTree, AnActionEvent e) {
        VirtualFile file2;
        Project project2 = e.getProject();
        if (project2 != null && (file2 = ArrayUtil.getFirstElement(FileEditorManager.getInstance(project2).getSelectedFiles())) != null) {
            fileSystemTree.select(file2, () -> fileSystemTree.expand(file2, null));
        }
    }

    @Override
    protected void update(FileSystemTree fileChooser, AnActionEvent e) {
        Project project2 = e.getProject();
        if (!LightEdit.owns(project2)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabled(FileEditorManager.getInstance(project2).hasOpenFiles());
    }
}

