/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.intentions.openInProject;

import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.ide.lightEdit.intentions.openInProject.GitProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.GradleProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.IntellijProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.ProjectRootFinder;
import com.intellij.ide.lightEdit.intentions.openInProject.SimpleParentRootFinder;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectRootSearchUtil {
    private static final ProjectRootFinder[] ROOT_FINDERS = new ProjectRootFinder[]{new IntellijProjectRootFinder(), new GradleProjectRootFinder(), new GitProjectRootFinder(), new SimpleParentRootFinder()};

    private ProjectRootSearchUtil() {
    }

    @Nullable
    static VirtualFile findProjectRoot(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            ProjectRootSearchUtil.$$$reportNull$$$0(0);
        }
        Ref<VirtualFile> result2 = Ref.create();
        Ref<Boolean> requiresConfirmation = Ref.create(false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            for (ProjectRootFinder finder : ROOT_FINDERS) {
                VirtualFile root = finder.findProjectRoot(sourceFile);
                if (root == null) continue;
                result2.set(root);
                requiresConfirmation.set(finder.requiresConfirmation());
                break;
            }
        }, ApplicationBundle.message("light.edit.open.in.project.progress.message", new Object[0]), true, LightEditUtil.getProject());
        if (requiresConfirmation.get().booleanValue()) {
            VirtualFile newProjectRoot = ProjectRootSearchUtil.confirmOrChooseProjectDir((VirtualFile)result2.get());
            if (newProjectRoot != null) {
                LightEditFeatureUsagesUtil.logOpenFileInProject(LightEditFeatureUsagesUtil.ProjectStatus.New);
            }
            result2.set(newProjectRoot);
        } else {
            LightEditFeatureUsagesUtil.logOpenFileInProject(LightEditFeatureUsagesUtil.ProjectStatus.Existing);
        }
        return (VirtualFile)result2.get();
    }

    @Nullable
    private static VirtualFile confirmOrChooseProjectDir(@Nullable VirtualFile suggestedRoot) {
        if (suggestedRoot != null) {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor2.setTitle(ApplicationBundle.message("light.edit.open.in.project.dialog.title", new Object[0]));
            return FileChooser.chooseFile(descriptor2, LightEditUtil.getProject(), suggestedRoot);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/intellij/ide/lightEdit/intentions/openInProject/ProjectRootSearchUtil", "findProjectRoot"));
    }
}

