/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.project;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.lightEdit.project.LightEditProjectImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.util.TimeoutUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightEditProjectManager {
    private static final Logger LOG = Logger.getInstance(LightEditProjectManager.class);
    private static final Object LOCK = new Object();
    private volatile LightEditProjectImpl myProject;

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Project getOrCreateProject() {
        LightEditProjectImpl project2 = this.myProject;
        if (project2 == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.myProject == null) {
                    this.myProject = LightEditProjectManager.createProject();
                }
                project2 = this.myProject;
            }
        }
        LightEditProjectImpl lightEditProjectImpl = project2;
        if (lightEditProjectImpl == null) {
            LightEditProjectManager.$$$reportNull$$$0(0);
        }
        return lightEditProjectImpl;
    }

    @NotNull
    private static LightEditProjectImpl createProject() {
        long start2 = System.nanoTime();
        LightEditProjectImpl project2 = new LightEditProjectImpl();
        LOG.info(LightEditProjectImpl.class.getSimpleName() + " loaded in " + TimeoutUtil.getDurationMillis(start2) + " ms");
        LightEditProjectImpl lightEditProjectImpl = project2;
        if (lightEditProjectImpl == null) {
            LightEditProjectManager.$$$reportNull$$$0(1);
        }
        return lightEditProjectImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LightEditProjectImpl project2 = this.myProject;
        if (project2 != null) {
            SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress(project2);
            ProjectManagerEx.getInstanceEx().forceCloseProject(project2);
        }
        Object object = LOCK;
        synchronized (object) {
            this.myProject = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/lightEdit/project/LightEditProjectManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

