/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.statusBar;

import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.ide.lightEdit.LightEditorManager;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightEditAutosaveWidget
implements StatusBarWidget,
StatusBarWidget.TextPresentation,
LightEditorListener {
    private final LightEditorManager myLightEditorManager;
    private StatusBar myStatusBar;

    public LightEditAutosaveWidget(@NotNull LightEditorManager editorManager) {
        if (editorManager == null) {
            LightEditAutosaveWidget.$$$reportNull$$$0(0);
        }
        this.myLightEditorManager = editorManager;
    }

    @Override
    @NotNull
    public String ID() {
        return "light.edit.autosave";
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            LightEditAutosaveWidget.$$$reportNull$$$0(1);
        }
        this.myStatusBar = statusBar;
        this.myLightEditorManager.addListener(this);
        this.myStatusBar.updateWidget(this.ID());
    }

    @Override
    public void dispose() {
    }

    @Override
    @Nullable
    public String getTooltipText() {
        return "Autosave Mode";
    }

    @Override
    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return event -> {
            Component widgetComp = event.getComponent();
            if (widgetComp != null) {
                MyModePanel modePanel = new MyModePanel();
                modePanel.setAutosaveSelected(LightEditService.getInstance().isAutosaveMode());
                ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder(modePanel, null);
                JBPopup popup2 = builder2.createPopup();
                popup2.show(new RelativePoint(widgetComp, new Point(0, -modePanel.getPreferredSize().height)));
            }
        };
    }

    @Override
    @NotNull
    public String getText() {
        String string = "Autosave: " + (LightEditService.getInstance().isAutosaveMode() ? "on" : "off");
        if (string == null) {
            LightEditAutosaveWidget.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public float getAlignment() {
        return 0.0f;
    }

    @Override
    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    @Override
    public void autosaveModeChanged(boolean isAutosave) {
        LightEditFeatureUsagesUtil.logAutosaveModeChanged(isAutosave);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/statusBar/LightEditAutosaveWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/statusBar/LightEditAutosaveWidget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyModePanel
    extends JPanel {
        private final JCheckBox myModeCb;

        MyModePanel() {
            this.setLayout(new GridBagLayout());
            this.setBorder(JBUI.Borders.empty(10));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            this.myModeCb = new JCheckBox();
            this.add((Component)this.myModeCb, c);
            c.gridx = 1;
            c.gridy = 0;
            c.insets = JBUI.insetsLeft(10);
            this.add((Component)new JLabel("Save changes automatically"), c);
            c.fill = 0;
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = JBUI.insets(5, 10, 0, 0);
            JLabel label2 = new JLabel("<html>All open files are saved on tab/window close<br>or on window deactivation.</html>");
            label2.setForeground(JBColor.GRAY);
            this.add((Component)label2, c);
            this.myModeCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LightEditService.getInstance().setAutosaveMode(myModeCb.isSelected());
                }
            });
        }

        public void setAutosaveSelected(boolean isSelected) {
            this.myModeCb.setSelected(isSelected);
        }
    }
}

