/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileDirPathFromParentMacro
extends Macro {
    private static final String PATH_DELIMITER = "/";

    @Override
    @NotNull
    public String getName() {
        return "FileDirPathFromParent";
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = IdeBundle.message("macro.file.directory.from.parent", new Object[0]);
        if (string == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public String expand(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Override
    public String expand(@NotNull DataContext dataContext, String ... args) throws Macro.ExecutionCancelledException {
        if (dataContext == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(2);
        }
        if (args == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(3);
        }
        if (args.length == 0) {
            return super.expand(dataContext, args);
        }
        VirtualFile dir = FileDirPathFromParentMacro.getVirtualDirOrParent(dataContext);
        if (dir == null) {
            return "";
        }
        String dirPath = dir.getPath();
        String surroundedSubDir = FileDirPathFromParentMacro.surroundWithSlashes(FileUtil.toSystemIndependentName(args[0]));
        String surroundedDirPath = FileDirPathFromParentMacro.surroundWithSlashes(dirPath);
        if (surroundedSubDir.length() == 1) {
            return FileUtil.toSystemDependentName(surroundedDirPath.substring(1));
        }
        int ind = FileDirPathFromParentMacro.lastIndexOf(surroundedDirPath, surroundedSubDir, surroundedDirPath.length(), !SystemInfo.isFileSystemCaseSensitive);
        if (ind >= 0) {
            return FileUtil.toSystemDependentName(surroundedDirPath.substring(ind + surroundedSubDir.length()));
        }
        return FileUtil.toSystemDependentName(dirPath.endsWith(PATH_DELIMITER) ? dirPath : dirPath + PATH_DELIMITER);
    }

    private static int lastIndexOf(@NotNull CharSequence buffer, @NotNull String pattern, int maxIndex, boolean ignoreCase) {
        if (buffer == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(5);
        }
        int patternLength = pattern.length();
        int end = buffer.length() - patternLength;
        if (maxIndex > end) {
            maxIndex = end;
        }
        for (int i = maxIndex; i >= 0; --i) {
            boolean found2 = true;
            for (int j = 0; j < patternLength; ++j) {
                if (ignoreCase) {
                    if (StringUtil.charsEqualIgnoreCase(pattern.charAt(j), buffer.charAt(i + j))) continue;
                    found2 = false;
                    break;
                }
                if (pattern.charAt(j) == buffer.charAt(i + j)) continue;
                found2 = false;
                break;
            }
            if (!found2) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static String surroundWithSlashes(@NotNull String path2) {
        boolean append;
        if (path2 == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(6);
        }
        if (path2.isEmpty()) {
            return PATH_DELIMITER;
        }
        boolean prepend = !path2.startsWith(PATH_DELIMITER);
        boolean bl = append = !path2.endsWith(PATH_DELIMITER);
        if (prepend && append) {
            String string = PATH_DELIMITER + path2 + PATH_DELIMITER;
            if (string == null) {
                FileDirPathFromParentMacro.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (prepend) {
            path2 = PATH_DELIMITER + path2;
        }
        if (append) {
            path2 = path2 + PATH_DELIMITER;
        }
        String string = path2;
        if (string == null) {
            FileDirPathFromParentMacro.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/FileDirPathFromParentMacro";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/FileDirPathFromParentMacro";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundWithSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "surroundWithSlashes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

