/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Macro {
    public static final ExtensionPointName<Macro> EP_NAME = ExtensionPointName.create("com.intellij.macro");
    protected String myCachedPreview;

    @NonNls
    @NotNull
    public abstract String getName();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public abstract String getDescription();

    @Nullable
    public abstract String expand(@NotNull DataContext var1) throws ExecutionCancelledException;

    @Nullable
    public String expand(@NotNull DataContext dataContext, String ... args) throws ExecutionCancelledException {
        if (dataContext == null) {
            Macro.$$$reportNull$$$0(0);
        }
        if (args == null) {
            Macro.$$$reportNull$$$0(1);
        }
        return this.expand(dataContext);
    }

    public void cachePreview(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            Macro.$$$reportNull$$$0(2);
        }
        try {
            this.myCachedPreview = this.expand(dataContext);
        }
        catch (ExecutionCancelledException e) {
            this.myCachedPreview = "";
        }
    }

    public final String preview() {
        return this.myCachedPreview;
    }

    @NotNull
    protected static String getPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            Macro.$$$reportNull$$$0(3);
        }
        String string = file2.getPath().replace('/', File.separatorChar);
        if (string == null) {
            Macro.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    static File getIOFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            Macro.$$$reportNull$$$0(5);
        }
        return new File(Macro.getPath(file2));
    }

    @Nullable
    protected static VirtualFile getVirtualDirOrParent(@NotNull DataContext dataContext) {
        VirtualFile vFile;
        if (dataContext == null) {
            Macro.$$$reportNull$$$0(6);
        }
        if ((vFile = CommonDataKeys.VIRTUAL_FILE.getData(dataContext)) != null && !vFile.isDirectory()) {
            vFile = vFile.getParent();
        }
        return vFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/Macro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/Macro";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cachePreview";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIOFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualDirOrParent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Silent
    extends Macro {
        private final Macro myDelegate;
        private final String myValue;

        public Silent(@NotNull Macro delegate, String value2) {
            if (delegate == null) {
                Silent.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myValue = value2;
        }

        @Override
        public String expand(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                Silent.$$$reportNull$$$0(1);
            }
            return this.myValue;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = this.myDelegate.getDescription();
            if (string == null) {
                Silent.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myDelegate.getName();
            if (string == null) {
                Silent.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/macro/Macro$Silent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/macro/Macro$Silent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "expand";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ExecutionCancelledException
    extends Exception {
    }
}

