/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.scratch.RootType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultNavBarExtension
extends AbstractNavBarModelExtension {
    @Override
    @Nullable
    public String getPresentableText(Object object) {
        if (object instanceof Project) {
            return ((Project)object).getName();
        }
        if (object instanceof Module) {
            return ((Module)object).getName();
        }
        if (object instanceof PsiFile) {
            VirtualFile file2 = ((PsiFile)object).getVirtualFile();
            return file2 != null ? file2.getPresentableName() : ((PsiFile)object).getName();
        }
        if (object instanceof PsiDirectory) {
            return ((PsiDirectory)object).getVirtualFile().getName();
        }
        if (object instanceof JdkOrderEntry) {
            return ((JdkOrderEntry)object).getJdkName();
        }
        if (object instanceof LibraryOrderEntry) {
            String libraryName = ((LibraryOrderEntry)object).getLibraryName();
            return libraryName != null ? libraryName : CodeInsightBundle.message("package.dependencies.library.node.text", new Object[0]);
        }
        if (object instanceof ModuleOrderEntry) {
            ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)object;
            return moduleOrderEntry.getModuleName();
        }
        return null;
    }

    @Override
    public PsiElement adjustElement(@NotNull PsiElement psiElement) {
        PsiFile containingFile;
        if (psiElement == null) {
            DefaultNavBarExtension.$$$reportNull$$$0(0);
        }
        if ((containingFile = psiElement.getContainingFile()) != null) {
            return containingFile;
        }
        return psiElement;
    }

    @Override
    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor2) {
        if (object instanceof Project) {
            return DefaultNavBarExtension.processChildren((Project)object, processor2);
        }
        if (object instanceof Module) {
            return DefaultNavBarExtension.processChildren((Module)object, processor2);
        }
        if (object instanceof PsiDirectoryContainer) {
            PsiDirectory[] psiDirectories;
            PsiDirectoryContainer psiPackage = (PsiDirectoryContainer)object;
            for (PsiDirectory psiDirectory : psiDirectories = ReadAction.compute(() -> rootElement instanceof Module ? psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)rootElement)) : psiPackage.getDirectories())) {
                if (DefaultNavBarExtension.processChildren(psiDirectory, rootElement, processor2)) continue;
                return false;
            }
            return true;
        }
        if (object instanceof PsiDirectory) {
            return DefaultNavBarExtension.processChildren((PsiDirectory)object, rootElement, processor2);
        }
        if (object instanceof PsiFileSystemItem) {
            return DefaultNavBarExtension.processChildren((PsiFileSystemItem)object, processor2);
        }
        return true;
    }

    private static boolean processChildren(Project object, Processor<Object> processor2) {
        return ReadAction.compute(() -> {
            for (Module module2 : ModuleManager.getInstance(object).getModules()) {
                if (ModuleType.isInternal(module2) || processor2.process(module2)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean processChildren(Module module2, Processor<Object> processor2) {
        VirtualFile[] roots;
        PsiManager psiManager = PsiManager.getInstance(module2.getProject());
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
        for (VirtualFile root : roots = moduleRootManager.getContentRoots()) {
            PsiDirectory psiDirectory = ReadAction.compute(() -> psiManager.findDirectory(root));
            if (psiDirectory == null || processor2.process(psiDirectory)) continue;
            return false;
        }
        return true;
    }

    private static boolean processChildren(PsiDirectory directory, @Nullable Object rootElement, Processor<Object> processor2) {
        return ReadAction.compute(() -> {
            Project project2 = directory.getProject();
            RootType scratchRootType = RootType.forFile(PsiUtilCore.getVirtualFile(directory));
            ModuleFileIndex moduleFileIndex = rootElement instanceof Module ? ModuleRootManager.getInstance((Module)rootElement).getFileIndex() : null;
            return directory.processChildren(child2 -> {
                VirtualFile childFile = PsiUtilCore.getVirtualFile(child2);
                if (childFile != null && scratchRootType != null && scratchRootType.isIgnored(project2, childFile)) {
                    return true;
                }
                if (childFile != null && moduleFileIndex != null && !moduleFileIndex.isInContent(childFile)) {
                    return true;
                }
                return processor2.process(child2);
            });
        });
    }

    private static boolean processChildren(PsiFileSystemItem object, final Processor<Object> processor2) {
        return ReadAction.compute(() -> object.processChildren(new PsiFileSystemItemProcessor(){

            @Override
            public boolean acceptItem(String name, boolean isDirectory) {
                return true;
            }

            @Override
            public boolean execute(@NotNull PsiFileSystemItem element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return processor2.process(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/navigationToolbar/DefaultNavBarExtension$1", "execute"));
            }
        }));
    }

    @Override
    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            PsiDirectory containingDirectory = containingFile.getContainingDirectory();
            if (containingDirectory != null) {
                return containingDirectory;
            }
        } else {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory psiDirectory = (PsiDirectory)psiElement;
                Project project2 = psiElement.getProject();
                PsiDirectory parentDirectory = psiDirectory.getParentDirectory();
                if (parentDirectory == null) {
                    VirtualFile jar = VfsUtil.getLocalFile(psiDirectory.getVirtualFile());
                    if (ProjectRootManager.getInstance(project2).getFileIndex().isInContent(jar)) {
                        parentDirectory = PsiManager.getInstance(project2).findDirectory(jar.getParent());
                    }
                }
                return parentDirectory;
            }
            if (psiElement instanceof PsiFileSystemItem) {
                PsiDirectory parentDirectory;
                VirtualFile virtualFile2 = ((PsiFileSystemItem)psiElement).getVirtualFile();
                if (virtualFile2 == null) {
                    return null;
                }
                PsiManager psiManager = psiElement.getManager();
                PsiFileSystemItem resultElement = virtualFile2.isDirectory() ? psiManager.findDirectory(virtualFile2) : psiManager.findFile(virtualFile2);
                if (resultElement == null) {
                    return null;
                }
                VirtualFile parentVFile = virtualFile2.getParent();
                if (parentVFile != null && (parentDirectory = psiManager.findDirectory(parentVFile)) != null) {
                    return parentDirectory;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ide/navigationToolbar/DefaultNavBarExtension", "adjustElement"));
    }
}

