/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarBorder;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavBarRootPaneExtension
extends IdeRootPaneNorthExtension {
    private JComponent myWrapperPanel;
    @NonNls
    public static final String NAV_BAR = "NavBar";
    private Project myProject;
    private NavBarPanel myNavigationBar;
    private JPanel myRunPanel;
    private final boolean myNavToolbarGroupExist;
    private JScrollPane myScrollPane;

    public NavBarRootPaneExtension(@NotNull Project project2) {
        if (project2 == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myProject.getMessageBus().connect().subscribe(UISettingsListener.TOPIC, uiSettings -> this.toggleRunPanel(!uiSettings.getShowMainToolbar() && uiSettings.getShowNavigationBar() && !uiSettings.getPresentationMode()));
        this.myNavToolbarGroupExist = NavBarRootPaneExtension.runToolbarExists();
    }

    @Override
    public void revalidate() {
        UISettings settings = UISettings.getInstance();
        if (!settings.getShowMainToolbar() && settings.getShowNavigationBar() && !UISettings.getInstance().getPresentationMode()) {
            this.toggleRunPanel(false);
            this.toggleRunPanel(true);
        }
    }

    @Override
    public IdeRootPaneNorthExtension copy() {
        return new NavBarRootPaneExtension(this.myProject);
    }

    public boolean isMainToolbarVisible() {
        return !UISettings.getInstance().getPresentationMode() && (UISettings.getInstance().getShowMainToolbar() || !this.myNavToolbarGroupExist);
    }

    public static boolean runToolbarExists() {
        AnAction correctedAction = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
        return correctedAction instanceof DefaultActionGroup && ((DefaultActionGroup)correctedAction).getChildrenCount() > 0 || correctedAction instanceof CustomisedActionGroup && ((CustomisedActionGroup)correctedAction).getFirstAction() != null;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        if (this.myWrapperPanel == null) {
            this.myWrapperPanel = new NavBarWrapperPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    NavBarUIManager.getUI().doPaintWrapperPanel((Graphics2D)g, this.getBounds(), NavBarRootPaneExtension.this.isMainToolbarVisible());
                }

                @Override
                public Insets getInsets() {
                    return NavBarUIManager.getUI().getWrapperPanelInsets(super.getInsets());
                }
            };
            this.addNavigationBarPanel(this.myWrapperPanel);
            this.toggleRunPanel(!UISettings.getInstance().getShowMainToolbar() && !UISettings.getInstance().getPresentationMode());
        }
        JComponent jComponent = this.myWrapperPanel;
        if (jComponent == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private void addNavigationBarPanel(JComponent wrapperPanel) {
        wrapperPanel.add((Component)this.buildNavBarPanel(), "Center");
    }

    private static void alignVertically(Container container2) {
        if (container2.getComponentCount() == 1) {
            Component c = container2.getComponent(0);
            Insets insets = container2.getInsets();
            Dimension d = c.getPreferredSize();
            Rectangle r = container2.getBounds();
            c.setBounds(insets.left, (r.height - d.height - insets.top - insets.bottom) / 2 + insets.top, r.width - insets.left - insets.right, d.height);
        }
    }

    private void toggleRunPanel(boolean show2) {
        if (show2 && this.myRunPanel == null && NavBarRootPaneExtension.runToolbarExists()) {
            ActionManager manager = ActionManager.getInstance();
            AnAction toolbarRunGroup = CustomActionsSchema.getInstance().getCorrectedAction("NavBarToolBar");
            if (toolbarRunGroup instanceof ActionGroup && this.myWrapperPanel != null) {
                ActionToolbar actionToolbar = manager.createActionToolbar("NavBarToolbar", (ActionGroup)toolbarRunGroup, true);
                JComponent component2 = actionToolbar.getComponent();
                this.myRunPanel = new JPanel(new BorderLayout()){

                    @Override
                    public void doLayout() {
                        NavBarRootPaneExtension.alignVertically(this);
                    }
                };
                this.myRunPanel.setOpaque(false);
                this.myRunPanel.add((Component)component2, "Center");
                boolean needGap = NavBarRootPaneExtension.isNeedGap(toolbarRunGroup);
                this.myRunPanel.setBorder(JBUI.Borders.emptyLeft(needGap ? 5 : 1));
                this.myWrapperPanel.add((Component)this.myRunPanel, "East");
            }
        } else if (!show2 && this.myRunPanel != null) {
            this.myWrapperPanel.remove(this.myRunPanel);
            this.myRunPanel = null;
        }
    }

    private boolean isUndocked() {
        Window ancestor = SwingUtilities.getWindowAncestor(this.myWrapperPanel);
        return ancestor != null && !(ancestor instanceof IdeFrameImpl) || !UISettings.getInstance().getShowMainToolbar() || !UISettings.getInstance().getPresentationMode();
    }

    private static boolean isNeedGap(AnAction group) {
        AnAction firstAction = NavBarRootPaneExtension.getFirstAction(group);
        return firstAction instanceof ComboBoxAction;
    }

    @Nullable
    private static AnAction getFirstAction(AnAction group) {
        if (group instanceof DefaultActionGroup) {
            AnAction firstAction = null;
            for (AnAction action2 : ((DefaultActionGroup)group).getChildActionsOrStubs()) {
                if (!(action2 instanceof DefaultActionGroup)) {
                    if (action2 instanceof Separator || action2 instanceof ActionGroup) continue;
                    firstAction = action2;
                    break;
                }
                firstAction = NavBarRootPaneExtension.getFirstAction(action2);
                if (firstAction != null) break;
            }
            return firstAction;
        }
        if (group instanceof CustomisedActionGroup) {
            return ((CustomisedActionGroup)group).getFirstAction();
        }
        return null;
    }

    private JComponent buildNavBarPanel() {
        this.myNavigationBar = new NavBarPanel(this.myProject, true);
        this.myWrapperPanel.putClientProperty("NavBarPanel", this.myNavigationBar);
        this.myNavigationBar.getModel().setFixedComponent(true);
        this.myScrollPane = ScrollPaneFactory.createScrollPane(this.myNavigationBar);
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                Insets insets = this.getInsets();
                Rectangle r = navBar.getBounds();
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.translate(r.x, r.y);
                Rectangle rectangle = new Rectangle(0, 0, r.width + insets.left + insets.right, r.height + insets.top + insets.bottom);
                NavBarUIManager.getUI().doPaintNavBarPanel(g2d, rectangle, NavBarRootPaneExtension.this.isMainToolbarVisible(), NavBarRootPaneExtension.this.isUndocked());
                g2d.dispose();
            }

            @Override
            public void doLayout() {
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                int x = insets.left;
                if (NavBarRootPaneExtension.this.myScrollPane == null) {
                    return;
                }
                JScrollPane navBar = NavBarRootPaneExtension.this.myScrollPane;
                Dimension preferredSize = ((Component)navBar).getPreferredSize();
                navBar.setBounds(x, (r.height - preferredSize.height) / 2, r.width - insets.left - insets.right, preferredSize.height);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setOpaque(true);
                if (NavBarRootPaneExtension.this.myScrollPane == null || NavBarRootPaneExtension.this.myNavigationBar == null) {
                    return;
                }
                NavBarRootPaneExtension.this.myScrollPane.setVerticalScrollBarPolicy(21);
                NavBarRootPaneExtension.this.myScrollPane.setHorizontalScrollBar(null);
                NavBarRootPaneExtension.this.myScrollPane.setBorder(new NavBarBorder());
                NavBarRootPaneExtension.this.myScrollPane.setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.getViewport().setOpaque(false);
                NavBarRootPaneExtension.this.myScrollPane.setViewportBorder(null);
                NavBarRootPaneExtension.this.myNavigationBar.setBorder(null);
            }
        };
        panel2.add((Component)this.myScrollPane, "Center");
        panel2.updateUI();
        return panel2;
    }

    @Override
    public void uiSettingsChanged(@NotNull UISettings settings) {
        Component c;
        if (settings == null) {
            NavBarRootPaneExtension.$$$reportNull$$$0(2);
        }
        if (this.myNavigationBar == null) {
            return;
        }
        this.myNavigationBar.updateState(settings.getShowNavigationBar());
        this.myWrapperPanel.setVisible(settings.getShowNavigationBar() && !UISettings.getInstance().getPresentationMode());
        this.myWrapperPanel.revalidate();
        this.myNavigationBar.revalidate();
        this.myWrapperPanel.repaint();
        if (this.myWrapperPanel.getComponentCount() > 0 && (c = this.myWrapperPanel.getComponent(0)) instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
    }

    @Override
    @NotNull
    public String getKey() {
        return NAV_BAR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/navigationToolbar/NavBarRootPaneExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarRootPaneExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NavBarWrapperPanel
    extends JPanel {
        public NavBarWrapperPanel(LayoutManager layout) {
            super(layout);
            this.setName("navbar");
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return JBSwingUtilities.runGlobalCGTransform(this, super.getComponentGraphics(graphics));
        }
    }
}

