/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class NavBarUpdateQueue
extends MergingUpdateQueue {
    private final AtomicBoolean myModelUpdating = new AtomicBoolean(Boolean.FALSE);
    private final Alarm myUserActivityAlarm = new Alarm(this);
    private Runnable myRunWhenListRebuilt;
    private final Runnable myUserActivityAlarmRunnable = () -> this.processUserActivity();
    private final NavBarPanel myPanel;

    public NavBarUpdateQueue(NavBarPanel panel2) {
        super("NavBar", Registry.intValue("navBar.updateMergeTime"), true, panel2, panel2);
        this.myPanel = panel2;
        this.setTrackUiActivity(true);
        IdeEventQueue.getInstance().addActivityListener(() -> this.restartRebuild(), panel2);
    }

    private void requestModelUpdate(final @Nullable DataContext context, final @Nullable Object object, boolean requeue) {
        if (this.myModelUpdating.getAndSet(true) && !requeue) {
            return;
        }
        this.cancelAllUpdates();
        this.queue(new AfterModelUpdate(ID.MODEL){

            @Override
            public void run() {
                if (context != null || object != null) {
                    NavBarUpdateQueue.this.requestModelUpdateFromContextOrObject(context, object);
                } else {
                    DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> NavBarUpdateQueue.this.requestModelUpdateFromContextOrObject(dataContext, null));
                }
            }

            @Override
            public void setRejected() {
                super.setRejected();
                NavBarUpdateQueue.this.myModelUpdating.set(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestModelUpdateFromContextOrObject(DataContext dataContext, Object object) {
        try {
            NavBarModel model = this.myPanel.getModel();
            if (dataContext != null) {
                if (CommonDataKeys.PROJECT.getData(dataContext) != this.myPanel.getProject() || this.myPanel.isNodePopupActive()) {
                    this.requestModelUpdate(null, this.myPanel.getContextObject(), true);
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor(this.myPanel);
                if (window != null && !window.isFocused()) {
                    model.updateModel(DataManager.getInstance().getDataContext(this.myPanel));
                } else {
                    model.updateModel(dataContext);
                }
            } else {
                model.updateModel(object);
            }
            this.queueRebuildUi();
        }
        finally {
            this.myModelUpdating.set(false);
        }
    }

    void restartRebuild() {
        this.myUserActivityAlarm.cancelAllRequests();
        if (!this.myUserActivityAlarm.isDisposed()) {
            this.myUserActivityAlarm.addRequest(this.myUserActivityAlarmRunnable, Registry.intValue("navBar.userActivityMergeTime"));
        }
    }

    private void processUserActivity() {
        if (this.myPanel == null || !this.myPanel.isShowing()) {
            return;
        }
        Project project2 = this.myPanel.getProject();
        IdeFocusManager.getInstance(project2).doWhenFocusSettlesDown(() -> {
            Window wnd = SwingUtilities.windowForComponent(this.myPanel);
            if (wnd == null) {
                return;
            }
            Component focus = null;
            if (!wnd.isActive()) {
                IdeFrame frame = ComponentUtil.getParentOfType(IdeFrame.class, this.myPanel);
                if (frame != null) {
                    focus = IdeFocusManager.getInstance(project2).getLastFocusedFor((Window)((Object)frame));
                }
            } else {
                Dialog dialog2;
                Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (window instanceof Dialog && (dialog2 = (Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(this.myPanel, dialog2)) {
                    return;
                }
            }
            if (focus != null && focus.isShowing()) {
                if (!this.myPanel.isFocused() && !this.myPanel.isNodePopupActive()) {
                    this.requestModelUpdate(DataManager.getInstance().getDataContext(focus), null, false);
                }
            } else if (wnd.isActive()) {
                if (this.myPanel.allowNavItemsFocus() && (this.myPanel.isFocused() || this.myPanel.isNodePopupActive())) {
                    return;
                }
                this.requestModelUpdate(null, this.myPanel.getContextObject(), false);
            }
        });
    }

    public void queueModelUpdate(DataContext context) {
        this.requestModelUpdate(context, null, false);
    }

    public void queueModelUpdateFromFocus() {
        this.queueModelUpdateFromFocus(false);
    }

    public void queueModelUpdateFromFocus(boolean requeue) {
        this.requestModelUpdate(null, this.myPanel.getContextObject(), requeue);
    }

    public void queueModelUpdateForObject(Object object) {
        this.requestModelUpdate(null, object, false);
    }

    public void queueRebuildUi() {
        this.queue(new AfterModelUpdate(ID.UI){

            @Override
            protected void after() {
                NavBarUpdateQueue.this.rebuildUi();
            }
        });
        this.queueRevalidate(null);
    }

    public void rebuildUi() {
        if (!this.myPanel.isRebuildUiNeeded()) {
            return;
        }
        this.myPanel.clearItems();
        for (int index = 0; index < this.myPanel.getModel().size(); ++index) {
            Object object = this.myPanel.getModel().get(index);
            NavBarItem label2 = new NavBarItem(this.myPanel, object, index, null);
            this.myPanel.installActions(index, label2);
            this.myPanel.addItem(label2);
        }
        this.rebuildComponent();
        if (this.myRunWhenListRebuilt != null) {
            Runnable r = this.myRunWhenListRebuilt;
            this.myRunWhenListRebuilt = null;
            r.run();
        }
    }

    private void rebuildComponent() {
        this.myPanel.removeAll();
        for (NavBarItem item : this.myPanel.getItems()) {
            this.myPanel.add(item);
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
        this.queueAfterAll(() -> this.myPanel.scrollSelectionToVisible(), ID.SCROLL_TO_VISIBLE);
    }

    private void queueRevalidate(final @Nullable Runnable after2) {
        this.queue(new AfterModelUpdate(ID.REVALIDATE){

            @Override
            protected void after() {
                LightweightHint hint = NavBarUpdateQueue.this.myPanel.getHint();
                if (hint != null) {
                    NavBarUpdateQueue.this.myPanel.getHintContainerShowPoint().doWhenDone(relativePoint -> {
                        hint.setSize(NavBarUpdateQueue.this.myPanel.getPreferredSize());
                        hint.setLocation((RelativePoint)relativePoint);
                        if (after2 != null) {
                            after2.run();
                        }
                    });
                } else if (after2 != null) {
                    after2.run();
                }
            }
        });
    }

    void queueSelect(final Runnable runnable2) {
        this.queue(new AfterModelUpdate(ID.SELECT){

            @Override
            protected void after() {
                runnable2.run();
            }
        });
    }

    void queueAfterAll(final Runnable runnable2, ID id2) {
        this.queue(new AfterModelUpdate(id2){

            @Override
            protected void after() {
                if (runnable2 != null) {
                    runnable2.run();
                }
            }
        });
    }

    public void queueTypeAheadDone(final ActionCallback done) {
        this.queue(new AfterModelUpdate(ID.TYPE_AHEAD_FINISHED){

            @Override
            protected void after() {
                done.setDone();
            }
        });
    }

    boolean isUpdating() {
        return this.myModelUpdating.get();
    }

    public static enum ID {
        MODEL(0),
        UI(1),
        REVALIDATE(2),
        SELECT(3),
        SCROLL_TO_VISIBLE(4),
        SHOW_HINT(4),
        REQUEST_FOCUS(4),
        NAVIGATE_INSIDE(4),
        TYPE_AHEAD_FINISHED(5);

        private final int myPriority;

        private ID(int priority) {
            this.myPriority = priority;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }

    private abstract class AfterModelUpdate
    extends Update {
        private AfterModelUpdate(ID id2) {
            super((Object)id2.name(), id2.getPriority());
        }

        @Override
        public void run() {
            if (NavBarUpdateQueue.this.myModelUpdating.get()) {
                NavBarUpdateQueue.this.queue(this);
            } else {
                this.after();
            }
        }

        protected void after() {
        }
    }
}

