/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginXmlFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.Interner;
import java.text.DateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DescriptorListLoadingContext
implements AutoCloseable {
    static final boolean unitTestWithBundledPlugins = Boolean.getBoolean("idea.run.tests.with.bundled.plugins");
    static final int IS_PARALLEL = 1;
    static final int IGNORE_MISSING_INCLUDE = 2;
    static final int SKIP_DISABLED_PLUGINS = 4;
    private static final Logger LOG = PluginManagerCore.getLogger();
    @NotNull
    private final ExecutorService executorService;
    private final ConcurrentLinkedQueue<SafeJdomFactory[]> toDispose;
    private final Supplier<PluginXmlFactory> xmlFactorySupplier;
    @Nullable
    private final ThreadLocal<PluginXmlFactory[]> threadLocalXmlFactory;
    private final int maxThreads;
    @NotNull
    final PluginLoadingResult result;
    @NotNull
    final Set<PluginId> disabledPlugins;
    private volatile String defaultVersion;
    final boolean ignoreMissingInclude;
    final boolean skipDisabledPlugins;
    final boolean readConditionalConfigDirectlyIfPossible = false;
    boolean usePluginClassLoader;

    @NotNull
    public static DescriptorListLoadingContext createSingleDescriptorContext(@NotNull Set<PluginId> disabledPlugins) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(0);
        }
        return new DescriptorListLoadingContext(0, disabledPlugins, new PluginLoadingResult(Collections.emptyMap(), PluginManagerCore.getBuildNumber()));
    }

    DescriptorListLoadingContext(int flags, @NotNull Set<PluginId> disabledPlugins, @NotNull PluginLoadingResult result2) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(2);
        }
        this.readConditionalConfigDirectlyIfPossible = false;
        this.usePluginClassLoader = !PluginManagerCore.isUnitTestMode || unitTestWithBundledPlugins;
        this.result = result2;
        this.disabledPlugins = disabledPlugins;
        this.ignoreMissingInclude = (flags & 2) == 2;
        this.skipDisabledPlugins = (flags & 4) == 4;
        int n = this.maxThreads = (flags & 1) == 1 ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (this.maxThreads > 1) {
            this.executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor("PluginManager Loader", this.maxThreads, false);
            this.toDispose = new ConcurrentLinkedQueue();
            this.threadLocalXmlFactory = ThreadLocal.withInitial(() -> {
                PluginXmlFactory factory = new PluginXmlFactory();
                PluginXmlFactory[] ref = new PluginXmlFactory[]{factory};
                this.toDispose.add(ref);
                return ref;
            });
            this.xmlFactorySupplier = () -> this.threadLocalXmlFactory.get()[0];
        } else {
            this.executorService = ConcurrencyUtil.newSameThreadExecutorService();
            this.toDispose = null;
            this.threadLocalXmlFactory = null;
            PluginXmlFactory factory = new PluginXmlFactory();
            this.xmlFactorySupplier = () -> factory;
        }
    }

    @NotNull
    Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @NotNull
    ExecutorService getExecutorService() {
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(4);
        }
        return executorService;
    }

    @NotNull
    SafeJdomFactory getXmlFactory() {
        SafeJdomFactory safeJdomFactory = this.xmlFactorySupplier.get();
        if (safeJdomFactory == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(5);
        }
        return safeJdomFactory;
    }

    @Override
    public void close() {
        if (this.threadLocalXmlFactory == null) {
            return;
        }
        if (this.maxThreads <= 1) {
            this.threadLocalXmlFactory.remove();
            return;
        }
        this.executorService.execute(() -> {
            for (SafeJdomFactory[] ref : this.toDispose) {
                ref[0] = null;
            }
        });
        this.executorService.shutdown();
    }

    @NotNull
    public Interner<String> getStringInterner() {
        Interner<String> interner = this.xmlFactorySupplier.get().stringInterner;
        if (interner == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(6);
        }
        return interner;
    }

    @NotNull
    public String getDefaultVersion() {
        String result2 = this.defaultVersion;
        if (result2 == null) {
            this.defaultVersion = result2 = this.result.productBuildNumber.asStringWithoutProductCode();
        }
        String string = result2;
        if (string == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public DateFormat getDateParser() {
        DateFormat dateFormat = this.xmlFactorySupplier.get().releaseDateFormat;
        if (dateFormat == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(8);
        }
        return dateFormat;
    }

    @NotNull
    public List<String> getVisitedFiles() {
        List<String> list2 = this.xmlFactorySupplier.get().visitedFiles;
        if (list2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringInterner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateParser";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSingleDescriptorContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

