/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DynamicPluginVfsListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/plugins/DynamicPluginVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "()V", "findPluginByPath", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "path", "", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.platform.ide.impl"})
public final class DynamicPluginVfsListener
implements AsyncFileListener {
    @Override
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Iterable $this$mapTo$iv$iv;
        IdeaPluginDescriptorImpl it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(events, (String)"events");
        if (!SystemProperties.is("idea.auto.reload.plugins")) {
            return null;
        }
        boolean bl = false;
        HashSet<IdeaPluginDescriptorImpl> pluginsToReload = new HashSet<IdeaPluginDescriptorImpl>();
        for (VFileEvent vFileEvent : events) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl;
            if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
            String string = ((VFileContentChangeEvent)vFileEvent).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.path");
            if (this.findPluginByPath(string) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            IdeaPluginDescriptorImpl it2 = ideaPluginDescriptorImpl;
            boolean bl4 = false;
            pluginsToReload.add(it2);
        }
        Iterable $this$filter$iv = pluginsToReload;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)element$iv$iv;
            boolean bl5 = false;
            if (!it.isEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginEnabler.loadFullDescriptor(it);
            collection.add(ideaPluginDescriptorImpl);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IdeaPluginDescriptorImpl)element$iv$iv;
            boolean bl7 = false;
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorImpl, (String)"it");
            if (!DynamicPlugins.allowLoadUnloadWithoutRestart$default(ideaPluginDescriptorImpl, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        if (list2.isEmpty()) {
            return null;
        }
        return new AsyncFileListener.ChangeApplier(list2){
            final /* synthetic */ List $descriptorsToReload;

            public void afterVfsChange() {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ prepareChange.2 this$0;

                    public final void run() {
                        boolean bl = false;
                        List reloaded2 = new ArrayList<E>();
                        Iterator<E> iterator2 = this.this$0.$descriptorsToReload.iterator();
                        while (iterator2.hasNext()) {
                            IdeaPluginDescriptorImpl pluginDescriptor;
                            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = pluginDescriptor = (IdeaPluginDescriptorImpl)iterator2.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorImpl, (String)"pluginDescriptor");
                            if (!DynamicPlugins.unloadPlugin$default(ideaPluginDescriptorImpl, false, true, false, 10, null)) continue;
                            String string = pluginDescriptor.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pluginDescriptor.name");
                            reloaded2.add(string);
                            DynamicPlugins.loadPlugin(pluginDescriptor, false);
                        }
                        Collection collection = reloaded2;
                        boolean bl2 = false;
                        if (!collection.isEmpty()) {
                            DynamicPlugins.INSTANCE.notify$intellij_platform_ide_impl(CollectionsKt.joinToString$default((Iterable)reloaded2, null, null, null, (int)0, null, null, (int)63, null) + " reloaded successfully", NotificationType.INFORMATION);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$descriptorsToReload = $captured_local_variable$0;
            }
        };
    }

    private final IdeaPluginDescriptorImpl findPluginByPath(String path2) {
        IdeaPluginDescriptor ideaPluginDescriptor;
        block2: {
            if (!FileUtil.isAncestor(PathManager.getPluginsPath(), path2, false)) {
                return null;
            }
            IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManager.getPlugins();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorArray, (String)"PluginManager.getPlugins()");
            IdeaPluginDescriptor[] $this$firstOrNull$iv = ideaPluginDescriptorArray;
            boolean $i$f$firstOrNull = false;
            IdeaPluginDescriptor[] ideaPluginDescriptorArray2 = $this$firstOrNull$iv;
            int n = ideaPluginDescriptorArray2.length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptor element$iv;
                IdeaPluginDescriptor it = element$iv = ideaPluginDescriptorArray2[i];
                boolean bl = false;
                IdeaPluginDescriptor ideaPluginDescriptor2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor2, (String)"it");
                File file2 = ideaPluginDescriptor2.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.path");
                if (!FileUtil.isAncestor(file2.getAbsolutePath(), path2, false)) continue;
                ideaPluginDescriptor = element$iv;
                break block2;
            }
            ideaPluginDescriptor = null;
        }
        return (IdeaPluginDescriptorImpl)ideaPluginDescriptor;
    }

    public DynamicPluginVfsListener() {
        if (SystemProperties.is("idea.auto.reload.plugins")) {
            String string = PathManager.getPluginsPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathManager.getPluginsPath()");
            String pluginsPath = string;
            LocalFileSystem.getInstance().addRootToWatch(pluginsPath, true);
            VirtualFile pluginsRoot = LocalFileSystem.getInstance().findFileByPath(pluginsPath);
            if (pluginsRoot != null) {
                VfsUtilCore.processFilesRecursively(pluginsRoot, 1.INSTANCE);
            }
        }
    }
}

