/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginError;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Interner;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.ref.GCWatcher;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor,
PluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    static final String APPLICATION_SERVICE = "com.intellij.applicationService";
    static final String PROJECT_SERVICE = "com.intellij.projectService";
    static final String MODULE_SERVICE = "com.intellij.moduleService";
    private final Path myPath;
    private Path myBasePath;
    private final boolean myBundled;
    private String myName;
    private PluginId myId;
    private volatile String myDescription;
    @Nullable
    private String myProductCode;
    @Nullable
    private Date myReleaseDate;
    private int myReleaseVersion;
    private boolean myIsLicenseOptional;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myCategory;
    private String myUrl;
    private PluginId[] myDependencies;
    private PluginId[] myOptionalDependencies;
    private List<PluginDependency> myPluginDependencies;
    transient Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalConfigs;
    transient List<Path> jarFiles;
    @Nullable
    private List<Element> myActionElements;
    @Nullable
    private THashMap<String, List<Element>> myExtensions;
    private final ContainerDescriptor myAppContainerDescriptor;
    private final ContainerDescriptor myProjectContainerDescriptor;
    private final ContainerDescriptor myModuleContainerDescriptor;
    private List<PluginId> myModules;
    private ClassLoader myLoader;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myImplementationDetail;
    boolean myRequireRestart;
    private String mySinceBuild;
    private String myUntilBuild;
    private boolean myEnabled;
    private boolean myDeleted;
    private boolean myExtensionsCleared;
    boolean incomplete;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull Path pluginPath, boolean bundled) {
        if (pluginPath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myDependencies = PluginId.EMPTY_ARRAY;
        this.myOptionalDependencies = PluginId.EMPTY_ARRAY;
        this.myAppContainerDescriptor = new ContainerDescriptor();
        this.myProjectContainerDescriptor = new ContainerDescriptor();
        this.myModuleContainerDescriptor = new ContainerDescriptor();
        this.myEnabled = true;
        this.myExtensionsCleared = false;
        this.myPath = pluginPath;
        this.myBundled = bundled;
    }

    @NotNull
    @ApiStatus.Internal
    public ContainerDescriptor getApp() {
        ContainerDescriptor containerDescriptor = this.myAppContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(1);
        }
        return containerDescriptor;
    }

    @NotNull
    @ApiStatus.Internal
    public ContainerDescriptor getProject() {
        ContainerDescriptor containerDescriptor = this.myProjectContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(2);
        }
        return containerDescriptor;
    }

    @NotNull
    @ApiStatus.Internal
    public ContainerDescriptor getModule() {
        ContainerDescriptor containerDescriptor = this.myModuleContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(3);
        }
        return containerDescriptor;
    }

    @Override
    public File getPath() {
        return this.myPath.toFile();
    }

    @Override
    @NotNull
    public Path getPluginPath() {
        Path path2 = this.myPath;
        if (path2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(4);
        }
        return path2;
    }

    public Path getBasePath() {
        return this.myBasePath;
    }

    @Deprecated
    public void loadFromFile(@NotNull File file2, @Nullable SafeJdomFactory factory, boolean ignoreMissingInclude) throws IOException, JDOMException {
        if (file2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(5);
        }
        PluginManager.loadDescriptorFromFile(this, file2.toPath(), factory, ignoreMissingInclude, PluginManagerCore.disabledPlugins());
    }

    public boolean readExternal(@NotNull Element element2, @NotNull Path basePath, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorLoadingContext context, @NotNull IdeaPluginDescriptorImpl rootDescriptor) {
        if (element2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(6);
        }
        if (basePath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(7);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(8);
        }
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(9);
        }
        if (rootDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(10);
        }
        this.myBasePath = basePath;
        if (JDOMUtil.isEmpty(element2)) {
            this.markAsIncomplete(context, "Empty plugin descriptor", null);
            return false;
        }
        XmlReader.readIdAndName(this, element2);
        if (this.myId != null && context.isPluginDisabled(this.myId)) {
            this.markAsIncomplete(context, null, null);
        } else {
            PathBasedJdomXIncluder.resolveNonXIncludeElement(element2, basePath, context, pathResolver);
            if (this.myId == null || this.myName == null) {
                XmlReader.readIdAndName(this, element2);
                if (this.myId != null && context.isPluginDisabled(this.myId)) {
                    this.markAsIncomplete(context, null, null);
                }
            }
        }
        if (this.incomplete) {
            Element productElement;
            this.myDescriptionChildText = element2.getChildTextTrim("description");
            this.myCategory = element2.getChildTextTrim("category");
            this.myVersion = element2.getChildTextTrim("version");
            if (context.parentContext.getLogger().isDebugEnabled()) {
                context.parentContext.getLogger().debug("Skipping reading of " + this.myId + " from " + basePath + " (reason: disabled)");
            }
            List<Element> dependsElements = element2.getChildren("depends");
            for (Element dependsElement : dependsElements) {
                this.readPluginDependency(basePath, context, dependsElement);
            }
            if (this.myPluginDependencies != null) {
                int size = XmlReader.collapseDuplicateDependencies(this.myPluginDependencies);
                XmlReader.collectDependentPluginIds(this, size);
            }
            if ((productElement = element2.getChild("product-descriptor")) != null) {
                this.readProduct(context, productElement);
            }
            return false;
        }
        XmlReader.readMetaInfo(this, element2);
        this.myPluginDependencies = null;
        for (Content content2 : element2.getContent()) {
            if (!(content2 instanceof Element)) continue;
            boolean clearContent = true;
            Element child2 = (Element)content2;
            switch (child2.getName()) {
                case "extensions": {
                    XmlReader.readExtensions(this, context.parentContext, child2);
                    break;
                }
                case "extensionPoints": {
                    XmlReader.readExtensionPoints(rootDescriptor, this, child2);
                    break;
                }
                case "actions": {
                    if (this.myActionElements == null) {
                        this.myActionElements = new ArrayList<Element>(child2.getChildren());
                    } else {
                        this.myActionElements.addAll(child2.getChildren());
                    }
                    clearContent = child2.getAttributeValue("resource-bundle") == null;
                    break;
                }
                case "module": {
                    String moduleName = child2.getAttributeValue("value");
                    if (moduleName == null) break;
                    if (this.myModules == null) {
                        this.myModules = Collections.singletonList(PluginId.getId(moduleName));
                        break;
                    }
                    if (this.myModules.size() == 1) {
                        List<PluginId> singleton = this.myModules;
                        this.myModules = new ArrayList<PluginId>(4);
                        this.myModules.addAll(singleton);
                    }
                    this.myModules.add(PluginId.getId(moduleName));
                    break;
                }
                case "application-components": {
                    IdeaPluginDescriptorImpl.readComponents(child2, this.myAppContainerDescriptor);
                    break;
                }
                case "project-components": {
                    IdeaPluginDescriptorImpl.readComponents(child2, this.myProjectContainerDescriptor);
                    break;
                }
                case "module-components": {
                    IdeaPluginDescriptorImpl.readComponents(child2, this.myModuleContainerDescriptor);
                    break;
                }
                case "applicationListeners": {
                    XmlReader.readListeners(this, child2, this.myAppContainerDescriptor);
                    break;
                }
                case "projectListeners": {
                    XmlReader.readListeners(this, child2, this.myProjectContainerDescriptor);
                    break;
                }
                case "depends": {
                    if (this.readPluginDependency(basePath, context, child2)) break;
                    return false;
                }
                case "category": {
                    this.myCategory = StringUtil.nullize(child2.getTextTrim());
                    break;
                }
                case "change-notes": {
                    this.myChangeNotes = StringUtil.nullize(child2.getTextTrim());
                    break;
                }
                case "version": {
                    this.myVersion = StringUtil.nullize(child2.getTextTrim());
                    break;
                }
                case "description": {
                    this.myDescriptionChildText = StringUtil.nullize(child2.getTextTrim());
                    break;
                }
                case "resource-bundle": {
                    String value2 = StringUtil.nullize(child2.getTextTrim());
                    if (this.myResourceBundleBaseName != null && !Comparing.equal(this.myResourceBundleBaseName, value2)) {
                        context.parentContext.getLogger().warn("Resource bundle redefinition for plugin '" + rootDescriptor.getPluginId() + "'. Old value: " + this.myResourceBundleBaseName + ", new value: " + value2);
                    }
                    this.myResourceBundleBaseName = value2;
                    break;
                }
                case "product-descriptor": {
                    this.readProduct(context, child2);
                    break;
                }
                case "vendor": {
                    this.myVendor = StringUtil.nullize(child2.getTextTrim());
                    this.myVendorEmail = StringUtil.nullize(child2.getAttributeValue("email"));
                    this.myVendorUrl = StringUtil.nullize(child2.getAttributeValue("url"));
                    break;
                }
                case "idea-version": {
                    this.mySinceBuild = StringUtil.nullize(child2.getAttributeValue("since-build"));
                    this.myUntilBuild = StringUtil.nullize(child2.getAttributeValue("until-build"));
                    if (this.checkCompatibility(context)) break;
                    return false;
                }
            }
            if (!clearContent) continue;
            child2.getContent().clear();
        }
        if (this.myVersion == null) {
            this.myVersion = context.parentContext.getDefaultVersion();
        }
        if (this.myPluginDependencies != null) {
            XmlReader.readDependencies(rootDescriptor, this, context, pathResolver);
        }
        return true;
    }

    private void readProduct(@NotNull DescriptorLoadingContext context, @NotNull Element child2) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(11);
        }
        if (child2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(12);
        }
        this.myProductCode = StringUtil.nullize(child2.getAttributeValue("code"));
        this.myReleaseDate = this.parseReleaseDate(child2.getAttributeValue("release-date"), context.parentContext);
        this.myReleaseVersion = StringUtil.parseInt(child2.getAttributeValue("release-version"), 0);
        this.myIsLicenseOptional = Boolean.parseBoolean(child2.getAttributeValue("optional", "false"));
    }

    private boolean readPluginDependency(@NotNull Path basePath, @NotNull DescriptorLoadingContext context, Element child2) {
        String dependencyIdString;
        if (basePath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(13);
        }
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(14);
        }
        if ((dependencyIdString = child2.getTextTrim()).isEmpty()) {
            return true;
        }
        PluginId dependencyId = PluginId.getId(dependencyIdString);
        boolean isOptional = Boolean.parseBoolean(child2.getAttributeValue("optional"));
        boolean isAvailable = true;
        IdeaPluginDescriptorImpl dependencyDescriptor = null;
        if (context.isPluginDisabled(dependencyId)) {
            if (!isOptional) {
                this.markAsIncomplete(context, "Non-optional dependency plugin " + dependencyId + " is disabled", dependencyId);
            }
            isAvailable = false;
        } else {
            dependencyDescriptor = context.parentContext.result.idMap.get(dependencyId);
            if (dependencyDescriptor != null && context.isBroken(dependencyDescriptor)) {
                if (!isOptional) {
                    context.parentContext.getLogger().info("Skipping reading of " + this.myId + " from " + basePath + " (reason: non-optional dependency " + dependencyId + " is broken)");
                    this.markAsIncomplete(context, "Non-optional dependency " + dependencyId + " is broken", null);
                    return false;
                }
                isAvailable = false;
            }
        }
        PluginDependency dependency = new PluginDependency();
        dependency.pluginId = dependencyId;
        dependency.optional = isOptional;
        dependency.available = isAvailable;
        dependency.configFile = StringUtil.nullize(child2.getAttributeValue("config-file"));
        dependency.dependency = dependencyDescriptor;
        if (this.myPluginDependencies == null) {
            this.myPluginDependencies = new ArrayList<PluginDependency>();
        }
        this.myPluginDependencies.add(dependency);
        return true;
    }

    private boolean checkCompatibility(@NotNull DescriptorLoadingContext context) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(15);
        }
        String since = this.mySinceBuild;
        String until = this.myUntilBuild;
        if (this.isBundled() || since == null && until == null) {
            return true;
        }
        String message = PluginManagerCore.isIncompatible(context.parentContext.result.productBuildNumber, since, until);
        if (message == null) {
            return true;
        }
        this.markAsIncomplete(context, null, null);
        context.parentContext.result.reportIncompatiblePlugin(this, message, since, until);
        return false;
    }

    @NotNull
    String formatErrorMessage(@NotNull String message) {
        if (message == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(16);
        }
        String path2 = this.myPath.toString();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("The ").append(this.myName).append(" (id=").append(this.myId).append(", path=");
        builder2.append(FileUtil.getLocationRelativeToUserHome(path2, false));
        if (this.myVersion != null && !this.isBundled() && !this.myVersion.equals(PluginManagerCore.getBuildNumber().asString())) {
            builder2.append(", version=").append(this.myVersion);
        }
        builder2.append(") plugin ").append(message);
        String string = builder2.toString();
        if (string == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    private void markAsIncomplete(@NotNull DescriptorLoadingContext context, @Nullable String errorMessage, @Nullable PluginId disabledDependency) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(18);
        }
        this.incomplete = true;
        this.setEnabled(false);
        if (this.myId != null) {
            PluginError pluginError;
            PluginError pluginError2 = pluginError = errorMessage == null ? null : new PluginError(this, errorMessage, null, false);
            if (pluginError != null && disabledDependency != null) {
                pluginError.setDisabledDependency(disabledDependency);
            }
            context.parentContext.result.addIncompletePlugin(this, pluginError);
        }
    }

    @NotNull
    private static ServiceDescriptor readServiceDescriptor(@NotNull Element element2, @NotNull DescriptorListLoadingContext loadingContext) {
        if (element2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(19);
        }
        if (loadingContext == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(20);
        }
        ServiceDescriptor descriptor2 = new ServiceDescriptor();
        descriptor2.serviceInterface = element2.getAttributeValue("serviceInterface");
        descriptor2.serviceImplementation = StringUtil.nullize(element2.getAttributeValue("serviceImplementation"));
        descriptor2.testServiceImplementation = StringUtil.nullize(element2.getAttributeValue("testServiceImplementation"));
        descriptor2.headlessImplementation = StringUtil.nullize(element2.getAttributeValue("headlessImplementation"));
        descriptor2.configurationSchemaKey = element2.getAttributeValue("configurationSchemaKey");
        String preload = element2.getAttributeValue("preload");
        if (preload != null) {
            switch (preload) {
                case "true": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.TRUE;
                    break;
                }
                case "await": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.AWAIT;
                    break;
                }
                case "notHeadless": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.NOT_HEADLESS;
                    break;
                }
                case "notLightEdit": {
                    descriptor2.preload = ServiceDescriptor.PreloadMode.NOT_LIGHT_EDIT;
                    break;
                }
                default: {
                    loadingContext.getLogger().error("Unknown preload mode value: " + JDOMUtil.writeElement(element2));
                }
            }
        }
        descriptor2.overrides = Boolean.parseBoolean(element2.getAttributeValue("overrides"));
        ServiceDescriptor serviceDescriptor = descriptor2;
        if (serviceDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(21);
        }
        return serviceDescriptor;
    }

    private static void readComponents(@NotNull Element parent, @NotNull ContainerDescriptor containerDescriptor) {
        List<Content> content2;
        int contentSize;
        if (parent == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(22);
        }
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(23);
        }
        if ((contentSize = (content2 = parent.getContent()).size()) == 0) {
            return;
        }
        List<ComponentConfig> result2 = containerDescriptor.getComponentListToAdd(contentSize);
        for (Content child2 : content2) {
            Element componentElement;
            if (!(child2 instanceof Element) || !(componentElement = (Element)child2).getName().equals("component")) continue;
            ComponentConfig componentConfig = new ComponentConfig();
            Map<String, String> options = null;
            for (Element elementChild : componentElement.getChildren()) {
                switch (elementChild.getName()) {
                    case "skipForDefaultProject": {
                        if (IdeaPluginDescriptorImpl.readBoolValue(elementChild.getTextTrim())) break;
                        componentConfig.setLoadForDefaultProject(true);
                        break;
                    }
                    case "loadForDefaultProject": {
                        componentConfig.setLoadForDefaultProject(IdeaPluginDescriptorImpl.readBoolValue(elementChild.getTextTrim()));
                        break;
                    }
                    case "interface-class": {
                        componentConfig.setInterfaceClass(elementChild.getTextTrim());
                        break;
                    }
                    case "implementation-class": {
                        componentConfig.setImplementationClass(elementChild.getTextTrim());
                        break;
                    }
                    case "headless-implementation-class": {
                        componentConfig.setHeadlessImplementationClass(elementChild.getTextTrim());
                        break;
                    }
                    case "option": {
                        String name = elementChild.getAttributeValue("name");
                        String value2 = elementChild.getAttributeValue("value");
                        if (name == null) break;
                        if (name.equals("os")) {
                            if (value2 == null || IdeaPluginDescriptorImpl.isSuitableForOs(value2)) break;
                            break;
                        }
                        if (options == null) {
                            options = Collections.singletonMap(name, value2);
                            break;
                        }
                        if (options.size() == 1) {
                            options = new HashMap<String, String>(options);
                        }
                        options.put(name, value2);
                    }
                }
            }
            if (options != null) {
                componentConfig.options = options;
            }
            result2.add(componentConfig);
        }
    }

    private static boolean readBoolValue(@NotNull String value2) {
        if (value2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(24);
        }
        return value2.isEmpty() || value2.equalsIgnoreCase("true");
    }

    @Nullable
    private Date parseReleaseDate(@Nullable String dateStr, @NotNull DescriptorListLoadingContext context) {
        if (context == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(25);
        }
        if (StringUtil.isEmpty(dateStr)) {
            return null;
        }
        try {
            return context.getDateParser().parse(dateStr);
        }
        catch (ParseException e) {
            context.getLogger().info("Error parse release date from plugin descriptor for plugin " + this.myName + " {" + this.myId + "}: " + e.getMessage());
            return null;
        }
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build2) {
        if (build2 == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build2);
        if (matcher.matches()) {
            return matcher.group(1) + ".*";
        }
        return build2;
    }

    @ApiStatus.Internal
    public void registerExtensionPoints(@NotNull ExtensionsAreaImpl area, @NotNull ComponentManager componentManager) {
        ContainerDescriptor containerDescriptor;
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(26);
        }
        if (componentManager == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(27);
        }
        boolean clonePoint = true;
        if (componentManager.getPicoContainer().getParent() == null) {
            containerDescriptor = this.myAppContainerDescriptor;
            clonePoint = false;
        } else {
            containerDescriptor = componentManager.getPicoContainer().getParent().getParent() == null ? this.myProjectContainerDescriptor : this.myModuleContainerDescriptor;
        }
        List<ExtensionPointImpl<?>> extensionPoints = containerDescriptor.extensionPoints;
        if (extensionPoints != null) {
            area.registerExtensionPoints(extensionPoints, clonePoint);
        }
    }

    @Nullable
    private ContainerDescriptor getContainerDescriptorByExtensionArea(@Nullable String area) {
        if (area == null) {
            return this.myAppContainerDescriptor;
        }
        if ("IDEA_PROJECT".equals(area)) {
            return this.myProjectContainerDescriptor;
        }
        if ("IDEA_MODULE".equals(area)) {
            return this.myModuleContainerDescriptor;
        }
        return null;
    }

    @NotNull
    public ContainerDescriptor getAppContainerDescriptor() {
        ContainerDescriptor containerDescriptor = this.myAppContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(28);
        }
        return containerDescriptor;
    }

    @NotNull
    public ContainerDescriptor getProjectContainerDescriptor() {
        ContainerDescriptor containerDescriptor = this.myProjectContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(29);
        }
        return containerDescriptor;
    }

    @NotNull
    public ContainerDescriptor getModuleContainerDescriptor() {
        ContainerDescriptor containerDescriptor = this.myModuleContainerDescriptor;
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(30);
        }
        return containerDescriptor;
    }

    @ApiStatus.Internal
    public void registerExtensions(@NotNull ExtensionsAreaImpl area, @NotNull ComponentManager componentManager, boolean notifyListeners) {
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(31);
        }
        if (componentManager == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(32);
        }
        ArrayList<Runnable> listeners = notifyListeners ? new ArrayList<Runnable>() : null;
        this.registerExtensions(area, componentManager, this, listeners);
        if (listeners != null) {
            listeners.forEach(Runnable::run);
        }
    }

    @ApiStatus.Internal
    public void registerExtensions(@NotNull ExtensionsAreaImpl area, @NotNull ComponentManager componentManager, @NotNull IdeaPluginDescriptorImpl rootDescriptor, @Nullable List<Runnable> listenerCallbacks) {
        THashMap<String, List<Element>> extensions2;
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(33);
        }
        if (componentManager == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(34);
        }
        if (rootDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(35);
        }
        if (componentManager.getPicoContainer().getParent() == null) {
            extensions2 = this.myAppContainerDescriptor.extensions;
            if (extensions2 == null) {
                if (this.myExtensions == null) {
                    return;
                }
                this.myExtensions.retainEntries((name, list2) -> {
                    if (area.registerExtensions((String)name, (List<? extends Element>)list2, rootDescriptor, componentManager, listenerCallbacks)) {
                        if (this.myAppContainerDescriptor.extensions == null) {
                            this.myAppContainerDescriptor.extensions = new THashMap();
                        }
                        IdeaPluginDescriptorImpl.addExtensionList(this.myAppContainerDescriptor.extensions, name, list2);
                        return false;
                    }
                    return true;
                });
                this.myExtensionsCleared = true;
                if (this.myExtensions.isEmpty()) {
                    this.myExtensions = null;
                }
                return;
            }
        } else {
            extensions2 = this.myExtensions;
            if (extensions2 == null) {
                return;
            }
        }
        extensions2.forEachEntry((name, list2) -> {
            area.registerExtensions((String)name, (List<? extends Element>)list2, rootDescriptor, componentManager, listenerCallbacks);
            return true;
        });
    }

    @Override
    public String getDescription() {
        String result2 = this.myDescription;
        if (result2 != null) {
            return result2;
        }
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = DynamicBundle.INSTANCE.getResourceBundle(this.myResourceBundleBaseName, this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                PluginManagerCore.getLogger().info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        result2 = bundle == null ? this.myDescriptionChildText : AbstractBundle.messageOrDefault(bundle, "plugin." + this.myId + ".description", StringUtil.notNullize(this.myDescriptionChildText), new Object[0]);
        this.myDescription = result2;
        return result2;
    }

    @Override
    public String getChangeNotes() {
        return this.myChangeNotes;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    @Override
    @Nullable
    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    @Override
    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    @Override
    public boolean isLicenseOptional() {
        return this.myIsLicenseOptional;
    }

    @Override
    public PluginId @NotNull [] getDependentPluginIds() {
        if (this.myDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(36);
        }
        return this.myDependencies;
    }

    @Override
    public PluginId @NotNull [] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(37);
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVendor() {
        return this.myVendor;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getResourceBundleBaseName() {
        return this.myResourceBundleBaseName;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    public void setCategory(String category) {
        this.myCategory = category;
    }

    @Nullable
    public Map<String, List<Element>> getExtensions() {
        if (this.myExtensionsCleared) {
            throw new IllegalStateException("Trying to retrieve extensions list after extension elements have been cleared");
        }
        if (this.myExtensions == null) {
            return null;
        }
        THashMap<String, List<Element>> result2 = new THashMap<String, List<Element>>(this.myExtensions.size());
        result2.putAll(this.myExtensions);
        return result2;
    }

    @Deprecated
    @NotNull
    public List<File> getClassPath() {
        File[] files2;
        File path2 = this.myPath.toFile();
        if (!path2.isDirectory()) {
            List<File> list2 = Collections.singletonList(path2);
            if (list2 == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(38);
            }
            return list2;
        }
        ArrayList<File> result2 = new ArrayList<File>();
        File classesDir = new File(path2, "classes");
        if (classesDir.exists()) {
            result2.add(classesDir);
        }
        if ((files2 = new File(path2, "lib").listFiles()) == null || files2.length <= 0) {
            ArrayList<File> arrayList = result2;
            if (arrayList == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(39);
            }
            return arrayList;
        }
        for (File f : files2) {
            if (f.isFile()) {
                String name = f.getName();
                if (!StringUtil.endsWithIgnoreCase(name, ".jar") && !StringUtil.endsWithIgnoreCase(name, ".zip")) continue;
                result2.add(f);
                continue;
            }
            result2.add(f);
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    List<Path> collectClassPath() {
        if (!Files.isDirectory(this.myPath, new LinkOption[0])) {
            List<Path> list2 = Collections.singletonList(this.myPath);
            if (list2 == null) {
                IdeaPluginDescriptorImpl.$$$reportNull$$$0(41);
            }
            return list2;
        }
        ArrayList<Path> result2 = new ArrayList<Path>();
        Path classesDir = this.myPath.resolve("classes");
        if (Files.exists(classesDir, new LinkOption[0])) {
            result2.add(classesDir);
        }
        try (DirectoryStream<Path> childStream2 = Files.newDirectoryStream(this.myPath.resolve("lib"));){
            for (Path f : childStream2) {
                if (Files.isRegularFile(f, new LinkOption[0])) {
                    String name = f.getFileName().toString();
                    if (!StringUtilRt.endsWithIgnoreCase(name, ".jar") && !StringUtilRt.endsWithIgnoreCase(name, ".zip")) continue;
                    result2.add(f);
                    continue;
                }
                result2.add(f);
            }
        }
        catch (NoSuchFileException childStream2) {
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().debug(e);
        }
        ArrayList<Path> arrayList = result2;
        if (arrayList == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public List<Element> getActionDescriptionElements() {
        return this.myActionElements;
    }

    @Override
    public String getVendorEmail() {
        return this.myVendorEmail;
    }

    @Override
    public String getVendorUrl() {
        return this.myVendorUrl;
    }

    @Override
    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(String val) {
        this.myUrl = val;
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.myDeleted = deleted;
    }

    public void setLoader(@Nullable ClassLoader loader) {
        this.myLoader = loader;
    }

    public boolean unloadClassLoader() {
        GCWatcher watcher = GCWatcher.tracking(this.myLoader);
        this.myLoader = null;
        return watcher.tryCollect();
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    void setUseCoreClassLoader() {
        this.myUseCoreClassLoader = true;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    void mergeOptionalConfig(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(43);
        }
        if (this.myExtensions == null) {
            this.myExtensions = descriptor2.myExtensions;
        } else if (descriptor2.myExtensions != null) {
            descriptor2.myExtensions.forEachEntry((name, list2) -> {
                IdeaPluginDescriptorImpl.addExtensionList(this.myExtensions, name, list2);
                return true;
            });
        }
        if (this.myActionElements == null) {
            this.myActionElements = descriptor2.myActionElements;
        } else if (descriptor2.myActionElements != null) {
            this.myActionElements.addAll(descriptor2.myActionElements);
        }
        this.myAppContainerDescriptor.merge(descriptor2.myAppContainerDescriptor);
        this.myProjectContainerDescriptor.merge(descriptor2.myProjectContainerDescriptor);
        this.myModuleContainerDescriptor.merge(descriptor2.myModuleContainerDescriptor);
    }

    private static void addExtensionList(@NotNull Map<String, List<Element>> map2, @NotNull String name, @NotNull List<Element> list2) {
        List<Element> myList;
        if (map2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(44);
        }
        if (name == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(45);
        }
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(46);
        }
        if ((myList = map2.get(name)) == null) {
            map2.put(name, list2);
        } else {
            myList.addAll(list2);
        }
    }

    @Override
    public boolean isBundled() {
        return this.myBundled;
    }

    @Override
    public boolean allowBundledUpdate() {
        return this.myAllowBundledUpdate;
    }

    @Override
    public boolean isImplementationDetail() {
        return this.myImplementationDetail;
    }

    @Override
    public boolean isRequireRestart() {
        return this.myRequireRestart;
    }

    @NotNull
    public List<PluginId> getModules() {
        List<PluginId> list2 = ContainerUtil.notNullize(this.myModules);
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(47);
        }
        return list2;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof IdeaPluginDescriptorImpl && this.myId == ((IdeaPluginDescriptorImpl)o).myId;
    }

    public int hashCode() {
        return Objects.hashCode(this.myId);
    }

    public String toString() {
        return "PluginDescriptor(name=" + this.myName + ", id=" + this.myId + ", path=" + this.myPath + ")";
    }

    private static boolean isSuitableForOs(@NotNull String os) {
        if (os == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(48);
        }
        if (os.isEmpty()) {
            return true;
        }
        if (os.equals(OS.mac.name())) {
            return SystemInfo.isMac;
        }
        if (os.equals(OS.linux.name())) {
            return SystemInfo.isLinux;
        }
        if (os.equals(OS.windows.name())) {
            return SystemInfo.isWindows;
        }
        if (os.equals(OS.unix.name())) {
            return SystemInfo.isUnix;
        }
        if (os.equals(OS.freebsd.name())) {
            return SystemInfo.isFreeBSD;
        }
        throw new IllegalArgumentException("Unknown OS '" + os + "'");
    }

    @Nullable
    public String findOptionalDependencyConfigFile(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(49);
        }
        if (this.myDependencies == null) {
            return null;
        }
        for (PluginDependency dependency : this.myPluginDependencies) {
            if (!dependency.pluginId.equals(pluginId)) continue;
            return dependency.configFile;
        }
        return null;
    }

    static /* synthetic */ PluginId[] access$1102(IdeaPluginDescriptorImpl x0, PluginId[] x1) {
        x0.myDependencies = x1;
        return x1;
    }

    static /* synthetic */ PluginId[] access$1202(IdeaPluginDescriptorImpl x0, PluginId[] x1) {
        x0.myOptionalDependencies = x1;
        return x1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 21: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 21: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 21: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDescriptor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 27: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "formatErrorMessage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "readServiceDescriptor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppContainerDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectContainerDescriptor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContainerDescriptor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPluginIds";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalDependentPluginIds";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPath";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 21: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readProduct";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readPluginDependency";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkCompatibility";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "markAsIncomplete";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readServiceDescriptor";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readComponents";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readBoolValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseReleaseDate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfig";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionList";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForOs";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findOptionalDependencyConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 17: 
            case 21: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class XmlReader {
        private XmlReader() {
        }

        static void readListeners(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Element list2, @NotNull ContainerDescriptor containerDescriptor) {
            if (descriptor2 == null) {
                XmlReader.$$$reportNull$$$0(0);
            }
            if (list2 == null) {
                XmlReader.$$$reportNull$$$0(1);
            }
            if (containerDescriptor == null) {
                XmlReader.$$$reportNull$$$0(2);
            }
            List<Content> content2 = list2.getContent();
            List<ListenerDescriptor> result2 = containerDescriptor.listeners;
            if (result2 == null) {
                containerDescriptor.listeners = result2 = new ArrayList<ListenerDescriptor>(content2.size());
            } else {
                ((ArrayList)result2).ensureCapacity(result2.size() + content2.size());
            }
            for (Content item : content2) {
                Element child2;
                String os;
                if (!(item instanceof Element) || (os = (child2 = (Element)item).getAttributeValue("os")) != null && !IdeaPluginDescriptorImpl.isSuitableForOs(os)) continue;
                String listenerClassName = child2.getAttributeValue("class");
                String topicClassName = child2.getAttributeValue("topic");
                if (listenerClassName == null || topicClassName == null) {
                    PluginManagerCore.getLogger().error("Listener descriptor is not correct: " + JDOMUtil.writeElement(child2));
                    continue;
                }
                result2.add(new ListenerDescriptor(listenerClassName, topicClassName, XmlReader.getBoolean("activeInTestMode", child2), XmlReader.getBoolean("activeInHeadlessMode", child2), descriptor2));
            }
        }

        static void readIdAndName(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Element element2) {
            if (descriptor2 == null) {
                XmlReader.$$$reportNull$$$0(3);
            }
            if (element2 == null) {
                XmlReader.$$$reportNull$$$0(4);
            }
            String idString = descriptor2.myId == null ? element2.getChildTextTrim("id") : descriptor2.myId.getIdString();
            String name = element2.getChildTextTrim("name");
            if (idString == null) {
                idString = name;
            } else if (name == null) {
                name = idString;
            }
            descriptor2.myName = name;
            if (descriptor2.myId == null) {
                descriptor2.myId = StringUtil.isEmpty(idString) ? null : PluginId.getId(idString);
            }
        }

        static void readMetaInfo(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Element element2) {
            if (descriptor2 == null) {
                XmlReader.$$$reportNull$$$0(5);
            }
            if (element2 == null) {
                XmlReader.$$$reportNull$$$0(6);
            }
            if (!element2.hasAttributes()) {
                return;
            }
            List<Attribute> attributes = element2.getAttributes();
            for (Attribute attribute : attributes) {
                switch (attribute.getName()) {
                    case "url": {
                        descriptor2.myUrl = StringUtil.nullize(attribute.getValue());
                        break;
                    }
                    case "use-idea-classloader": {
                        descriptor2.myUseIdeaClassLoader = Boolean.parseBoolean(attribute.getValue());
                        break;
                    }
                    case "allow-bundled-update": {
                        descriptor2.myAllowBundledUpdate = Boolean.parseBoolean(attribute.getValue());
                        break;
                    }
                    case "implementation-detail": {
                        descriptor2.myImplementationDetail = Boolean.parseBoolean(attribute.getValue());
                        break;
                    }
                    case "require-restart": {
                        descriptor2.myRequireRestart = Boolean.parseBoolean(attribute.getValue());
                        break;
                    }
                    case "version": {
                        String internalVersionString = StringUtil.nullize(attribute.getValue());
                        if (internalVersionString == null) break;
                        try {
                            Integer.parseInt(internalVersionString);
                            break;
                        }
                        catch (NumberFormatException e) {
                            PluginManagerCore.getLogger().error(new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", e, descriptor2.myId));
                        }
                    }
                }
            }
        }

        static int collapseDuplicateDependencies(List<PluginDependency> dependencies) {
            int size = 0;
            int n = dependencies.size();
            block0: for (int i = 0; i < n; ++i) {
                PluginDependency dependency = dependencies.get(i);
                ++size;
                if (!dependency.available || !dependency.optional) continue;
                for (int j = 0; j < i; ++j) {
                    PluginDependency prev = dependencies.get(j);
                    if (prev == null || prev.optional || prev.pluginId != dependency.pluginId) continue;
                    dependency.optional = false;
                    dependencies.set(j, null);
                    --size;
                    continue block0;
                }
            }
            return size;
        }

        static <T> void readDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull DescriptorLoadingContext context, @NotNull PathBasedJdomXIncluder.PathResolver<T> pathResolver) {
            if (rootDescriptor == null) {
                XmlReader.$$$reportNull$$$0(7);
            }
            if (descriptor2 == null) {
                XmlReader.$$$reportNull$$$0(8);
            }
            if (context == null) {
                XmlReader.$$$reportNull$$$0(9);
            }
            if (pathResolver == null) {
                XmlReader.$$$reportNull$$$0(10);
            }
            List<String> visitedFiles = null;
            List dependencies = descriptor2.myPluginDependencies;
            int size = XmlReader.collapseDuplicateDependencies(dependencies);
            for (PluginDependency dependency : dependencies) {
                Element element2;
                String configFile;
                if (dependency == null || (configFile = dependency.configFile) == null) continue;
                try {
                    element2 = pathResolver.resolvePath(descriptor2.myBasePath, configFile, context.parentContext.getXmlFactory());
                }
                catch (IOException | JDOMException e) {
                    context.parentContext.getLogger().info("Plugin " + rootDescriptor.getPluginId() + " misses optional descriptor " + configFile);
                    continue;
                }
                if (visitedFiles == null) {
                    visitedFiles = context.parentContext.getVisitedFiles();
                }
                XmlReader.checkCycle(rootDescriptor, configFile, visitedFiles);
                IdeaPluginDescriptorImpl dependencyDescriptor = dependency.dependency;
                if (dependencyDescriptor != null) {
                    context.parentContext.getClass();
                }
                IdeaPluginDescriptorImpl tempDescriptor = new IdeaPluginDescriptorImpl(descriptor2.myPath, false);
                visitedFiles.add(configFile);
                if (!tempDescriptor.readExternal(element2, descriptor2.myBasePath, pathResolver, context, rootDescriptor)) {
                    tempDescriptor = null;
                }
                visitedFiles.clear();
                if (tempDescriptor == null) continue;
                if (descriptor2.optionalConfigs == null) {
                    descriptor2.optionalConfigs = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
                }
                ContainerUtilRt.putValue(dependency.pluginId, tempDescriptor, descriptor2.optionalConfigs);
            }
            XmlReader.collectDependentPluginIds(descriptor2, size);
        }

        static void collectDependentPluginIds(@NotNull IdeaPluginDescriptorImpl descriptor2, int dependencyListSize) {
            if (descriptor2 == null) {
                XmlReader.$$$reportNull$$$0(11);
            }
            List dependencies = descriptor2.myPluginDependencies;
            PluginId[] dependentPlugins = new PluginId[dependencyListSize];
            int optionalSize = 0;
            int index = 0;
            for (PluginDependency dependency : dependencies) {
                if (dependency == null) continue;
                dependentPlugins[index++] = dependency.pluginId;
                if (!dependency.optional) continue;
                ++optionalSize;
            }
            IdeaPluginDescriptorImpl.access$1102(descriptor2, dependentPlugins);
            if (optionalSize > 0) {
                if (optionalSize == dependentPlugins.length) {
                    IdeaPluginDescriptorImpl.access$1202(descriptor2, dependentPlugins);
                } else {
                    PluginId[] optionalDependencies = new PluginId[optionalSize];
                    index = 0;
                    for (PluginDependency dependency : dependencies) {
                        if (dependency == null || !dependency.optional) continue;
                        optionalDependencies[index++] = dependency.pluginId;
                    }
                    IdeaPluginDescriptorImpl.access$1202(descriptor2, optionalDependencies);
                }
            }
        }

        private static void checkCycle(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull String configFile, @NotNull List<String> visitedFiles) {
            if (rootDescriptor == null) {
                XmlReader.$$$reportNull$$$0(12);
            }
            if (configFile == null) {
                XmlReader.$$$reportNull$$$0(13);
            }
            if (visitedFiles == null) {
                XmlReader.$$$reportNull$$$0(14);
            }
            int n = visitedFiles.size();
            for (int i = 0; i < n; ++i) {
                if (!configFile.equals(visitedFiles.get(i))) continue;
                List<String> cycle = visitedFiles.subList(i, visitedFiles.size());
                PluginId pluginId = rootDescriptor.getPluginId();
                throw new RuntimeException("Plugin " + pluginId + " optional descriptors form a cycle: " + String.join((CharSequence)", ", cycle));
            }
        }

        private static boolean getBoolean(@NotNull String name, @NotNull Element child2) {
            String value2;
            if (name == null) {
                XmlReader.$$$reportNull$$$0(15);
            }
            if (child2 == null) {
                XmlReader.$$$reportNull$$$0(16);
            }
            return (value2 = child2.getAttributeValue(name)) == null || Boolean.parseBoolean(value2);
        }

        static void readExtensions(@NotNull IdeaPluginDescriptorImpl descriptor2, DescriptorListLoadingContext loadingContext, Element child2) {
            if (descriptor2 == null) {
                XmlReader.$$$reportNull$$$0(17);
            }
            String ns = child2.getAttributeValue("defaultExtensionNs");
            THashMap<String, SmartList<Element>> epNameToExtensions = descriptor2.myExtensions;
            Interner<String> stringInterner = loadingContext.getStringInterner();
            block10: for (Element extensionElement : child2.getChildren()) {
                ContainerDescriptor containerDescriptor;
                String qualifiedExtensionPointName;
                String os = extensionElement.getAttributeValue("os");
                if (os != null) {
                    extensionElement.removeAttribute("os");
                    if (!IdeaPluginDescriptorImpl.isSuitableForOs(os)) continue;
                }
                switch (qualifiedExtensionPointName = stringInterner.intern(ExtensionsAreaImpl.extractPointName(extensionElement, ns))) {
                    case "com.intellij.applicationService": {
                        containerDescriptor = descriptor2.myAppContainerDescriptor;
                        break;
                    }
                    case "com.intellij.projectService": {
                        containerDescriptor = descriptor2.myProjectContainerDescriptor;
                        break;
                    }
                    case "com.intellij.moduleService": {
                        containerDescriptor = descriptor2.myModuleContainerDescriptor;
                        break;
                    }
                    default: {
                        SmartList<Element> list2;
                        if (epNameToExtensions == null) {
                            epNameToExtensions = new THashMap<String, SmartList<Element>>();
                            descriptor2.myExtensions = epNameToExtensions;
                        }
                        if ((list2 = (SmartList<Element>)epNameToExtensions.get(qualifiedExtensionPointName)) == null) {
                            list2 = new SmartList<Element>();
                            epNameToExtensions.put(qualifiedExtensionPointName, list2);
                        }
                        list2.add(extensionElement);
                        continue block10;
                    }
                }
                containerDescriptor.addService(IdeaPluginDescriptorImpl.readServiceDescriptor(extensionElement, loadingContext));
            }
        }

        static void readExtensionPoints(@NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Element parentElement) {
            if (rootDescriptor == null) {
                XmlReader.$$$reportNull$$$0(18);
            }
            if (descriptor2 == null) {
                XmlReader.$$$reportNull$$$0(19);
            }
            if (parentElement == null) {
                XmlReader.$$$reportNull$$$0(20);
            }
            for (Content child2 : parentElement.getContent()) {
                if (!(child2 instanceof Element)) continue;
                Element element2 = (Element)child2;
                String area = element2.getAttributeValue("area");
                ContainerDescriptor containerDescriptor = descriptor2.getContainerDescriptorByExtensionArea(area);
                if (containerDescriptor == null) {
                    PluginManagerCore.getLogger().error("Unknown area: " + area);
                    continue;
                }
                String pointName = XmlReader.getExtensionPointName(element2, rootDescriptor.getPluginId());
                String beanClassName = element2.getAttributeValue("beanClass");
                String interfaceClassName = element2.getAttributeValue("interface");
                if (beanClassName == null && interfaceClassName == null) {
                    throw new RuntimeException("Neither 'beanClass' nor 'interface' attribute is specified for extension point '" + pointName + "' in '" + rootDescriptor.getPluginId() + "' plugin");
                }
                if (beanClassName != null && interfaceClassName != null) {
                    throw new RuntimeException("Both 'beanClass' and 'interface' attributes are specified for extension point '" + pointName + "' in '" + rootDescriptor.getPluginId() + "' plugin");
                }
                List<ExtensionPointImpl<?>> result2 = containerDescriptor.extensionPoints;
                if (result2 == null) {
                    result2 = new ArrayList();
                    containerDescriptor.extensionPoints = result2;
                }
                boolean dynamic = Boolean.parseBoolean(element2.getAttributeValue("dynamic"));
                ExtensionPointImpl point = interfaceClassName == null ? new BeanExtensionPoint(pointName, beanClassName, rootDescriptor, dynamic) : new InterfaceExtensionPoint(pointName, interfaceClassName, rootDescriptor, dynamic);
                result2.add(point);
            }
        }

        @NotNull
        private static String getExtensionPointName(@NotNull Element extensionPointElement, @NotNull PluginId effectivePluginId) {
            String pointName;
            if (extensionPointElement == null) {
                XmlReader.$$$reportNull$$$0(21);
            }
            if (effectivePluginId == null) {
                XmlReader.$$$reportNull$$$0(22);
            }
            if ((pointName = extensionPointElement.getAttributeValue("qualifiedName")) == null) {
                String name = extensionPointElement.getAttributeValue("name");
                if (name == null) {
                    throw new RuntimeException("'name' attribute not specified for extension point in '" + effectivePluginId + "' plugin");
                }
                pointName = effectivePluginId.getIdString() + '.' + name;
            }
            String string = pointName;
            if (string == null) {
                XmlReader.$$$reportNull$$$0(23);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containerDescriptor";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: 
                case 12: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootDescriptor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathResolver";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configFile";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitedFiles";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentElement";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionPointElement";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "effectivePluginId";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl$XmlReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl$XmlReader";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtensionPointName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "readListeners";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readIdAndName";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "readMetaInfo";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "readDependencies";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "collectDependentPluginIds";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCycle";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getBoolean";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "readExtensions";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "readExtensionPoints";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "getExtensionPointName";
                    break;
                }
                case 23: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PluginDependency {
        public PluginId pluginId;
        public boolean optional;
        public boolean available;
        public String configFile;
        public IdeaPluginDescriptorImpl dependency;

        private PluginDependency() {
        }
    }

    public static enum OS {
        mac,
        linux,
        windows,
        unix,
        freebsd;

    }
}

