/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.BasePathResolver;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PathBasedJdomXIncluder<T> {
    private static final Logger LOG = Logger.getInstance(PathBasedJdomXIncluder.class);
    public static final PathResolver<Path> DEFAULT_PATH_RESOLVER = new BasePathResolver();
    private static final String INCLUDE = "include";
    private static final String HREF = "href";
    private static final String BASE = "base";
    private static final String PARSE = "parse";
    private static final String XML = "xml";
    private static final String XPOINTER = "xpointer";
    private final DescriptorLoadingContext context;
    private final PathResolver<T> pathResolver;

    private PathBasedJdomXIncluder(@NotNull DescriptorLoadingContext context, @NotNull PathResolver<T> pathResolver) {
        if (context == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(0);
        }
        if (pathResolver == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(1);
        }
        this.context = context;
        this.pathResolver = pathResolver;
    }

    public static <T> void resolveNonXIncludeElement(@NotNull Element original, @Nullable Path base, @NotNull DescriptorLoadingContext context, @NotNull PathResolver<T> pathResolver) {
        if (original == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(3);
        }
        if (pathResolver == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!PathBasedJdomXIncluder.isIncludeElement(original));
        super.resolveNonXIncludeElement(original, pathResolver.createNewStack(base));
    }

    private static boolean isIncludeElement(Element element2) {
        return element2.getName().equals(INCLUDE) && element2.getNamespace().equals(JDOMUtil.XINCLUDE_NAMESPACE);
    }

    @NotNull
    private List<Element> resolveXIncludeElement(@NotNull Element element2, @NotNull List<T> bases) {
        List<Element> remoteParsed;
        String relativePath;
        if (element2 == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(5);
        }
        if (bases == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(6);
        }
        if ((relativePath = element2.getAttributeValue(HREF)) == null) {
            throw new RuntimeException("Missing href attribute");
        }
        String parseAttribute = element2.getAttributeValue(PARSE);
        if (parseAttribute != null) {
            LOG.assertTrue(parseAttribute.equals(XML), parseAttribute + " is not a legal value for the parse attribute");
        }
        if (!(remoteParsed = this.parseRemote(bases, relativePath, element2)).isEmpty()) {
            remoteParsed = PathBasedJdomXIncluder.extractNeededChildren(element2, remoteParsed);
        }
        for (int i = 0; i < remoteParsed.size(); ++i) {
            Element o = remoteParsed.get(i);
            if (PathBasedJdomXIncluder.isIncludeElement(o)) {
                List<Element> list2 = this.resolveXIncludeElement(o, bases);
                remoteParsed.addAll(i, list2);
                remoteParsed.remove(i += list2.size() - 1);
                continue;
            }
            this.resolveNonXIncludeElement(o, bases);
        }
        for (Content content2 : remoteParsed) {
            content2.detach();
        }
        List<Element> list3 = remoteParsed;
        if (list3 == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(7);
        }
        return list3;
    }

    @NotNull
    private static List<Element> extractNeededChildren(@NotNull Element element2, @NotNull List<Element> remoteElements) {
        String xpointer;
        if (element2 == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(8);
        }
        if (remoteElements == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(9);
        }
        if ((xpointer = element2.getAttributeValue(XPOINTER)) == null) {
            List<Element> list2 = remoteElements;
            if (list2 == null) {
                PathBasedJdomXIncluder.$$$reportNull$$$0(10);
            }
            return list2;
        }
        Matcher matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer);
        if (!matcher.matches()) {
            throw new RuntimeException("Unsupported XPointer: " + xpointer);
        }
        String pointer = matcher.group(1);
        if (!(matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer)).matches()) {
            throw new RuntimeException("Unsupported pointer: " + pointer);
        }
        String rootTagName = matcher.group(1);
        assert (remoteElements.size() == 1);
        Element e = remoteElements.get(0);
        if (!e.getName().equals(rootTagName)) {
            List<Element> list3 = Collections.emptyList();
            if (list3 == null) {
                PathBasedJdomXIncluder.$$$reportNull$$$0(11);
            }
            return list3;
        }
        String subTagName = matcher.group(2);
        if (subTagName != null) {
            e = e.getChild(subTagName.substring(1));
            assert (e != null);
        }
        return new ArrayList<Element>(e.getChildren());
    }

    @NotNull
    private List<Element> parseRemote(@NotNull List<T> bases, @NotNull String relativePath, @NotNull Element referrerElement) {
        List<Element> list2;
        if (bases == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(13);
        }
        if (referrerElement == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(14);
        }
        try {
            List<Element> list3;
            Element root;
            int baseStackSize = bases.size();
            String base = referrerElement.getAttributeValue(BASE, Namespace.XML_NAMESPACE);
            if (base != null) {
                LOG.error("Do not use xml:base attribute: " + base);
            }
            if (PathBasedJdomXIncluder.isIncludeElement(root = this.pathResolver.resolvePath(bases, relativePath, base, this.context.parentContext.getXmlFactory()))) {
                list3 = this.resolveXIncludeElement(root, bases);
            } else {
                this.resolveNonXIncludeElement(root, bases);
                list3 = Collections.singletonList(root);
            }
            if (baseStackSize != bases.size()) {
                bases.remove(bases.size() - 1);
            }
            list2 = list3;
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            Element fallbackElement = referrerElement.getChild("fallback", referrerElement.getNamespace());
            if (fallbackElement != null) {
                List<Element> list4 = Collections.emptyList();
                if (list4 == null) {
                    PathBasedJdomXIncluder.$$$reportNull$$$0(16);
                }
                return list4;
            }
            if (this.context.parentContext.ignoreMissingInclude) {
                LOG.info(relativePath + " include ignored: " + e.getMessage());
                List<Element> list5 = Collections.emptyList();
                if (list5 == null) {
                    PathBasedJdomXIncluder.$$$reportNull$$$0(17);
                }
                return list5;
            }
            throw new RuntimeException(e);
        }
        if (list2 == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private void resolveNonXIncludeElement(@NotNull Element original, @NotNull List<T> bases) {
        if (original == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(18);
        }
        if (bases == null) {
            PathBasedJdomXIncluder.$$$reportNull$$$0(19);
        }
        List<Content> contentList = original.getContent();
        for (int i = contentList.size() - 1; i >= 0; --i) {
            Content content2 = contentList.get(i);
            if (!(content2 instanceof Element)) continue;
            Element element2 = (Element)content2;
            if (PathBasedJdomXIncluder.isIncludeElement(element2)) {
                original.setContent(i, this.resolveXIncludeElement(element2, bases));
                continue;
            }
            this.resolveNonXIncludeElement(element2, bases);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bases";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PathBasedJdomXIncluder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteElements";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referrerElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PathBasedJdomXIncluder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveXIncludeElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNeededChildren";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRemote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolveNonXIncludeElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveXIncludeElement";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractNeededChildren";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseRemote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface PathResolver<T> {
        @NotNull
        public Element resolvePath(@NotNull List<T> var1, @NotNull String var2, @Nullable String var3, @NotNull SafeJdomFactory var4) throws IOException, JDOMException;

        @NotNull
        public Element resolvePath(@NotNull Path var1, @NotNull String var2, @NotNull SafeJdomFactory var3) throws IOException, JDOMException;

        @NotNull
        public List<T> createNewStack(@Nullable Path var1);
    }
}

