/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginEnabler {
    private static final Logger LOG = Logger.getInstance(PluginEnabler.class);

    public static boolean enablePlugins(Collection<IdeaPluginDescriptor> plugins2, boolean enable) {
        return PluginEnabler.updatePluginEnabledState(enable ? plugins2 : Collections.emptyList(), enable ? Collections.emptyList() : plugins2, null);
    }

    public static boolean updatePluginEnabledState(Collection<IdeaPluginDescriptor> pluginsToEnable, Collection<IdeaPluginDescriptor> pluginsToDisable, @Nullable JComponent parentComponent) {
        List<IdeaPluginDescriptorImpl> pluginDescriptorsToEnable = PluginEnabler.loadFullDescriptors(pluginsToEnable);
        List<IdeaPluginDescriptorImpl> pluginDescriptorsToDisable = PluginEnabler.loadFullDescriptors(pluginsToDisable);
        Set<PluginId> disabledIds = PluginManagerCore.getDisabledIds();
        for (PluginDescriptor pluginDescriptor : pluginsToEnable) {
            pluginDescriptor.setEnabled(true);
            disabledIds.remove(pluginDescriptor.getPluginId());
        }
        for (PluginDescriptor pluginDescriptor : pluginsToDisable) {
            pluginDescriptor.setEnabled(false);
            disabledIds.add(pluginDescriptor.getPluginId());
        }
        try {
            PluginManagerCore.saveDisabledPlugins(disabledIds, false);
        }
        catch (IOException e) {
            LOG.error(e);
        }
        if (ContainerUtil.all(pluginDescriptorsToDisable, plugin -> DynamicPlugins.allowLoadUnloadWithoutRestart(plugin)) && ContainerUtil.all(pluginDescriptorsToEnable, plugin -> DynamicPlugins.allowLoadUnloadWithoutRestart(plugin))) {
            boolean needRestart = false;
            for (IdeaPluginDescriptorImpl descriptor3 : pluginDescriptorsToDisable) {
                if (DynamicPlugins.unloadPluginWithProgress(parentComponent, descriptor3, true)) continue;
                needRestart = true;
                break;
            }
            if (!needRestart) {
                for (IdeaPluginDescriptor descriptor2 : pluginDescriptorsToEnable) {
                    DynamicPlugins.loadPlugin((IdeaPluginDescriptorImpl)descriptor2, true);
                }
                return true;
            }
        }
        InstalledPluginsState.getInstance().setRestartRequired(true);
        return false;
    }

    private static List<IdeaPluginDescriptorImpl> loadFullDescriptors(Collection<IdeaPluginDescriptor> pluginsToEnable) {
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptor descriptor2 : pluginsToEnable) {
            if (!(descriptor2 instanceof IdeaPluginDescriptorImpl)) continue;
            result2.add(PluginEnabler.loadFullDescriptor((IdeaPluginDescriptorImpl)descriptor2));
        }
        return result2;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl tryLoadFullDescriptor(IdeaPluginDescriptorImpl descriptor2) {
        return PluginManager.loadDescriptor(descriptor2.getPluginPath(), "plugin.xml", Collections.emptySet(), descriptor2.isBundled());
    }

    @NotNull
    public static IdeaPluginDescriptorImpl loadFullDescriptor(IdeaPluginDescriptorImpl descriptor2) {
        IdeaPluginDescriptorImpl fullDescriptor = PluginEnabler.tryLoadFullDescriptor(descriptor2);
        if (fullDescriptor == null) {
            LOG.error("Could not load full descriptor for plugin " + descriptor2.getPath());
            fullDescriptor = descriptor2;
        }
        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = fullDescriptor;
        if (ideaPluginDescriptorImpl == null) {
            PluginEnabler.$$$reportNull$$$0(0);
        }
        return ideaPluginDescriptorImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginEnabler", "loadFullDescriptor"));
    }
}

