/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.gson.stream.JsonToken;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

public final class PluginRepositoryRequests {
    public static String getBuildForPluginRepositoryRequests() {
        ApplicationInfoEx instance2 = ApplicationInfoImpl.getShadowInstance();
        String compatibleBuild = PluginManagerCore.getPluginsCompatibleBuild();
        if (compatibleBuild != null) {
            return Objects.requireNonNull(BuildNumber.fromStringWithProductCode(compatibleBuild, instance2.getBuild().getProductCode())).asString();
        }
        return instance2.getApiVersion();
    }

    @NotNull
    public static Url createSearchUrl(@NotNull String query, int count) {
        if (query == null) {
            PluginRepositoryRequests.$$$reportNull$$$0(0);
        }
        ApplicationInfoEx instance2 = ApplicationInfoImpl.getShadowInstance();
        Url url = Urls.newFromEncoded((String)(instance2.getPluginManagerUrl() + "/api/search?" + query + "&build=" + URLUtil.encodeURIComponent(PluginRepositoryRequests.getBuildForPluginRepositoryRequests()) + "&max=" + count));
        if (url == null) {
            PluginRepositoryRequests.$$$reportNull$$$0(1);
        }
        return url;
    }

    @NotNull
    public static List<PluginId> requestToPluginRepository(@NotNull Url url) throws IOException {
        if (url == null) {
            PluginRepositoryRequests.$$$reportNull$$$0(2);
        }
        ArrayList<PluginId> ids = new ArrayList<PluginId>();
        HttpRequests.request(url).throwStatusCodeException(false).productNameAsUserAgent().connect(request2 -> {
            URLConnection connection = request2.getConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
                return null;
            }
            try (JsonReaderEx json = new JsonReaderEx(FileUtil.loadTextAndClose(request2.getReader()));){
                if (json.peek() == JsonToken.BEGIN_OBJECT) {
                    json.beginObject();
                    json.nextName();
                    json.nextString();
                    json.nextName();
                }
                json.beginArray();
                while (json.hasNext()) {
                    ids.add(PluginId.getId(json.nextString()));
                }
            }
            return null;
        });
        ArrayList<PluginId> arrayList = ids;
        if (arrayList == null) {
            PluginRepositoryRequests.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public static boolean loadPlugins(@NotNull List<? super IdeaPluginDescriptor> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptor> allDescriptors, @NotNull String query) throws IOException {
        Url baseUrl;
        if (descriptors == null) {
            PluginRepositoryRequests.$$$reportNull$$$0(4);
        }
        if (allDescriptors == null) {
            PluginRepositoryRequests.$$$reportNull$$$0(5);
        }
        if (query == null) {
            PluginRepositoryRequests.$$$reportNull$$$0(6);
        }
        Url offsetUrl = baseUrl = PluginRepositoryRequests.createSearchUrl(query, 9);
        HashMap<String, String> offsetParameters = new HashMap<String, String>();
        int offset = 0;
        List<PluginId> pluginIds;
        while (!(pluginIds = PluginRepositoryRequests.requestToPluginRepository(offsetUrl)).isEmpty()) {
            for (PluginId pluginId : pluginIds) {
                IdeaPluginDescriptor descriptor2 = allDescriptors.get(pluginId);
                if (descriptor2 == null) continue;
                descriptors.add(descriptor2);
                if (descriptors.size() != 9) continue;
                return true;
            }
            offsetParameters.put("offset", Integer.toString(offset += pluginIds.size()));
            offsetUrl = baseUrl.addParameters(offsetParameters);
        }
        return false;
    }

    @Nullable
    public static Object getPluginPricesJsonObject() throws IOException {
        ApplicationInfoEx instance2 = ApplicationInfoImpl.getShadowInstance();
        Url url = Urls.newFromEncoded((String)(instance2.getPluginManagerUrl() + "/geo/files/prices"));
        return HttpRequests.request(url).throwStatusCodeException(false).productNameAsUserAgent().connect(request2 -> {
            URLConnection connection = request2.getConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
                return null;
            }
            try (JsonReaderEx json = new JsonReaderEx(FileUtil.loadTextAndClose(request2.getReader()));){
                Object object = JsonUtil.nextAny(json);
                return object;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginRepositoryRequests";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginRepositoryRequests";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "requestToPluginRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSearchUrl";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requestToPluginRepository";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

