/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Graphics;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginTable
extends JBTable {
    public PluginTable(PluginTableModel model) {
        super(model);
        this.getColumnModel().setColumnMargin(0);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            ColumnInfo columnInfo = model.getColumnInfos()[i];
            column.setCellEditor(columnInfo.getEditor(null));
            if (columnInfo.getColumnClass() != Boolean.class) continue;
            TableUtil.setupCheckboxColumn(column, JBUIScale.scale(16));
        }
        this.setSelectionMode(2);
        this.setShowGrid(false);
        this.setTableHeader(null);
        this.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                IdeaPluginDescriptor[] selectedValues = PluginTable.this.getSelectedObjects();
                if (selectedValues == null) {
                    return null;
                }
                String text2 = StringUtil.join(selectedValues, descriptor2 -> descriptor2.getName(), ", ");
                String htmlText = "<body>\n<ul>\n" + StringUtil.join(selectedValues, descriptor2 -> descriptor2.getName(), "</li>\n<li>") + "</ul>\n</body>\n";
                return new TextTransferable(XmlStringUtil.wrapInHtml(htmlText), text2);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (g == null) {
            PluginTable.$$$reportNull$$$0(0);
        }
        super.paint(g);
        UIUtil.fixOSXEditorBackground(this);
    }

    public void setColumnWidth(int columnIndex, int width) {
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    @Override
    protected boolean isSortOnUpdates() {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.repaint();
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        ColumnInfo columnInfo = ((PluginTableModel)this.getModel()).getColumnInfos()[column];
        return columnInfo.getRenderer(this.getObjectAt(row));
    }

    public Object[] getElements() {
        return ((PluginTableModel)this.getModel()).view.toArray();
    }

    public IdeaPluginDescriptor getObjectAt(int row) {
        return ((PluginTableModel)this.getModel()).getObjectAt(this.convertRowIndexToModel(row));
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        PluginTableModel tableModel = (PluginTableModel)this.getModel();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            IdeaPluginDescriptor descriptorAt = tableModel.getObjectAt(i);
            if (ArrayUtil.find(descriptors, descriptorAt) == -1) continue;
            int row = this.convertRowIndexToView(i);
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        TableUtil.scrollSelectionToVisible(this);
    }

    public IdeaPluginDescriptor getSelectedObject() {
        IdeaPluginDescriptor selected2 = null;
        if (this.getSelectedRowCount() > 0) {
            selected2 = this.getObjectAt(this.getSelectedRow());
        }
        return selected2;
    }

    public IdeaPluginDescriptor[] getSelectedObjects() {
        IdeaPluginDescriptor[] selection = null;
        if (this.getSelectedRowCount() > 0) {
            int[] poses = this.getSelectedRows();
            selection = new IdeaPluginDescriptor[poses.length];
            for (int i = 0; i < poses.length; ++i) {
                selection[i] = this.getObjectAt(poses[i]);
            }
        }
        return selection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ide/plugins/PluginTable", "paint"));
    }
}

