/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.IdeCompatibleUpdate;
import com.intellij.openapi.updateSettings.IntellijUpdateMetadata;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u00013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u000eH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\"\u001a\n $*\u0004\u0018\u00010#0#2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\u0006\u0010%\u001a\u00020&H\u0007J$\u0010(\u001a\u0016\u0012\u0004\u0012\u00020\u0004 $*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00110\u00112\u0006\u0010%\u001a\u00020&H\u0002JK\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010*2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010+\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010,\u001a\u00020\u00042\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u0002H*0.H\u0007\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/ide/plugins/PluginsMetaLoader;", "", "()V", "AVAILABLE_PLUGINS_XML_IDS_URL", "", "COMPATIBLE_UPDATE_URL", "FULL_PLUGINS_XML_IDS_FILENAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TAG_EXT", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getETagFile", "Ljava/io/File;", "file", "getLastCompatiblePluginUpdate", "", "Lcom/intellij/openapi/updateSettings/IdeCompatibleUpdate;", "ids", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "getMarketplacePlugins", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getUpdateMetadataFile", "update", "getUpdateMetadataUrl", "getUpdatesMetadataFilesDirectory", "loadEtagForFile", "loadPluginDescriptor", "Lcom/intellij/ide/plugins/PluginNode;", "xmlId", "ideCompatibleUpdate", "parseJsonPluginMeta", "Lcom/intellij/openapi/updateSettings/IntellijUpdateMetadata;", "kotlin.jvm.PlatformType", "reader", "Ljava/io/Reader;", "parsePluginList", "parseXmlIds", "readOrUpdateFile", "T", "url", "indicatorMessage", "parser", "Lkotlin/Function1;", "(Ljava/io/File;Ljava/lang/String;Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "saveETagForFile", "", "eTag", "CompatibleUpdateRequest", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class PluginsMetaLoader {
    private static final Logger LOG;
    private static final String TAG_EXT = ".etag";
    private static final String FULL_PLUGINS_XML_IDS_FILENAME = "pluginsXMLIds.json";
    private static final String AVAILABLE_PLUGINS_XML_IDS_URL;
    private static final String COMPATIBLE_UPDATE_URL;
    private static final ObjectMapper objectMapper;
    public static final PluginsMetaLoader INSTANCE;

    private final File getUpdatesMetadataFilesDirectory() {
        return FilesKt.resolve((File)new File(PathManager.getPluginsPath()), (String)"meta");
    }

    private final File getUpdateMetadataFile(IdeCompatibleUpdate update2) {
        return FilesKt.resolve((File)this.getUpdatesMetadataFilesDirectory(), (String)(update2.getExternalUpdateId() + ".json"));
    }

    private final String getUpdateMetadataUrl(IdeCompatibleUpdate update2) {
        StringBuilder stringBuilder = new StringBuilder();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        return stringBuilder.append(applicationInfoEx.getPluginManagerUrl()).append("/files/").append(update2.getExternalPluginId()).append('/').append(update2.getExternalUpdateId()).append("/meta.json").toString();
    }

    @NotNull
    public final List<String> getMarketplacePlugins(@Nullable ProgressIndicator indicator) {
        File pluginXmlIdsFile = new File(PathManager.getPluginsPath(), FULL_PLUGINS_XML_IDS_FILENAME);
        String string = IdeBundle.message("progress.downloading.available.plugins", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"progr\u2026ading.available.plugins\")");
        Object t = PluginsMetaLoader.readOrUpdateFile(pluginXmlIdsFile, AVAILABLE_PLUGINS_XML_IDS_URL, indicator, string, (Function1)new Function1<Reader, List<? extends String>>(this){

            public final List<String> invoke(@NotNull Reader p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return PluginsMetaLoader.access$parseXmlIds((PluginsMetaLoader)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PluginsMetaLoader.class);
            }

            public final String getName() {
                return "parseXmlIds";
            }

            public final String getSignature() {
                return "parseXmlIds(Ljava/io/Reader;)Ljava/util/List;";
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"readOrUpdateFile(\n      \u2026      ::parseXmlIds\n    )");
        return (List)t;
    }

    @NotNull
    public final PluginNode loadPluginDescriptor(@NotNull String xmlId, @NotNull IdeCompatibleUpdate ideCompatibleUpdate, @Nullable ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)xmlId, (String)"xmlId");
        Intrinsics.checkParameterIsNotNull((Object)ideCompatibleUpdate, (String)"ideCompatibleUpdate");
        File file2 = this.getUpdateMetadataFile(ideCompatibleUpdate);
        String string = this.getUpdateMetadataUrl(ideCompatibleUpdate);
        String string2 = IdeBundle.message("progress.downloading.plugins.meta", xmlId);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeBundle.message(\"progr\u2026ing.plugins.meta\", xmlId)");
        return ((IntellijUpdateMetadata)PluginsMetaLoader.readOrUpdateFile(file2, string, indicator, string2, (Function1)new Function1<Reader, IntellijUpdateMetadata>(this){

            public final IntellijUpdateMetadata invoke(@NotNull Reader p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return PluginsMetaLoader.access$parseJsonPluginMeta((PluginsMetaLoader)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PluginsMetaLoader.class);
            }

            public final String getName() {
                return "parseJsonPluginMeta";
            }

            public final String getSignature() {
                return "parseJsonPluginMeta(Ljava/io/Reader;)Lcom/intellij/openapi/updateSettings/IntellijUpdateMetadata;";
            }
        })).toPluginNode();
    }

    @JvmStatic
    public static final <T> T readOrUpdateFile(@Nullable File file2, @NotNull String url, @Nullable ProgressIndicator indicator, @NotNull String indicatorMessage, @NotNull Function1<? super Reader, ? extends T> parser) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)indicatorMessage, (String)"indicatorMessage");
        Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
        String eTag = file2 != null ? INSTANCE.loadEtagForFile(file2) : null;
        return HttpRequests.request(url).tuner(new HttpRequests.ConnectionTuner(eTag){
            final /* synthetic */ String $eTag;

            public final void tune(@NotNull URLConnection connection) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
                    String string = this.$eTag;
                    if (string == null) break block0;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    connection.setRequestProperty("If-None-Match", it);
                }
            }
            {
                this.$eTag = string;
            }
        }).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor<T>(indicator, file2, parser, indicatorMessage){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ File $file;
            final /* synthetic */ Function1 $parser;
            final /* synthetic */ String $indicatorMessage;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T process(@NotNull HttpRequests.Request request2) {
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
                ProgressIndicator progressIndicator2 = this.$indicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.checkCanceled();
                }
                URLConnection uRLConnection = request2.getConnection();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"request.connection");
                URLConnection connection = uRLConnection;
                if (this.$file != null && this.$file.length() > 0L && connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                    Object object2 = this.$file;
                    Charset charset = Charsets.UTF_8;
                    int n = 8192;
                    boolean bl = false;
                    Object object3 = object2;
                    boolean bl2 = false;
                    Object object4 = object3;
                    boolean bl3 = false;
                    object4 = new FileInputStream((File)object4);
                    bl3 = false;
                    object3 = new InputStreamReader((InputStream)object4, charset);
                    bl2 = false;
                    object2 = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                    charset = this.$parser;
                    n = 0;
                    Throwable throwable = null;
                    try {
                        object3 = charset.invoke(object2);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    }
                    return (T)object3;
                }
                if (this.$indicator != null) {
                    this.$indicator.checkCanceled();
                    this.$indicator.setText2(this.$indicatorMessage);
                }
                if (this.$file != null) {
                    boolean bl;
                    Object object5;
                    Object object6 = PluginsMetaLoader.INSTANCE;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    synchronized (object6) {
                        Unit unit;
                        boolean bl6 = false;
                        request2.saveToFile(this.$file, this.$indicator);
                        String string = connection.getHeaderField("ETag");
                        if (string != null) {
                            object5 = string;
                            bl = false;
                            boolean bl7 = false;
                            String it = object5;
                            boolean bl8 = false;
                            PluginsMetaLoader.access$saveETagForFile(PluginsMetaLoader.INSTANCE, this.$file, it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    object6 = this.$file;
                    Charset charset = Charsets.UTF_8;
                    int n = 8192;
                    boolean bl9 = false;
                    object5 = object6;
                    bl = false;
                    Object object7 = object5;
                    boolean bl10 = false;
                    object7 = new FileInputStream((File)object7);
                    bl10 = false;
                    object5 = new InputStreamReader((InputStream)object7, charset);
                    bl = false;
                    object6 = object5 instanceof BufferedReader ? (BufferedReader)object5 : new BufferedReader((Reader)object5, n);
                    charset = this.$parser;
                    n = 0;
                    Throwable throwable = null;
                    try {
                        object5 = charset.invoke(object6);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object6, (Throwable)throwable);
                    }
                    return (T)object5;
                }
                Closeable closeable = request2.getReader();
                Function1 function1 = this.$parser;
                boolean bl = false;
                Throwable throwable = null;
                try {
                    object = function1.invoke((Object)closeable);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return (T)object;
            }
            {
                this.$indicator = progressIndicator2;
                this.$file = file2;
                this.$parser = function1;
                this.$indicatorMessage = string;
            }
        });
    }

    @NotNull
    public final List<IdeCompatibleUpdate> getLastCompatiblePluginUpdate(@NotNull List<String> ids, @Nullable BuildNumber buildNumber) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        String string = PluginDownloader.getBuildNumberForDownload(buildNumber);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PluginDownloader.getBuil\u2026rForDownload(buildNumber)");
        String data2 = objectMapper.writeValueAsString((Object)new CompatibleUpdateRequest(string, ids));
        String string2 = Urls.newFromEncoded((String)COMPATIBLE_UPDATE_URL).toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Urls.newFromEncoded(COMP\u2026ATE_URL).toExternalForm()");
        String url = string2;
        Object t = HttpRequests.post(url, "application/json; charset=utf-8").productNameAsUserAgent().connect(new HttpRequests.RequestProcessor<List<? extends IdeCompatibleUpdate>>(data2){
            final /* synthetic */ String $data;

            public final List<IdeCompatibleUpdate> process(@NotNull HttpRequests.Request it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.write(this.$data);
                Object object = PluginsMetaLoader.access$getObjectMapper$p(PluginsMetaLoader.INSTANCE).readValue(it.getInputStream(), (TypeReference)new TypeReference<List<? extends IdeCompatibleUpdate>>(){});
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectMapper\n          .\u2026Update>>() {}\n          )");
                return (List)object;
            }
            {
                this.$data = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"HttpRequests\n      .post\u2026() {}\n          )\n      }");
        return (List)t;
    }

    @JvmStatic
    @NotNull
    public static final List<PluginNode> parsePluginList(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            RepositoryContentHandler handler2 = new RepositoryContentHandler();
            parser.parse(new InputSource(reader), (DefaultHandler)handler2);
            List<PluginNode> list2 = handler2.getPluginsList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"handler.pluginsList");
            return list2;
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof ParserConfigurationException || exception instanceof SAXException || exception instanceof RuntimeException) {
                throw (Throwable)new IOException(e);
            }
            throw (Throwable)e;
        }
    }

    private final List<String> parseXmlIds(Reader reader) {
        return (List)objectMapper.readValue(reader, (TypeReference)new TypeReference<List<? extends String>>(){});
    }

    private final IntellijUpdateMetadata parseJsonPluginMeta(Reader reader) {
        return (IntellijUpdateMetadata)objectMapper.readValue(reader, IntellijUpdateMetadata.class);
    }

    private final File getETagFile(File file2) {
        return FilesKt.resolveSibling((File)file2, (String)(file2.getName() + TAG_EXT));
    }

    private final String loadEtagForFile(File file2) {
        File eTagFile = this.getETagFile(file2);
        if (eTagFile.exists()) {
            try {
                List lines = FilesKt.readLines$default((File)eTagFile, null, (int)1, null);
                if (lines.size() == 1) {
                    return (String)lines.get(0);
                }
                LOG.warn("Can't load ETag from '" + eTagFile.getAbsolutePath() + "'. Unexpected number of lines: " + lines.size());
                FileUtil.delete(eTagFile);
            }
            catch (IOException e) {
                LOG.warn("Can't load ETag from '" + eTagFile.getAbsolutePath() + "'", e);
            }
        }
        return "";
    }

    private final void saveETagForFile(File file2, String eTag) {
        File eTagFile = this.getETagFile(file2);
        try {
            FilesKt.writeText$default((File)eTagFile, (String)eTag, null, (int)2, null);
        }
        catch (IOException e) {
            LOG.warn("Can't save ETag to '" + eTagFile.getAbsolutePath() + "'", e);
        }
    }

    private PluginsMetaLoader() {
    }

    static {
        PluginsMetaLoader pluginsMetaLoader;
        INSTANCE = pluginsMetaLoader = new PluginsMetaLoader();
        Logger logger = Logger.getInstance(PluginsMetaLoader.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(PluginsMetaLoader::class.java)");
        LOG = logger;
        StringBuilder stringBuilder = new StringBuilder();
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        AVAILABLE_PLUGINS_XML_IDS_URL = stringBuilder.append(applicationInfoEx.getPluginManagerUrl()).append("/files/pluginsXMLIds.json").toString();
        StringBuilder stringBuilder2 = new StringBuilder();
        ApplicationInfoEx applicationInfoEx2 = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfoEx2, (String)"ApplicationInfoImpl.getShadowInstance()");
        String string = applicationInfoEx2.getPluginManagerUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfoImpl.getS\u2026stance().pluginManagerUrl");
        COMPATIBLE_UPDATE_URL = stringBuilder2.append(StringsKt.trimEnd((String)string, (char[])new char[]{'/'})).append("/api/search/compatibleUpdates").toString();
        objectMapper = new ObjectMapper();
    }

    public static final /* synthetic */ List access$parseXmlIds(PluginsMetaLoader $this, Reader reader) {
        return $this.parseXmlIds(reader);
    }

    public static final /* synthetic */ IntellijUpdateMetadata access$parseJsonPluginMeta(PluginsMetaLoader $this, Reader reader) {
        return $this.parseJsonPluginMeta(reader);
    }

    public static final /* synthetic */ void access$saveETagForFile(PluginsMetaLoader $this, File file2, String eTag) {
        $this.saveETagForFile(file2, eTag);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(PluginsMetaLoader $this) {
        PluginsMetaLoader pluginsMetaLoader = $this;
        return objectMapper;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/plugins/PluginsMetaLoader$CompatibleUpdateRequest;", "", "build", "", "pluginXMLIds", "", "(Ljava/lang/String;Ljava/util/List;)V", "getBuild", "()Ljava/lang/String;", "getPluginXMLIds", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    private static final class CompatibleUpdateRequest {
        @NotNull
        private final String build;
        @NotNull
        private final List<String> pluginXMLIds;

        @NotNull
        public final String getBuild() {
            return this.build;
        }

        @NotNull
        public final List<String> getPluginXMLIds() {
            return this.pluginXMLIds;
        }

        public CompatibleUpdateRequest(@NotNull String build2, @NotNull List<String> pluginXMLIds) {
            Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
            Intrinsics.checkParameterIsNotNull(pluginXMLIds, (String)"pluginXMLIds");
            this.build = build2;
            this.pluginXMLIds = pluginXMLIds;
        }

        @NotNull
        public final String component1() {
            return this.build;
        }

        @NotNull
        public final List<String> component2() {
            return this.pluginXMLIds;
        }

        @NotNull
        public final CompatibleUpdateRequest copy(@NotNull String build2, @NotNull List<String> pluginXMLIds) {
            Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
            Intrinsics.checkParameterIsNotNull(pluginXMLIds, (String)"pluginXMLIds");
            return new CompatibleUpdateRequest(build2, pluginXMLIds);
        }

        public static /* synthetic */ CompatibleUpdateRequest copy$default(CompatibleUpdateRequest compatibleUpdateRequest, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = compatibleUpdateRequest.build;
            }
            if ((n & 2) != 0) {
                list2 = compatibleUpdateRequest.pluginXMLIds;
            }
            return compatibleUpdateRequest.copy(string, list2);
        }

        @NotNull
        public String toString() {
            return "CompatibleUpdateRequest(build=" + this.build + ", pluginXMLIds=" + this.pluginXMLIds + ")";
        }

        public int hashCode() {
            String string = this.build;
            List<String> list2 = this.pluginXMLIds;
            return (string != null ? string.hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompatibleUpdateRequest)) break block3;
                    CompatibleUpdateRequest compatibleUpdateRequest = (CompatibleUpdateRequest)object;
                    if (!Intrinsics.areEqual((Object)this.build, (Object)compatibleUpdateRequest.build) || !Intrinsics.areEqual(this.pluginXMLIds, compatibleUpdateRequest.pluginXMLIds)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

