/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeNotesPanel {
    private final JPanel myPanel;
    private final JLabel myTitle;
    private final JEditorPane myEditorPane;
    private final JEditorPane myDescriptionPane;

    public ChangeNotesPanel(@NotNull JPanel parent, @Nullable Object constraints, @NotNull JEditorPane descriptionPane) {
        if (parent == null) {
            ChangeNotesPanel.$$$reportNull$$$0(0);
        }
        if (descriptionPane == null) {
            ChangeNotesPanel.$$$reportNull$$$0(1);
        }
        this.myPanel = new OpaquePanel((LayoutManager)new BorderLayout(), PluginManagerConfigurable.MAIN_BG_COLOR);
        this.myTitle = new JLabel(IdeBundle.message("label.plugin.change.notes", new Object[0]), AllIcons.General.ArrowRight, 2){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, Math.min(width, this.getPreferredSize().width), height);
            }
        };
        this.myEditorPane = PluginDetailsPageComponent.createDescriptionComponent(null);
        this.myDescriptionPane = descriptionPane;
        parent.add((Component)this.myPanel, constraints);
        this.myPanel.add((Component)this.myTitle, "North");
        this.myPanel.add(this.myEditorPane);
        this.myEditorPane.setBorder(JBUI.Borders.emptyLeft(20));
        this.myTitle.setCursor(Cursor.getPredefinedCursor(12));
        this.myTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ChangeNotesPanel.this.setDecorateState(!ChangeNotesPanel.this.myEditorPane.isVisible());
            }
        });
        this.setDecorateState(false);
    }

    public void show(@Nullable String text2) {
        if (text2 == null) {
            this.myPanel.setVisible(false);
        } else {
            this.myEditorPane.setText(XmlStringUtil.wrapInHtml(text2));
            if (this.myEditorPane.getCaret() != null) {
                this.myEditorPane.setCaretPosition(0);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myTitle.setBorder(JBUI.Borders.empty(ChangeNotesPanel.getBorder(this.myDescriptionPane, true), 0, ChangeNotesPanel.getBorder(this.myEditorPane, false), 0));
                this.fullRepaint();
            });
            this.setDecorateState(false);
            this.myPanel.setVisible(true);
        }
    }

    private void setDecorateState(boolean show2) {
        this.myTitle.setIcon(show2 ? AllIcons.General.ArrowDown : AllIcons.General.ArrowRight);
        this.myEditorPane.setVisible(show2);
        this.fullRepaint();
    }

    private void fullRepaint() {
        this.myPanel.doLayout();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private static int getBorder(@NotNull JEditorPane editorPane, boolean top) {
        if (editorPane == null) {
            ChangeNotesPanel.$$$reportNull$$$0(2);
        }
        try {
            Rectangle r;
            Rectangle bounds2 = editorPane.getBounds();
            if (bounds2.width <= 0 || bounds2.height <= 0) {
                editorPane.setSize(editorPane.getPreferredSize());
            }
            if ((r = editorPane.modelToView(top ? editorPane.getDocument().getLength() - 1 : 3)) != null && (top ? r.y + r.height == editorPane.getHeight() : r.y == 0)) {
                return 10;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionPane";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/ChangeNotesPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBorder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

