/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.plugins.newui.InstallPluginInfo;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyPluginModel
extends InstalledPluginsTableModel
implements PluginManagerMain.PluginEnabler {
    private static final Logger LOG = Logger.getInstance(MyPluginModel.class);
    private final List<ListPluginComponent> myInstalledPluginComponents = new ArrayList<ListPluginComponent>();
    private final Map<PluginId, List<ListPluginComponent>> myInstalledPluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final Map<PluginId, List<ListPluginComponent>> myMarketplacePluginComponentMap = new HashMap<PluginId, List<ListPluginComponent>>();
    private final List<PluginsGroup> myEnabledGroups = new ArrayList<PluginsGroup>();
    private PluginsGroupComponent myInstalledPanel;
    private PluginsGroup myDownloaded;
    private PluginsGroup myInstalling;
    private PluginsGroup myUpdates;
    private Configurable.TopComponentController myTopController;
    private List<String> myVendorsSorted;
    private List<String> myTagsSorted;
    private static final Set<IdeaPluginDescriptor> myInstallingPlugins = new HashSet<IdeaPluginDescriptor>();
    private static final Set<IdeaPluginDescriptor> myInstallingWithUpdatesPlugins = new HashSet<IdeaPluginDescriptor>();
    static final Map<PluginId, InstallPluginInfo> myInstallingInfos = new HashMap<PluginId, InstallPluginInfo>();
    public boolean needRestart;
    public boolean createShutdownCallback = true;
    private boolean myInstallsRequiringRestart;
    private final List<PluginDetailsPageComponent> myDetailPanels = new ArrayList<PluginDetailsPageComponent>();
    private StatusBarEx myStatusBar;
    private PluginUpdatesService myPluginUpdatesService;
    private Runnable myInvalidFixCallback;
    private final Map<PluginId, PendingDynamicPluginInstall> myDynamicPluginsToInstall = new LinkedHashMap<PluginId, PendingDynamicPluginInstall>();
    private final Set<IdeaPluginDescriptor> myDynamicPluginsToUninstall = new HashSet<IdeaPluginDescriptor>();
    private final Set<IdeaPluginDescriptor> myPluginsToRemoveOnCancel = new HashSet<IdeaPluginDescriptor>();
    private final Set<PluginId> myErrorPluginsToDisable = new HashSet<PluginId>();

    protected MyPluginModel() {
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        this.myStatusBar = MyPluginModel.getStatusBar(window);
        if (this.myStatusBar == null && window != null) {
            this.myStatusBar = MyPluginModel.getStatusBar(window.getOwner());
        }
    }

    @Nullable
    private static StatusBarEx getStatusBar(@Nullable Window frame) {
        if (frame instanceof IdeFrame && !(frame instanceof WelcomeFrame)) {
            return (StatusBarEx)((IdeFrame)((Object)frame)).getStatusBar();
        }
        return null;
    }

    public boolean isModified() {
        if (this.needRestart || !this.myDynamicPluginsToInstall.isEmpty() || !this.myDynamicPluginsToUninstall.isEmpty() || !this.myPluginsToRemoveOnCancel.isEmpty()) {
            return true;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : this.view) {
            boolean enabledInTable = this.isEnabled(ideaPluginDescriptor);
            if (ideaPluginDescriptor.isEnabled() == enabledInTable || enabledInTable && !PluginManagerCore.isDisabled(ideaPluginDescriptor.getPluginId())) continue;
            return true;
        }
        for (Map.Entry entry : this.getEnabledMap().entrySet()) {
            Boolean enabled = (Boolean)entry.getValue();
            if (enabled == null || enabled.booleanValue() || PluginManagerCore.isDisabled((PluginId)entry.getKey())) continue;
            return true;
        }
        return false;
    }

    public boolean apply(JComponent parent) throws ConfigurationException {
        boolean changesAppliedWithoutRestart;
        Map<PluginId, Boolean> enabledMap = this.getEnabledMap();
        ArrayList<String> dependencies = new ArrayList<String>();
        block2: for (Map.Entry<PluginId, Set<PluginId>> entry : this.getDependentToRequiredListMap().entrySet()) {
            PluginId pluginId = entry.getKey();
            if (enabledMap.get(pluginId) == null) continue;
            for (PluginId dependId : (Set)entry.getValue()) {
                if (PluginManagerCore.isModuleDependency(dependId)) continue;
                IdeaPluginDescriptor descriptor2 = PluginManagerCore.getPlugin(pluginId);
                if (descriptor2 instanceof IdeaPluginDescriptorImpl && (((IdeaPluginDescriptorImpl)descriptor2).isDeleted() || descriptor2.isImplementationDetail())) continue block2;
                dependencies.add("\"" + (descriptor2 == null ? pluginId.getIdString() : descriptor2.getName()) + "\"");
                continue block2;
            }
        }
        if (!dependencies.isEmpty()) {
            throw new ConfigurationException("<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependencies.size() == 1 ? " " : "s ") + StringUtil.join(dependencies, ", ") + " won't be able to load.</body></html>");
        }
        HashSet<PluginId> uninstallsRequiringRestart = new HashSet<PluginId>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : this.myDynamicPluginsToUninstall) {
            if (!PluginInstaller.uninstallDynamicPlugin(parent, ideaPluginDescriptor, false)) {
                uninstallsRequiringRestart.add(ideaPluginDescriptor.getPluginId());
                continue;
            }
            enabledMap.remove(ideaPluginDescriptor.getPluginId());
        }
        boolean installsRequiringRestart = this.myInstallsRequiringRestart;
        for (PendingDynamicPluginInstall pendingPluginInstall : this.myDynamicPluginsToInstall.values()) {
            if (!uninstallsRequiringRestart.contains(pendingPluginInstall.getPluginDescriptor().getPluginId())) {
                InstalledPluginsState.getInstance().trackPluginInstallation(() -> PluginInstaller.installAndLoadDynamicPlugin(pendingPluginInstall.getFile(), parent, pendingPluginInstall.getPluginDescriptor()));
                continue;
            }
            try {
                PluginInstaller.installAfterRestart(pendingPluginInstall.getFile(), true, null, pendingPluginInstall.getPluginDescriptor());
                installsRequiringRestart = true;
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        this.myDynamicPluginsToInstall.clear();
        this.myPluginsToRemoveOnCancel.clear();
        boolean bl = this.applyEnableDisablePlugins(parent, enabledMap);
        this.myDynamicPluginsToUninstall.clear();
        boolean bl2 = changesAppliedWithoutRestart = bl && uninstallsRequiringRestart.isEmpty() && !installsRequiringRestart;
        if (!changesAppliedWithoutRestart) {
            InstalledPluginsState.getInstance().setRestartRequired(true);
        }
        return changesAppliedWithoutRestart;
    }

    public void removePluginsOnCancel(@Nullable JComponent parentComponent) {
        this.myPluginsToRemoveOnCancel.forEach(pluginDescriptor -> PluginInstaller.uninstallDynamicPlugin(parentComponent, pluginDescriptor, false));
        this.myPluginsToRemoveOnCancel.clear();
    }

    private boolean applyEnableDisablePlugins(JComponent parentComponent, Map<PluginId, Boolean> enabledMap) {
        ArrayList<IdeaPluginDescriptor> pluginDescriptorsToDisable = new ArrayList<IdeaPluginDescriptor>();
        ArrayList<IdeaPluginDescriptor> pluginDescriptorsToEnable = new ArrayList<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor descriptor2 : this.view) {
            PluginId pluginId;
            if (this.myDynamicPluginsToUninstall.contains(descriptor2) || enabledMap.get(pluginId = descriptor2.getPluginId()) == null) continue;
            boolean shouldEnable = this.isEnabled(pluginId);
            if (shouldEnable != descriptor2.isEnabled()) {
                if (shouldEnable) {
                    pluginDescriptorsToEnable.add(descriptor2);
                    continue;
                }
                pluginDescriptorsToDisable.add(descriptor2);
                continue;
            }
            if (shouldEnable || !this.myErrorPluginsToDisable.contains(pluginId)) continue;
            pluginDescriptorsToDisable.add(descriptor2);
        }
        return PluginEnabler.updatePluginEnabledState(pluginDescriptorsToEnable, pluginDescriptorsToDisable, parentComponent);
    }

    public void pluginInstalledFromDisk(@NotNull PluginInstallCallbackData callbackData) {
        if (callbackData == null) {
            MyPluginModel.$$$reportNull$$$0(0);
        }
        this.appendOrUpdateDescriptor(callbackData.getPluginDescriptor(), callbackData.getRestartNeeded());
        if (!callbackData.getRestartNeeded()) {
            this.myDynamicPluginsToInstall.put(callbackData.getPluginDescriptor().getPluginId(), new PendingDynamicPluginInstall(callbackData.getFile(), callbackData.getPluginDescriptor()));
        }
    }

    public void addComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(1);
        }
        if (!component2.isMarketplace()) {
            if (myInstallingPlugins.contains(component2.myPlugin)) {
                return;
            }
            this.myInstalledPluginComponents.add(component2);
            List components = this.myInstalledPluginComponentMap.computeIfAbsent(component2.myPlugin.getPluginId(), __ -> new ArrayList());
            components.add(component2);
        } else {
            List components = this.myMarketplacePluginComponentMap.computeIfAbsent(component2.myPlugin.getPluginId(), __ -> new ArrayList());
            components.add(component2);
        }
    }

    public void removeComponent(@NotNull ListPluginComponent component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(2);
        }
        if (!component2.isMarketplace()) {
            this.myInstalledPluginComponents.remove(component2);
            List<ListPluginComponent> components = this.myInstalledPluginComponentMap.get(component2.myPlugin.getPluginId());
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myInstalledPluginComponentMap.remove(component2.myPlugin.getPluginId());
                }
            }
        } else {
            List<ListPluginComponent> components = this.myMarketplacePluginComponentMap.get(component2.myPlugin.getPluginId());
            if (components != null) {
                components.remove(component2);
                if (components.isEmpty()) {
                    this.myMarketplacePluginComponentMap.remove(component2.myPlugin.getPluginId());
                }
            }
        }
    }

    public void setTopController(@NotNull Configurable.TopComponentController topController) {
        if (topController == null) {
            MyPluginModel.$$$reportNull$$$0(3);
        }
        this.myTopController = topController;
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.fromBackground(this);
        }
        if (!myInstallingInfos.isEmpty()) {
            this.myTopController.showProgress(true);
        }
    }

    public void setPluginUpdatesService(@NotNull PluginUpdatesService service) {
        if (service == null) {
            MyPluginModel.$$$reportNull$$$0(4);
        }
        this.myPluginUpdatesService = service;
    }

    @Nullable
    public PluginsGroup getDownloadedGroup() {
        return this.myDownloaded;
    }

    @NotNull
    public static Set<IdeaPluginDescriptor> getInstallingPlugins() {
        Set<IdeaPluginDescriptor> set = myInstallingPlugins;
        if (set == null) {
            MyPluginModel.$$$reportNull$$$0(5);
        }
        return set;
    }

    static boolean isInstallingOrUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(6);
        }
        return myInstallingWithUpdatesPlugins.contains(descriptor2);
    }

    void installOrUpdatePlugin(@Nullable JComponent parentComponent, @NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor, @NotNull ModalityState modalityState) {
        PluginNode pluginNode;
        IdeaPluginDescriptor actionDescriptor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(7);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(8);
        }
        IdeaPluginDescriptor ideaPluginDescriptor = actionDescriptor = updateDescriptor == null ? descriptor2 : updateDescriptor;
        if (!PluginManagerMain.checkThirdPartyPluginsAllowed(Collections.singletonList(actionDescriptor))) {
            return;
        }
        boolean allowUninstallWithoutRestart = true;
        if (updateDescriptor != null) {
            IdeaPluginDescriptorImpl installedPluginDescriptor = PluginEnabler.tryLoadFullDescriptor((IdeaPluginDescriptorImpl)descriptor2);
            if (installedPluginDescriptor == null || !DynamicPlugins.allowLoadUnloadWithoutRestart(installedPluginDescriptor)) {
                allowUninstallWithoutRestart = false;
            } else if (!installedPluginDescriptor.isEnabled()) {
                FileUtil.delete(installedPluginDescriptor.getPath());
            } else if (DynamicPlugins.allowLoadUnloadSynchronously(installedPluginDescriptor)) {
                if (!PluginInstaller.uninstallDynamicPlugin(parentComponent, installedPluginDescriptor, true)) {
                    allowUninstallWithoutRestart = false;
                }
            } else {
                this.performUninstall(installedPluginDescriptor);
            }
        }
        if (actionDescriptor instanceof PluginNode) {
            pluginNode = (PluginNode)actionDescriptor;
        } else {
            pluginNode = new PluginNode(actionDescriptor.getPluginId(), actionDescriptor.getName(), "-1");
            pluginNode.setDepends(Arrays.asList(actionDescriptor.getDependentPluginIds()), actionDescriptor.getOptionalDependentPluginIds());
            pluginNode.setRepositoryName("__unknown_repository__");
        }
        ArrayList<PluginNode> pluginsToInstall = ContainerUtil.newArrayList(new PluginNode[]{pluginNode});
        PluginManagerMain.suggestToEnableInstalledDependantPlugins(this, pluginsToInstall);
        this.installPlugin(pluginsToInstall, this.getAllRepoPlugins(), this.prepareToInstall(descriptor2, updateDescriptor), allowUninstallWithoutRestart, modalityState);
    }

    private void installPlugin(@NotNull List<PluginNode> pluginsToInstall, @NotNull List<? extends IdeaPluginDescriptor> allPlugins, @NotNull InstallPluginInfo info, boolean allowInstallWithoutRestart, @NotNull ModalityState modalityState) {
        if (pluginsToInstall == null) {
            MyPluginModel.$$$reportNull$$$0(9);
        }
        if (allPlugins == null) {
            MyPluginModel.$$$reportNull$$$0(10);
        }
        if (info == null) {
            MyPluginModel.$$$reportNull$$$0(11);
        }
        if (modalityState == null) {
            MyPluginModel.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean cancel = false;
            boolean error = false;
            boolean showErrors = true;
            boolean restartRequired = true;
            ArrayList<PendingDynamicPluginInstall> pluginsToInstallSynchronously = new ArrayList<PendingDynamicPluginInstall>();
            try {
                PluginInstallOperation operation = new PluginInstallOperation(pluginsToInstall, allPlugins, this, info.indicator);
                operation.setAllowInstallWithoutRestart(allowInstallWithoutRestart);
                operation.run();
                for (PendingDynamicPluginInstall install : operation.getPendingDynamicPluginInstalls()) {
                    if (DynamicPlugins.allowLoadUnloadSynchronously(install.getPluginDescriptor())) {
                        pluginsToInstallSynchronously.add(install);
                        this.myPluginsToRemoveOnCancel.add(install.getPluginDescriptor());
                        continue;
                    }
                    this.myDynamicPluginsToInstall.put(install.getPluginDescriptor().getPluginId(), install);
                }
                error = !operation.isSuccess();
                showErrors = !operation.isShownErrors();
                restartRequired = operation.isRestartRequired();
            }
            catch (ProcessCanceledException e) {
                cancel = true;
            }
            catch (Throwable e) {
                LOG.error(e);
                error = true;
            }
            boolean success = !error;
            boolean _cancel = cancel;
            boolean _showErrors = showErrors;
            boolean finalRestartRequired = restartRequired;
            ApplicationManager.getApplication().invokeLater(() -> {
                for (PendingDynamicPluginInstall install : pluginsToInstallSynchronously) {
                    IdeaPluginDescriptorImpl installedDescriptor = PluginInstaller.installAndLoadDynamicPlugin(install.getFile(), this.myInstalledPanel, install.getPluginDescriptor());
                    if (installedDescriptor == null || !installedDescriptor.getPluginId().equals(info.getDescriptor().getPluginId())) continue;
                    info.setInstalledDescriptor(installedDescriptor);
                }
                info.finish(success, _cancel, _showErrors, finalRestartRequired);
            }, modalityState);
        });
    }

    public boolean toBackground() {
        for (InstallPluginInfo info : myInstallingInfos.values()) {
            info.toBackground(this.myStatusBar);
        }
        return !myInstallingInfos.isEmpty();
    }

    @NotNull
    private InstallPluginInfo prepareToInstall(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptor updateDescriptor) {
        List<ListPluginComponent> listComponents;
        List<ListPluginComponent> gridComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(13);
        }
        boolean install = updateDescriptor == null;
        InstallPluginInfo info = new InstallPluginInfo(descriptor2, updateDescriptor, this, install);
        myInstallingInfos.put(descriptor2.getPluginId(), info);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(true);
        }
        myInstallingWithUpdatesPlugins.add(descriptor2);
        if (install) {
            myInstallingPlugins.add(descriptor2);
        }
        if (install && this.myInstalling != null) {
            if (this.myInstalling.ui == null) {
                this.myInstalling.descriptors.add(descriptor2);
                this.myInstalledPanel.addGroup(this.myInstalling, 0);
            } else {
                this.myInstalledPanel.addToGroup(this.myInstalling, descriptor2);
            }
            this.myInstalling.titleWithCount();
            this.myInstalledPanel.doLayout();
        }
        if ((gridComponents = this.myMarketplacePluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent gridComponent : gridComponents) {
                gridComponent.showProgress();
            }
        }
        if ((listComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.showProgress();
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.myPlugin != descriptor2) continue;
            panel2.showProgress();
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(14);
        }
        return installPluginInfo;
    }

    void finishInstall(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptorImpl installedDescriptor, boolean success, boolean showErrors, boolean restartRequired) {
        List<ListPluginComponent> installedComponents;
        List<ListPluginComponent> marketplaceComponents;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(15);
        }
        InstallPluginInfo info = MyPluginModel.finishInstall(descriptor2);
        if (myInstallingWithUpdatesPlugins.isEmpty()) {
            this.myTopController.showProgress(false);
        }
        if ((marketplaceComponents = this.myMarketplacePluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listPluginComponent : marketplaceComponents) {
                if (installedDescriptor != null) {
                    listPluginComponent.myPlugin = installedDescriptor;
                }
                listPluginComponent.hideProgress(success, restartRequired);
            }
        }
        if ((installedComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId())) != null) {
            for (ListPluginComponent listComponent : installedComponents) {
                if (installedDescriptor != null) {
                    listComponent.myPlugin = installedDescriptor;
                }
                listComponent.hideProgress(success, restartRequired);
            }
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (!panel2.isShowingPlugin(descriptor2)) continue;
            if (installedDescriptor != null) {
                panel2.myPlugin = installedDescriptor;
            }
            panel2.hideProgress(success);
        }
        if (info.install) {
            if (this.myInstalling != null && this.myInstalling.ui != null) {
                this.clearInstallingProgress(descriptor2);
                if (myInstallingPlugins.isEmpty()) {
                    this.myInstalledPanel.removeGroup(this.myInstalling);
                } else {
                    this.myInstalledPanel.removeFromGroup(this.myInstalling, descriptor2);
                    this.myInstalling.titleWithCount();
                }
                this.myInstalledPanel.doLayout();
            }
            if (success) {
                this.appendOrUpdateDescriptor(installedDescriptor != null ? installedDescriptor : descriptor2, restartRequired);
                this.appendDependsAfterInstall();
            }
        } else if (success) {
            ListPluginComponent listPluginComponent;
            if (this.myDownloaded != null && this.myDownloaded.ui != null && restartRequired && (listPluginComponent = this.myDownloaded.ui.findComponent(descriptor2)) != null) {
                listPluginComponent.enableRestart();
            }
            if (this.myUpdates != null) {
                this.myUpdates.titleWithCount();
            }
            this.myPluginUpdatesService.finishUpdate(info.updateDescriptor);
        } else {
            this.myPluginUpdatesService.finishUpdate();
        }
        info.indicator.cancel();
        if (success) {
            this.needRestart = true;
            this.myInstallsRequiringRestart |= restartRequired;
        }
        if (!success && showErrors) {
            Messages.showErrorDialog(IdeBundle.message("plugins.configurable.plugin.installing.failed", descriptor2.getName()), IdeBundle.message("action.download.and.install.plugin", new Object[0]));
        }
    }

    private void clearInstallingProgress(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(16);
        }
        if (myInstallingPlugins.isEmpty()) {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                listComponent.clearProgress();
            }
        } else {
            for (ListPluginComponent listComponent : this.myInstalling.ui.plugins) {
                if (listComponent.myPlugin != descriptor2) continue;
                listComponent.clearProgress();
                return;
            }
        }
    }

    @NotNull
    static InstallPluginInfo finishInstall(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(17);
        }
        InstallPluginInfo info = myInstallingInfos.remove(descriptor2.getPluginId());
        info.close();
        myInstallingWithUpdatesPlugins.remove(descriptor2);
        if (info.install) {
            myInstallingPlugins.remove(descriptor2);
        }
        InstallPluginInfo installPluginInfo = info;
        if (installPluginInfo == null) {
            MyPluginModel.$$$reportNull$$$0(18);
        }
        return installPluginInfo;
    }

    static void addProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(19);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(20);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.addStateDelegate(indicator);
    }

    static void removeProgress(@NotNull IdeaPluginDescriptor descriptor2, @NotNull ProgressIndicatorEx indicator) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            MyPluginModel.$$$reportNull$$$0(22);
        }
        MyPluginModel.myInstallingInfos.get((Object)descriptor2.getPluginId()).indicator.removeStateDelegate(indicator);
    }

    public void addEnabledGroup(@NotNull PluginsGroup group) {
        if (group == null) {
            MyPluginModel.$$$reportNull$$$0(23);
        }
        this.myEnabledGroups.add(group);
    }

    public void setDownloadedGroup(@NotNull PluginsGroupComponent panel2, @NotNull PluginsGroup downloaded, @NotNull PluginsGroup installing) {
        if (panel2 == null) {
            MyPluginModel.$$$reportNull$$$0(24);
        }
        if (downloaded == null) {
            MyPluginModel.$$$reportNull$$$0(25);
        }
        if (installing == null) {
            MyPluginModel.$$$reportNull$$$0(26);
        }
        this.myInstalledPanel = panel2;
        this.myDownloaded = downloaded;
        this.myInstalling = installing;
    }

    public void setUpdateGroup(@NotNull PluginsGroup group) {
        if (group == null) {
            MyPluginModel.$$$reportNull$$$0(27);
        }
        this.myUpdates = group;
    }

    private void appendDependsAfterInstall() {
        if (this.myDownloaded == null || this.myDownloaded.ui == null) {
            return;
        }
        block0: for (IdeaPluginDescriptor descriptor2 : InstalledPluginsState.getInstance().getInstalledPlugins()) {
            if (this.myDownloaded.ui.findComponent(descriptor2) != null) continue;
            this.appendOrUpdateDescriptor(descriptor2, true);
            String id2 = descriptor2.getPluginId().getIdString();
            for (Map.Entry<PluginId, List<ListPluginComponent>> entry : this.myMarketplacePluginComponentMap.entrySet()) {
                if (!id2.equals(entry.getKey().getIdString())) continue;
                for (ListPluginComponent component2 : entry.getValue()) {
                    component2.hideProgress(true, true);
                }
                continue block0;
            }
        }
    }

    public void addDetailPanel(@NotNull PluginDetailsPageComponent detailPanel) {
        if (detailPanel == null) {
            MyPluginModel.$$$reportNull$$$0(28);
        }
        this.myDetailPanels.add(detailPanel);
    }

    public void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor2, boolean restartNeeded) {
        PluginId id2;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(29);
        }
        if (!PluginManagerCore.isPluginInstalled(id2 = descriptor2.getPluginId())) {
            int i = this.view.indexOf(descriptor2);
            if (i < 0) {
                this.view.add(descriptor2);
            } else {
                this.view.set(i, descriptor2);
            }
            this.setEnabled(descriptor2, true);
        }
        if (restartNeeded) {
            this.myInstallsRequiringRestart = true;
            this.needRestart = true;
        }
        if (this.myDownloaded == null) {
            return;
        }
        this.myVendorsSorted = null;
        this.myTagsSorted = null;
        if (this.myDownloaded.ui == null) {
            this.myDownloaded.descriptors.add(descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.addGroup(this.myDownloaded, this.myInstalling == null || this.myInstalling.ui == null ? 0 : 1);
            this.myInstalledPanel.setSelection(this.myDownloaded.ui.plugins.get(0));
            this.myInstalledPanel.doLayout();
            this.addEnabledGroup(this.myDownloaded);
        } else {
            ListPluginComponent component2 = this.myDownloaded.ui.findComponent(descriptor2);
            if (component2 != null) {
                this.myInstalledPanel.setSelection(component2);
                component2.enableRestart();
                return;
            }
            this.myInstalledPanel.addToGroup(this.myDownloaded, descriptor2);
            this.myDownloaded.titleWithEnabled(this);
            this.myInstalledPanel.setSelection(this.myDownloaded.ui.plugins.get(this.myDownloaded.descriptors.indexOf(descriptor2)));
            this.myInstalledPanel.doLayout();
        }
    }

    @NotNull
    public List<String> getVendors() {
        if (ContainerUtil.isEmpty(this.myVendorsSorted)) {
            this.myVendorsSorted = MyPluginModel.getVendors(this.getInstalledDescriptors());
        }
        List<String> list2 = this.myVendorsSorted;
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    public List<String> getTags() {
        if (ContainerUtil.isEmpty(this.myTagsSorted)) {
            HashSet<String> allTags = new HashSet<String>();
            for (IdeaPluginDescriptor descriptor2 : this.getInstalledDescriptors()) {
                allTags.addAll(PluginManagerConfigurable.getTags(descriptor2));
            }
            this.myTagsSorted = ContainerUtil.sorted(allTags, String::compareToIgnoreCase);
        }
        List<String> list2 = this.myTagsSorted;
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    public List<IdeaPluginDescriptor> getInstalledDescriptors() {
        assert (this.myInstalledPanel != null);
        List<IdeaPluginDescriptor> list2 = this.myInstalledPanel.getGroups().stream().flatMap(group -> group.plugins.stream()).map(plugin -> plugin.myPlugin).collect(Collectors.toList());
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @NotNull
    public static List<String> getVendors(@NotNull List<? extends IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            MyPluginModel.$$$reportNull$$$0(33);
        }
        HashMap<String, Integer> vendors = new HashMap<String, Integer>();
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            String vendor = StringUtil.trim(ideaPluginDescriptor.getVendor());
            if (StringUtil.isEmptyOrSpaces(vendor)) continue;
            Integer count = (Integer)vendors.get(vendor);
            if (count == null) {
                vendors.put(vendor, 1);
                continue;
            }
            vendors.put(vendor, count + 1);
        }
        vendors.put("JetBrains", Integer.MAX_VALUE);
        List<String> list2 = ContainerUtil.sorted(vendors.keySet(), (v1, v2) -> {
            int result2 = (Integer)vendors.get(v2) - (Integer)vendors.get(v1);
            return result2 == 0 ? v2.compareToIgnoreCase((String)v1) : result2;
        });
        if (list2 == null) {
            MyPluginModel.$$$reportNull$$$0(34);
        }
        return list2;
    }

    public static boolean isVendor(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Set<String> vendors) {
        String vendor;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(35);
        }
        if (vendors == null) {
            MyPluginModel.$$$reportNull$$$0(36);
        }
        if (StringUtil.isEmpty(vendor = StringUtil.trim(descriptor2.getVendor()))) {
            return false;
        }
        for (String vendorToFind : vendors) {
            if (!vendor.equalsIgnoreCase(vendorToFind) && !StringUtil.containsIgnoreCase(vendor, vendorToFind)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(@NotNull IdeaPluginDescriptor plugin) {
        Boolean enabled;
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(37);
        }
        return (enabled = this.getEnabledMap().get(plugin.getPluginId())) == null || enabled != false;
    }

    @NotNull
    String getEnabledTitle(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(38);
        }
        String string = this.isEnabled(plugin) ? IdeBundle.message("plugins.configurable.disable.button", new Object[0]) : IdeBundle.message("plugins.configurable.enable.button", new Object[0]);
        if (string == null) {
            MyPluginModel.$$$reportNull$$$0(39);
        }
        return string;
    }

    void changeEnableDisable(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(40);
        }
        this.changeEnableDisable(new IdeaPluginDescriptor[]{plugin}, !this.isEnabled(plugin));
    }

    public void changeEnableDisable(IdeaPluginDescriptor @NotNull [] plugins2, boolean state) {
        if (plugins2 == null) {
            MyPluginModel.$$$reportNull$$$0(41);
        }
        this.enableRows(plugins2, state);
        this.updateAfterEnableDisable();
        this.runInvalidFixCallback();
    }

    @Override
    public void enablePlugins(Set<? extends IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), true);
    }

    @Override
    public void disablePlugins(Set<? extends IdeaPluginDescriptor> disabled) {
        this.changeEnableDisable(disabled.toArray(new IdeaPluginDescriptor[0]), false);
    }

    void enableRequiredPlugins(@NotNull IdeaPluginDescriptor descriptor2) {
        Set<PluginId> requiredPluginIds;
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(42);
        }
        if (ContainerUtil.isEmpty(requiredPluginIds = this.getRequiredPlugins(descriptor2.getPluginId()))) {
            return;
        }
        List<IdeaPluginDescriptor> allPlugins = this.getAllPlugins();
        HashSet<IdeaPluginDescriptor> requiredPlugins = new HashSet<IdeaPluginDescriptor>();
        for (PluginId pluginId : requiredPluginIds) {
            IdeaPluginDescriptor result2 = (IdeaPluginDescriptor)((Object)ContainerUtil.find(allPlugins, d -> pluginId.equals(d.getPluginId())));
            if (result2 == null && PluginManagerCore.isModuleDependency(pluginId) && (result2 = (IdeaPluginDescriptor)((Object)ContainerUtil.find(allPlugins, d -> {
                if (d instanceof IdeaPluginDescriptorImpl) {
                    return ((IdeaPluginDescriptorImpl)d).getModules().contains(pluginId);
                }
                return false;
            }))) != null) {
                this.getEnabledMap().put(pluginId, Boolean.TRUE);
            }
            if (result2 == null) continue;
            requiredPlugins.add(result2);
        }
        if (!requiredPlugins.isEmpty()) {
            this.enablePlugins(requiredPlugins);
        }
    }

    @Override
    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, boolean value2) {
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(43);
        }
        PluginId pluginId = descriptor2.getPluginId();
        this.myErrorPluginsToDisable.remove(pluginId);
        if (value2 || descriptor2.isEnabled()) {
            return;
        }
        if (PluginManagerCore.isIncompatible(descriptor2) || this.hasProblematicDependencies(pluginId)) {
            this.myErrorPluginsToDisable.add(pluginId);
        }
    }

    private void runInvalidFixCallback() {
        if (this.myInvalidFixCallback != null) {
            ApplicationManager.getApplication().invokeLater(this.myInvalidFixCallback, ModalityState.any());
        }
    }

    public void setInvalidFixCallback(@Nullable Runnable invalidFixCallback) {
        this.myInvalidFixCallback = invalidFixCallback;
    }

    private void updateAfterEnableDisable() {
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateEnabledState();
        }
        for (PluginDetailsPageComponent detailPanel : this.myDetailPanels) {
            detailPanel.updateEnabledState();
        }
        for (PluginsGroup group : this.myEnabledGroups) {
            group.titleWithEnabled(this);
        }
    }

    public void runRestartButton(@NotNull Component component2) {
        if (component2 == null) {
            MyPluginModel.$$$reportNull$$$0(44);
        }
        if (PluginManagerConfigurable.showRestartDialog() == 0) {
            this.needRestart = true;
            this.createShutdownCallback = false;
            DialogWrapper settings = DialogWrapper.findInstance(component2);
            assert (settings instanceof SettingsDialog) : settings;
            ((SettingsDialog)settings).applyAndClose(false);
            ApplicationManager.getApplication().exit(true, false, true);
        }
    }

    static boolean showUninstallDialog(@NotNull Component uiParent, @NotNull List<? extends ListPluginComponent> selection) {
        int size;
        if (uiParent == null) {
            MyPluginModel.$$$reportNull$$$0(45);
        }
        if (selection == null) {
            MyPluginModel.$$$reportNull$$$0(46);
        }
        return MyPluginModel.showUninstallDialog(uiParent, (size = selection.size()) == 1 ? selection.get((int)0).myPlugin.getName() : null, size);
    }

    static boolean showUninstallDialog(@NotNull Component uiParent, @Nullable String singleName, int count) {
        if (uiParent == null) {
            MyPluginModel.$$$reportNull$$$0(47);
        }
        String message = singleName == null ? IdeBundle.message("prompt.uninstall.several.plugins", count) : IdeBundle.message("prompt.uninstall.plugin", singleName);
        return Messages.showYesNoDialog(uiParent, message, IdeBundle.message("title.plugin.uninstall", new Object[0]), Messages.getQuestionIcon()) == 0;
    }

    void uninstallAndUpdateUi(@NotNull Component uiParent, @NotNull IdeaPluginDescriptor descriptor2) {
        List<IdeaPluginDescriptor> deps;
        if (uiParent == null) {
            MyPluginModel.$$$reportNull$$$0(48);
        }
        if (descriptor2 == null) {
            MyPluginModel.$$$reportNull$$$0(49);
        }
        if (!(deps = this.dependent(descriptor2)).isEmpty()) {
            String title;
            String listOfDeps = StringUtil.join(deps, plugin -> "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + plugin.getName(), "<br>");
            String beginS = deps.size() == 1 ? "" : "s";
            String middleS = deps.size() == 1 ? "s" : "";
            String message = "<html>Following plugin" + beginS + " depend" + middleS + " on " + descriptor2.getName() + ". Continue to remove?<br>" + listOfDeps + "</html>";
            if (Messages.showYesNoDialog(uiParent, message, title = IdeBundle.message("title.plugin.uninstall", new Object[0]), Messages.getQuestionIcon()) != 0) {
                return;
            }
        }
        boolean needRestartForUninstall = this.performUninstall((IdeaPluginDescriptorImpl)descriptor2);
        this.needRestart |= descriptor2.isEnabled() && needRestartForUninstall;
        this.myInstallsRequiringRestart |= needRestartForUninstall;
        List<ListPluginComponent> listComponents = this.myInstalledPluginComponentMap.get(descriptor2.getPluginId());
        if (listComponents != null) {
            for (ListPluginComponent listComponent : listComponents) {
                listComponent.updateAfterUninstall(needRestartForUninstall);
            }
        }
        for (ListPluginComponent component2 : this.myInstalledPluginComponents) {
            component2.updateErrors();
        }
        for (PluginDetailsPageComponent panel2 : this.myDetailPanels) {
            if (panel2.myPlugin != descriptor2) continue;
            panel2.updateButtons();
        }
    }

    private boolean performUninstall(IdeaPluginDescriptorImpl descriptorImpl) {
        boolean needRestartForUninstall = true;
        try {
            descriptorImpl.setDeleted(true);
            IdeaPluginDescriptorImpl fullDescriptor = PluginEnabler.tryLoadFullDescriptor(descriptorImpl);
            LOG.assertTrue(fullDescriptor != null);
            needRestartForUninstall = PluginInstaller.prepareToUninstall(fullDescriptor);
            InstalledPluginsState.getInstance().onPluginUninstall(descriptorImpl, needRestartForUninstall);
            if (!needRestartForUninstall) {
                this.myDynamicPluginsToUninstall.add(fullDescriptor);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return needRestartForUninstall;
    }

    @Nullable
    public static IdeaPluginDescriptor findPlugin(@NotNull PluginId id2) {
        IdeaPluginDescriptor descriptor2;
        IdeaPluginDescriptor plugin;
        if (id2 == null) {
            MyPluginModel.$$$reportNull$$$0(50);
        }
        if ((plugin = PluginManagerCore.getPlugin(id2)) == null && PluginManagerCore.isModuleDependency(id2) && (descriptor2 = PluginManagerCore.findPluginByModuleDependency(id2)) != null) {
            return descriptor2;
        }
        return plugin;
    }

    public boolean hasProblematicDependencies(PluginId pluginId) {
        Set<PluginId> ids = this.getDependentToRequiredListMap().get(pluginId);
        if (ContainerUtil.isEmpty(ids)) {
            return false;
        }
        for (PluginId id2 : ids) {
            IdeaPluginDescriptor plugin = MyPluginModel.findPlugin(id2);
            if (plugin == null || this.isEnabled(plugin)) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            MyPluginModel.$$$reportNull$$$0(51);
        }
        return this.getErrorMessage(plugin, null) != null;
    }

    @Nullable
    public String getErrorMessage(@NotNull IdeaPluginDescriptor pluginDescriptor, @Nullable Ref<? super String> enableAction) {
        if (pluginDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(52);
        }
        String message = PluginManagerCore.getLoadingError(pluginDescriptor);
        PluginId disabledDependency = PluginManagerCore.getFirstDisabledDependency(pluginDescriptor);
        if (disabledDependency != null) {
            Set<PluginId> requiredPlugins = MyPluginModel.filterRequiredPlugins(this.getRequiredPlugins(pluginDescriptor.getPluginId()));
            if (!ContainerUtil.isEmpty(requiredPlugins)) {
                boolean[] enable = new boolean[]{true};
                String deps = StringUtil.join(requiredPlugins, id2 -> {
                    IdeaPluginDescriptor plugin = MyPluginModel.findPlugin(id2);
                    if (enable[0] && (plugin == null || PluginManagerCore.isIncompatible(plugin))) {
                        enable[0] = false;
                    }
                    return StringUtil.wrapWithDoubleQuote(plugin != null ? plugin.getName() : id2.getIdString());
                }, ", ");
                int size = requiredPlugins.size();
                message = IdeBundle.message("new.plugin.manager.incompatible.deps.tooltip", size, deps);
                if (enable[0] && enableAction != null) {
                    enableAction.set(IdeBundle.message("new.plugin.manager.incompatible.deps.action", size));
                }
            } else {
                message = null;
            }
        }
        return message;
    }

    @Nullable
    private static Set<PluginId> filterRequiredPlugins(@Nullable Set<PluginId> requiredPlugins) {
        if (ContainerUtil.isEmpty(requiredPlugins)) {
            return requiredPlugins;
        }
        return requiredPlugins.stream().filter(id2 -> {
            IdeaPluginDescriptor plugin = MyPluginModel.findPlugin(id2);
            return plugin == null || !plugin.isEnabled();
        }).collect(Collectors.toSet());
    }

    protected List<IdeaPluginDescriptor> getAllRepoPlugins() {
        try {
            List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadCachedPlugins();
            if (list2 != null) {
                return list2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<IdeaPluginDescriptor> dependent(@NotNull IdeaPluginDescriptor rootDescriptor) {
        if (rootDescriptor == null) {
            MyPluginModel.$$$reportNull$$$0(53);
        }
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        PluginId rootId = rootDescriptor.getPluginId();
        ArrayList<IdeaPluginDescriptor> result2 = new ArrayList<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor plugin : this.getAllPlugins()) {
            PluginId pluginId = plugin.getPluginId();
            if (pluginId == rootId || appInfo.isEssentialPlugin(pluginId) || !plugin.isEnabled() || plugin.isImplementationDetail() || plugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)plugin).isDeleted()) continue;
            PluginManagerCore.processAllDependencies(plugin, false, descriptor2 -> {
                if (descriptor2.getPluginId() == rootId) {
                    result2.add(plugin);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        ArrayList<IdeaPluginDescriptor> arrayList = result2;
        if (arrayList == null) {
            MyPluginModel.$$$reportNull$$$0(54);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 14: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 39: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 14: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 39: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callbackData";
                break;
            }
            case 1: 
            case 2: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topController";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: 
            case 14: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 39: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 29: 
            case 35: 
            case 42: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToInstall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allPlugins";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaded";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installing";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendors";
                break;
            }
            case 37: 
            case 38: 
            case 40: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 45: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiParent";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/MyPluginModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallingPlugins";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareToInstall";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "finishInstall";
                break;
            }
            case 30: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getVendors";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledDescriptors";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledTitle";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "dependent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pluginInstalledFromDisk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTopController";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setPluginUpdatesService";
                break;
            }
            case 5: 
            case 14: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 39: 
            case 54: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInstallingOrUpdate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installOrUpdatePlugin";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "installPlugin";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "finishInstall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearInstallingProgress";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addProgress";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeProgress";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addEnabledGroup";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setDownloadedGroup";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateGroup";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addDetailPanel";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendOrUpdateDescriptor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getVendors";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isVendor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledTitle";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "changeEnableDisable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "enableRequiredPlugins";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "handleBeforeChangeEnableState";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "runRestartButton";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "showUninstallDialog";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "uninstallAndUpdateUi";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findPlugin";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasErrors";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "dependent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 14: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 39: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

