/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginRepositoryRequests;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginPriceService {
    private static final Logger LOG = Logger.getInstance(PluginPriceService.class);
    private static final DecimalFormat FORMAT = new DecimalFormat("###.#");
    private static final Map<String, Object> myPriceTable = new HashMap<String, Object>();
    private static boolean myPrepared;
    private static boolean myPreparing;

    public static void getPrice(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Consumer<String> callback2, @NotNull Consumer<String> asyncCallback) {
        if (descriptor2 == null) {
            PluginPriceService.$$$reportNull$$$0(0);
        }
        if (callback2 == null) {
            PluginPriceService.$$$reportNull$$$0(1);
        }
        if (asyncCallback == null) {
            PluginPriceService.$$$reportNull$$$0(2);
        }
        PluginPriceService.checkAccess();
        String code = descriptor2.getProductCode();
        if (myPrepared) {
            Object value2 = myPriceTable.get(code);
            if (value2 instanceof String) {
                callback2.consume((String)value2);
            }
        } else {
            myPriceTable.put(code, asyncCallback);
            if (!myPreparing) {
                myPreparing = true;
                PluginPriceService.loadPrice();
            }
        }
    }

    public static void cancel() {
        PluginPriceService.checkAccess();
        PluginPriceService.clear();
    }

    private static void clear() {
        Iterator<Map.Entry<String, Object>> I = myPriceTable.entrySet().iterator();
        while (I.hasNext()) {
            Map.Entry<String, Object> entry = I.next();
            if (!(entry.getValue() instanceof Consumer)) continue;
            I.remove();
        }
    }

    private static void loadPrice() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Object priceJson = PluginRepositoryRequests.getPluginPricesJsonObject();
                if (priceJson instanceof Map) {
                    Map<String, String> result2 = PluginPriceService.parsePrices((Map)priceJson);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PluginPriceService.checkAccess();
                        for (Map.Entry entry : result2.entrySet()) {
                            Object callback2 = myPriceTable.put((String)entry.getKey(), entry.getValue());
                            if (!(callback2 instanceof Consumer)) continue;
                            ((Consumer)callback2).consume(entry.getValue());
                        }
                        PluginPriceService.clear();
                        myPrepared = true;
                        myPreparing = false;
                    }, ModalityState.any());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.debug(e);
            }
        });
    }

    @NotNull
    private static Map<String, String> parsePrices(@NotNull Map<String, Object> jsonObject) {
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(3);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        Object plugins2 = jsonObject.get("plugins");
        if (plugins2 instanceof List) {
            String currency = PluginPriceService.parseCurrency(jsonObject);
            for (Map plugin : (List)plugins2) {
                Double price;
                Object code = plugin.get("code");
                if (!(code instanceof String) || (price = PluginPriceService.parsePrice(plugin)) == null) continue;
                result2.put((String)code, currency + FORMAT.format(price));
            }
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            PluginPriceService.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    private static String parseCurrency(@NotNull Map<String, Object> jsonObject) {
        Currency currency;
        Object iso;
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(5);
        }
        if ((iso = jsonObject.get("iso")) instanceof String && (currency = Currency.getInstance((String)iso)) != null) {
            String string = currency.getSymbol(Locale.ENGLISH);
            if (string == null) {
                PluginPriceService.$$$reportNull$$$0(6);
            }
            return string;
        }
        return "";
    }

    @Nullable
    private static Double parsePrice(@NotNull Map<String, Object> plugin) {
        if (plugin == null) {
            PluginPriceService.$$$reportNull$$$0(7);
        }
        double[] personal = PluginPriceService.parsePrice(plugin, "personal");
        double[] commercial = PluginPriceService.parsePrice(plugin, "commercial");
        if (personal == null && commercial == null) {
            return null;
        }
        if (personal == null || commercial == null) {
            for (double value2 : personal == null ? commercial : personal) {
                if (!(value2 > 0.0)) continue;
                return value2;
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                if (!(personal[i] > 0.0) || !(commercial[i] > 0.0)) continue;
                return Math.min(personal[i], commercial[i]);
            }
        }
        return null;
    }

    @Nullable
    private static double[] parsePrice(@NotNull Map<String, Object> jsonObject, @NotNull String key) {
        Object subscription;
        Object value2;
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(8);
        }
        if (key == null) {
            PluginPriceService.$$$reportNull$$$0(9);
        }
        if ((value2 = jsonObject.get(key)) instanceof Map && (subscription = ((Map)value2).get("subscription")) instanceof Map) {
            return new double[]{PluginPriceService.parsePriceValue((Map)subscription, "monthly"), PluginPriceService.parsePriceValue((Map)subscription, "annual")};
        }
        return null;
    }

    private static double parsePriceValue(@NotNull Map<String, Object> jsonObject, @NotNull String key) {
        Object value2;
        if (jsonObject == null) {
            PluginPriceService.$$$reportNull$$$0(10);
        }
        if (key == null) {
            PluginPriceService.$$$reportNull$$$0(11);
        }
        if ((value2 = jsonObject.get(key)) instanceof Double) {
            return (Double)value2;
        }
        if (value2 instanceof String) {
            try {
                return Double.parseDouble((String)value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private static void checkAccess() {
        assert (SwingUtilities.isEventDispatchThread());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncCallback";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginPriceService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginPriceService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePrices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCurrency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrice";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePrices";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseCurrency";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parsePrice";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parsePriceValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

