/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginSearchTextField;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.SearchQueryParser;
import com.intellij.ide.plugins.newui.SearchResultPanel;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginsTab {
    private final Alarm mySearchUpdateAlarm = new Alarm();
    private PluginDetailsPageComponent myDetailsPage;
    private MultiPanel myCardPanel;
    protected PluginSearchTextField mySearchTextField;
    private SearchResultPanel mySearchPanel;
    public final LinkListener<Object> mySearchListener = (__, data2) -> {
        String query;
        if (data2 instanceof String) {
            query = (String)data2;
        } else if (data2 instanceof TagComponent) {
            query = SearchQueryParser.getTagQuery(((TagComponent)data2).getText());
        } else {
            return;
        }
        this.mySearchTextField.setTextIgnoreEvents(query);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.mySearchTextField, true));
        this.mySearchPanel.setEmpty();
        this.showSearchPanel(query);
    };
    private final Consumer<PluginsGroupComponent> mySelectionListener = panel2 -> {
        int key;
        int n = key = this.mySearchPanel.getPanel() == panel2 ? 1 : 0;
        if ((Integer)this.myCardPanel.getKey() != key) {
            return;
        }
        List<ListPluginComponent> selection = panel2.getSelection();
        int size = selection.size();
        this.myDetailsPage.showPlugin(size == 1 ? selection.get(0) : null, size > 1);
    };

    @NotNull
    public JComponent createPanel() {
        this.createSearchTextField(100);
        this.myCardPanel = new MultiPanel(){

            @Override
            public void addNotify() {
                super.addNotify();
                EventHandler.addGlobalAction(PluginsTab.this.mySearchTextField, new CustomShortcutSet(KeyStroke.getKeyStroke("meta alt F")), () -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(PluginsTab.this.mySearchTextField, true)));
            }

            @Override
            protected JComponent create(Integer key) {
                if (key == 0) {
                    return PluginsTab.this.createPluginsPanel(PluginsTab.this.mySelectionListener);
                }
                if (key == 1) {
                    return PluginsTab.this.mySearchPanel.createVScrollPane();
                }
                return super.create(key);
            }
        };
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)this.mySearchTextField, "North");
        listPanel.add(this.myCardPanel);
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.45f){

            @Override
            protected Divider createDivider() {
                Divider divider = super.createDivider();
                divider.setBackground(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR);
                return divider;
            }
        };
        splitter.setFirstComponent(listPanel);
        this.myDetailsPage = this.createDetailsPanel(this.mySearchListener);
        splitter.setSecondComponent(this.myDetailsPage);
        this.mySearchPanel = this.createSearchPanel(this.mySelectionListener);
        this.myCardPanel.select(0, true);
        OnePixelSplitter onePixelSplitter = splitter;
        if (onePixelSplitter == null) {
            PluginsTab.$$$reportNull$$$0(0);
        }
        return onePixelSplitter;
    }

    protected void createSearchTextField(final int flyDelay) {
        this.mySearchTextField = new PluginSearchTextField(){

            @Override
            protected boolean preprocessEventForTextField(KeyEvent event) {
                int keyCode = event.getKeyCode();
                int id2 = event.getID();
                if (keyCode == 10 || event.getKeyChar() == '\n') {
                    String text2;
                    if (!(id2 != 401 || ((PluginsTab)PluginsTab.this).mySearchPanel.controller != null && ((PluginsTab)PluginsTab.this).mySearchPanel.controller.handleEnter(event) || (text2 = this.getText()).isEmpty())) {
                        if (((PluginsTab)PluginsTab.this).mySearchPanel.controller != null) {
                            ((PluginsTab)PluginsTab.this).mySearchPanel.controller.hidePopup();
                        }
                        PluginsTab.this.showSearchPanel(text2);
                    }
                    return true;
                }
                if ((keyCode == 40 || keyCode == 38) && id2 == 401 && ((PluginsTab)PluginsTab.this).mySearchPanel.controller != null && ((PluginsTab)PluginsTab.this).mySearchPanel.controller.handleUpDown(event)) {
                    return true;
                }
                return super.preprocessEventForTextField(event);
            }

            @Override
            protected boolean toClearTextOnEscape() {
                new AnAction(){
                    {
                        this.setEnabledInModalContext(true);
                    }

                    @Override
                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        e.getPresentation().setEnabled(!this.getText().isEmpty());
                    }

                    @Override
                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (((PluginsTab)PluginsTab.this).mySearchPanel.controller != null && ((PluginsTab)PluginsTab.this).mySearchPanel.controller.isPopupShow()) {
                            ((PluginsTab)PluginsTab.this).mySearchPanel.controller.hidePopup();
                        } else {
                            this.setText("");
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsTab$3$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this);
                return false;
            }

            @Override
            protected void onFieldCleared() {
                PluginsTab.this.hideSearchPanel();
            }

            @Override
            protected void showCompletionPopup() {
                if (((PluginsTab)PluginsTab.this).mySearchPanel.controller != null && !((PluginsTab)PluginsTab.this).mySearchPanel.controller.isPopupShow()) {
                    PluginsTab.this.showSearchPopup();
                }
            }
        };
        this.mySearchTextField.getTextEditor().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!PluginsTab.this.mySearchTextField.isSkipDocumentEvents()) {
                    PluginsTab.this.mySearchUpdateAlarm.cancelAllRequests();
                    PluginsTab.this.mySearchUpdateAlarm.addRequest(this::searchOnTheFly, flyDelay, ModalityState.stateForComponent(PluginsTab.this.mySearchTextField));
                }
            }

            private void searchOnTheFly() {
                String text2 = PluginsTab.this.mySearchTextField.getText();
                if (StringUtil.isEmptyOrSpaces(text2)) {
                    PluginsTab.this.hideSearchPanel();
                } else if (((PluginsTab)PluginsTab.this).mySearchPanel.controller == null) {
                    PluginsTab.this.showSearchPanel(text2);
                } else {
                    ((PluginsTab)PluginsTab.this).mySearchPanel.controller.handleShowPopup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/PluginsTab$4", "textChanged"));
            }
        });
        this.mySearchTextField.setBorder(JBUI.Borders.customLine(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR));
        JBTextField editor = this.mySearchTextField.getTextEditor();
        editor.putClientProperty("JTextField.Search.Gap", JBUIScale.scale(6));
        editor.putClientProperty("JTextField.Search.GapEmptyText", JBUIScale.scale(-1));
        editor.putClientProperty("StatusVisibleFunction", field -> field.getText().isEmpty());
        editor.setBorder(JBUI.Borders.empty(0, 6));
        editor.setOpaque(true);
        editor.setBackground(PluginManagerConfigurable.SEARCH_BG_COLOR);
        String text2 = IdeBundle.message("plugin.manager.options.command", new Object[0]);
        StatusText emptyText = this.mySearchTextField.getTextEditor().getEmptyText();
        emptyText.appendText(text2, new SimpleTextAttributes(0, ListPluginComponent.GRAY_COLOR));
    }

    @NotNull
    protected abstract PluginDetailsPageComponent createDetailsPanel(@NotNull LinkListener<Object> var1);

    @NotNull
    protected abstract JComponent createPluginsPanel(@NotNull Consumer<? super PluginsGroupComponent> var1);

    protected abstract void updateMainSelection(@NotNull Consumer<? super PluginsGroupComponent> var1);

    @NotNull
    protected abstract SearchResultPanel createSearchPanel(@NotNull Consumer<? super PluginsGroupComponent> var1);

    @Nullable
    public String getSearchQuery() {
        if (this.mySearchPanel == null || this.mySearchPanel.isEmpty()) {
            return null;
        }
        String query = this.mySearchPanel.getQuery();
        return query.isEmpty() ? null : query;
    }

    public void setSearchQuery(@Nullable String query) {
        this.mySearchTextField.setTextIgnoreEvents(query);
        this.mySearchTextField.requestFocus();
        if (query == null) {
            this.hideSearchPanel();
        } else {
            this.showSearchPanel(query);
        }
    }

    public void showSearchPanel(@NotNull String query) {
        if (query == null) {
            PluginsTab.$$$reportNull$$$0(1);
        }
        if (this.mySearchPanel.isEmpty()) {
            this.myCardPanel.select(1, true);
            this.myDetailsPage.showPlugin(null, false);
        }
        this.mySearchPanel.setQuery(query);
        this.mySearchTextField.addCurrentTextToHistory();
    }

    public void hideSearchPanel() {
        if (!this.mySearchPanel.isEmpty()) {
            this.myCardPanel.select(0, true);
            this.mySearchPanel.setQuery("");
            this.updateMainSelection(this.mySelectionListener);
        }
        if (this.mySearchPanel.controller != null) {
            this.mySearchPanel.controller.hidePopup();
        }
    }

    private void showSearchPopup() {
        if (this.mySearchPanel.controller != null) {
            if (StringUtil.isEmptyOrSpaces(this.mySearchTextField.getText())) {
                this.mySearchPanel.controller.showAttributesPopup(null, 0);
            } else {
                this.mySearchPanel.controller.handleShowPopup();
            }
        }
    }

    public void clearSearchPanel(@NotNull String query) {
        if (query == null) {
            PluginsTab.$$$reportNull$$$0(2);
        }
        this.hideSearchPanel();
        this.mySearchTextField.setTextIgnoreEvents(query);
    }

    public void dispose() {
        Disposer.dispose(this.mySearchUpdateAlarm);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginsTab";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsTab";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showSearchPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearSearchPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

