/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ImportModuleFromImlFileAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ImportModuleFromImlFileAction.class);

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleFromImlFileAction.$$$reportNull$$$0(0);
        }
        VirtualFile[] files2 = e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = ImportModuleFromImlFileAction.getEventProject(e);
        if (files2 == null || project2 == null) {
            return;
        }
        try {
            ModifiableModuleModel model = ModuleManager.getInstance(project2).getModifiableModel();
            for (VirtualFile file2 : files2) {
                model.loadModule(file2.getPath());
            }
            WriteAction.run(() -> model.commit());
        }
        catch (Exception ex) {
            LOG.info(ex);
            Messages.showErrorDialog(project2, "Cannot import module: " + ex.getMessage(), CommonBundle.getErrorTitle());
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleFromImlFileAction.$$$reportNull$$$0(1);
        }
        List<VirtualFile> modules = ImportModuleFromImlFileAction.getModuleNames(e);
        Presentation presentation = e.getPresentation();
        boolean visible = !modules.isEmpty();
        presentation.setEnabledAndVisible(visible);
        String text2 = modules.size() > 1 ? "Import " + modules.size() + " Modules" : (modules.size() == 1 ? "Import '" + modules.get(0).getNameWithoutExtension() + "' Module" : this.getTemplatePresentation().getText());
        presentation.setText(text2);
    }

    private static List<VirtualFile> getModuleNames(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportModuleFromImlFileAction.$$$reportNull$$$0(2);
        }
        VirtualFile[] files2 = e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Project project2 = ImportModuleFromImlFileAction.getEventProject(e);
        if (project2 == null || files2 == null || files2.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> modulesFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : files2) {
            if (!FileTypeRegistry.getInstance().isFileOfType(file2, StdFileTypes.IDEA_MODULE)) {
                return Collections.emptyList();
            }
            modulesFiles.add(file2);
        }
        ModuleManager moduleManager = ModuleManager.getInstance(project2);
        for (Module module2 : moduleManager.getModules()) {
            modulesFiles.remove(module2.getModuleFile());
        }
        return modulesFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/projectView/actions/ImportModuleFromImlFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

