/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModulesToGroupAction
extends AnAction {
    protected final ModuleGroup myModuleGroup;

    public MoveModulesToGroupAction(ModuleGroup moduleGroup, String title) {
        super(title);
        this.myModuleGroup = moduleGroup;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Module[] modules = LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        e.getPresentation().setEnabledAndVisible(modules != null);
        if (modules != null) {
            String description = IdeBundle.message("message.move.modules.to.group", MoveModulesToGroupAction.whatToMove(modules), this.myModuleGroup.presentableText());
            presentation.setDescription(description);
        }
    }

    protected static String whatToMove(Module @NotNull [] modules) {
        if (modules == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(1);
        }
        return modules.length == 1 ? IdeBundle.message("message.module", modules[0].getName()) : IdeBundle.message("message.modules", new Object[0]);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(2);
        }
        Module[] modules = e.getRequiredData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        MoveModulesToGroupAction.doMove(modules, this.myModuleGroup, e.getDataContext());
    }

    public static void doMove(Module @NotNull [] modules, ModuleGroup group, @Nullable DataContext dataContext) {
        if (modules == null) {
            MoveModulesToGroupAction.$$$reportNull$$$0(3);
        }
        Project project2 = modules[0].getProject();
        for (Module module2 : modules) {
            ModifiableModuleModel model;
            ModifiableModuleModel modifiableModuleModel = model = dataContext != null ? LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(dataContext) : null;
            if (model != null) {
                model.setModuleGroupPath(module2, group == null ? null : group.getGroupPath());
                continue;
            }
            ModuleManagerImpl.getInstanceImpl(project2).setModuleGroupPath(module2, group == null ? null : group.getGroupPath());
        }
        AbstractProjectViewPane pane2 = ProjectView.getInstance(project2).getCurrentProjectViewPane();
        if (pane2 != null) {
            pane2.updateFromRoot(true);
        }
        if (!ProjectSettingsService.getInstance(project2).processModulesMoved(modules, group) && pane2 != null) {
            if (group != null) {
                pane2.selectModuleGroup(group, true);
            } else {
                pane2.selectModule(modules[0], true);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MoveModulesToGroupAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "whatToMove";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

