/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MoveModulesToSubGroupAction
extends MoveModulesToGroupAction {
    public MoveModulesToSubGroupAction(ModuleGroup moduleGroup) {
        super(moduleGroup, moduleGroup == null ? IdeBundle.message("action.move.module.new.top.level.group", new Object[0]) : IdeBundle.message("action.move.module.to.new.sub.group", new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveModulesToSubGroupAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY) != null);
        String description = IdeBundle.message("action.description.create.new.module.group", new Object[0]);
        presentation.setDescription(description);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        List<String> newGroup;
        if (e == null) {
            MoveModulesToSubGroupAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Module[] modules = e.getRequiredData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        if (this.myModuleGroup != null) {
            String message = IdeBundle.message("prompt.specify.name.of.module.subgroup", this.myModuleGroup.presentableText(), MoveModulesToSubGroupAction.whatToMove(modules));
            String subgroup = Messages.showInputDialog(message, IdeBundle.message("title.module.sub.group", new Object[0]), Messages.getQuestionIcon());
            if (subgroup == null || "".equals(subgroup.trim())) {
                return;
            }
            newGroup = ContainerUtil.append(this.myModuleGroup.getGroupPathList(), subgroup);
        } else {
            String message = IdeBundle.message("prompt.specify.module.group.name", MoveModulesToSubGroupAction.whatToMove(modules));
            String group = Messages.showInputDialog(message, IdeBundle.message("title.module.group", new Object[0]), Messages.getQuestionIcon());
            if (group == null || "".equals(group.trim())) {
                return;
            }
            newGroup = Collections.singletonList(group);
        }
        MoveModulesToSubGroupAction.doMove(modules, new ModuleGroup(newGroup), dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/projectView/actions/MoveModulesToSubGroupAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

