/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.RootsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.impl.AsyncProjectViewSupport;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewDropTarget;
import com.intellij.ide.projectView.impl.ProjectViewFileVisitor;
import com.intellij.ide.projectView.impl.ProjectViewNodeVisitor;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class AbstractProjectViewPane
implements DataProvider,
Disposable,
BusyObject {
    private static final Logger LOG = Logger.getInstance(AbstractProjectViewPane.class);
    public static final ExtensionPointName<AbstractProjectViewPane> EP_NAME = ExtensionPointName.create("com.intellij.projectViewPane");
    @NotNull
    protected final Project myProject;
    protected DnDAwareTree myTree;
    protected AbstractTreeStructure myTreeStructure;
    private AbstractTreeBuilder myTreeBuilder;
    private final Map<String, TreeState> myReadTreeState;
    private final AtomicBoolean myTreeStateRestored;
    private String mySubId;
    @NonNls
    private static final String ELEMENT_SUB_PANE = "subPane";
    @NonNls
    private static final String ATTRIBUTE_SUB_ID = "subId";
    private DnDTarget myDropTarget;
    private DnDSource myDragSource;
    private DnDManager myDndManager;

    private void queueUpdateByProblem() {
        if (Registry.is("projectView.showHierarchyErrors") && this.myTreeBuilder != null) {
            this.myTreeBuilder.queueUpdate();
        }
    }

    protected AbstractProjectViewPane(@NotNull Project project2) {
        if (project2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(0);
        }
        this.myReadTreeState = new HashMap<String, TreeState>();
        this.myTreeStateRestored = new AtomicBoolean();
        this.myProject = project2;
        ProblemListener problemListener = new ProblemListener(){

            @Override
            public void problemsAppeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            @Override
            public void problemsChanged(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            @Override
            public void problemsDisappeared(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                AbstractProjectViewPane.this.queueUpdateByProblem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsAppeared";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "problemsDisappeared";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        project2.getMessageBus().connect(this).subscribe(ProblemListener.TOPIC, problemListener);
        Disposer.register(project2, this);
        TreeStructureProvider.EP.addExtensionPointListener((AreaInstance)project2, () -> this.updateFromRoot(true).waitFor(5000L), (Disposable)this);
    }

    @Deprecated
    protected final void fireTreeChangeListener() {
    }

    @NotNull
    public abstract String getTitle();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract String getId();

    public boolean isDefaultPane(@NotNull Project project2) {
        if (project2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Nullable
    public final String getSubId() {
        return this.mySubId;
    }

    public final void setSubId(@Nullable String subId) {
        if (Comparing.strEqual(this.mySubId, subId)) {
            return;
        }
        this.saveExpandedPaths();
        this.mySubId = subId;
        this.onSubIdChange();
    }

    protected void onSubIdChange() {
    }

    public boolean isInitiallyVisible() {
        return true;
    }

    public boolean supportsManualOrder() {
        return false;
    }

    @NotNull
    protected String getManualOrderOptionText() {
        String string = IdeBundle.message("action.manual.order", new Object[0]);
        if (string == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String @NotNull [] getSubIds() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public String getPresentableSubIdName(@NotNull String subId) {
        if (subId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(4);
        }
        throw new IllegalStateException("should not call");
    }

    @NotNull
    public Icon getPresentableSubIdIcon(@NotNull String subId) {
        if (subId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(5);
        }
        Icon icon2 = this.getIcon();
        if (icon2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(6);
        }
        return icon2;
    }

    @NotNull
    public abstract JComponent createComponent();

    public JComponent getComponentToFocus() {
        return this.myTree;
    }

    public void expand(Object @Nullable [] path2, boolean requestFocus) {
        DefaultMutableTreeNode node;
        if (this.getTreeBuilder() == null || path2 == null) {
            return;
        }
        AbstractTreeUi ui = this.getTreeBuilder().getUi();
        if (ui != null) {
            ui.buildNodeForPath(path2);
        }
        DefaultMutableTreeNode defaultMutableTreeNode = node = ui == null ? null : ui.getNodeForPath(path2);
        if (node == null) {
            return;
        }
        TreePath treePath = new TreePath(node.getPath());
        this.myTree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myTree, true));
        }
        TreeUtil.selectPath(this.myTree, treePath);
    }

    @Override
    public void dispose() {
        if (this.myDndManager != null) {
            if (this.myDropTarget != null) {
                this.myDndManager.unregisterTarget(this.myDropTarget, this.myTree);
                this.myDropTarget = null;
            }
            if (this.myDragSource != null) {
                this.myDndManager.unregisterSource(this.myDragSource, this.myTree);
                this.myDragSource = null;
            }
            this.myDndManager = null;
        }
        this.setTreeBuilder(null);
        this.myTree = null;
        this.myTreeStructure = null;
    }

    @NotNull
    public abstract ActionCallback updateFromRoot(boolean var1);

    public void updateFrom(Object element2, boolean forceResort, boolean updateStructure) {
        AsyncProjectViewSupport support;
        AbstractTreeBuilder builder2 = this.getTreeBuilder();
        if (builder2 != null) {
            builder2.queueUpdateFrom(element2, forceResort, updateStructure);
        } else if (element2 instanceof PsiElement && (support = this.getAsyncSupport()) != null) {
            support.updateByElement((PsiElement)element2, updateStructure);
        }
    }

    public abstract void select(Object var1, VirtualFile var2, boolean var3);

    public void selectModule(@NotNull Module module2, boolean requestFocus) {
        if (module2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(7);
        }
        this.doSelectModuleOrGroup(module2, requestFocus);
    }

    private void doSelectModuleOrGroup(@NotNull Object toSelect2, boolean requestFocus) {
        if (toSelect2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(8);
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance(this.myProject);
        Runnable runnable2 = () -> {
            BaseProjectTreeBuilder builder2;
            ProjectView projectView;
            if (requestFocus && (projectView = ProjectView.getInstance(this.myProject)) != null) {
                projectView.changeView(this.getId(), this.getSubId());
            }
            if ((builder2 = (BaseProjectTreeBuilder)this.getTreeBuilder()) != null) {
                builder2.selectInWidth(toSelect2, requestFocus, node -> node instanceof AbstractModuleNode || node instanceof ModuleGroupNode || node instanceof AbstractProjectNode);
            }
        };
        if (requestFocus) {
            windowManager.getToolWindow("Project").activate(runnable2);
        } else {
            runnable2.run();
        }
    }

    public void selectModuleGroup(@NotNull ModuleGroup moduleGroup, boolean requestFocus) {
        if (moduleGroup == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(9);
        }
        this.doSelectModuleOrGroup(moduleGroup, requestFocus);
    }

    public TreePath[] getSelectionPaths() {
        return this.myTree == null ? null : this.myTree.getSelectionPaths();
    }

    public void addToolbarActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(10);
        }
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    protected ToggleAction createFlattenModulesAction(@NotNull BooleanSupplier isApplicable) {
        if (isApplicable == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(11);
        }
        return new FlattenModulesToggleAction(this.myProject, () -> isApplicable.getAsBoolean() && ProjectView.getInstance(this.myProject).isShowModules(this.getId()), () -> ProjectView.getInstance(this.myProject).isFlattenModules(this.getId()), value2 -> ProjectView.getInstance(this.myProject).setFlattenModules(this.getId(), (boolean)value2));
    }

    @NotNull
    protected <T extends NodeDescriptor<?>> List<T> getSelectedNodes(@NotNull Class<T> nodeClass) {
        TreePath[] paths;
        if (nodeClass == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(12);
        }
        if ((paths = this.getSelectionPaths()) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(13);
            }
            return list2;
        }
        ArrayList<NodeDescriptor> result2 = new ArrayList<NodeDescriptor>();
        for (TreePath path2 : paths) {
            NodeDescriptor userObject = (NodeDescriptor)TreeUtil.getLastUserObject(nodeClass, path2);
            if (userObject == null) continue;
            result2.add(userObject);
        }
        ArrayList<NodeDescriptor> arrayList = result2;
        if (arrayList == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public boolean isAutoScrollEnabledFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(15);
        }
        return true;
    }

    @Override
    public Object getData(@NotNull String dataId) {
        List<AbstractTreeNode<?>> nodes;
        Object data2;
        if (dataId == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(16);
        }
        if (this.myTreeStructure instanceof AbstractTreeStructureBase && (data2 = ((AbstractTreeStructureBase)this.myTreeStructure).getDataFromProviders(nodes = this.getSelectedNodes(AbstractTreeNode.class), dataId)) != null) {
            return data2;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
            for (TreePath path2 : paths) {
                Object node = path2.getLastPathComponent();
                Object userObject = TreeUtil.getUserObject(node);
                if (userObject instanceof Navigatable) {
                    navigatables.add((Navigatable)userObject);
                    continue;
                }
                if (!(node instanceof Navigatable)) continue;
                navigatables.add((Navigatable)node);
            }
            return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
        }
        return null;
    }

    public abstract int getWeight();

    @NotNull
    public abstract SelectInTarget createSelectInTarget();

    public final TreePath getSelectedPath() {
        return this.myTree == null ? null : TreeUtil.getSelectedPathIfOne(this.myTree);
    }

    public final NodeDescriptor getSelectedDescriptor() {
        return TreeUtil.getLastUserObject(NodeDescriptor.class, this.getSelectedPath());
    }

    @Deprecated
    public final DefaultMutableTreeNode getSelectedNode() {
        TreePath path2 = this.getSelectedPath();
        return path2 == null ? null : ObjectUtils.tryCast(path2.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    public final Object getSelectedElement() {
        Object[] elements2 = this.getSelectedElements();
        return elements2.length == 1 ? elements2[0] : null;
    }

    public final PsiElement @NotNull [] getSelectedPSIElements() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(17);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (TreePath path2 : paths) {
            result2.addAll(this.getElementsFromNode(path2.getLastPathComponent()));
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(18);
        }
        return psiElementArray;
    }

    @NotNull
    public List<PsiElement> getElementsFromNode(@Nullable Object node) {
        Object value2 = this.getValueFromNode(node);
        JBIterable<Object> it = value2 instanceof PsiElement || value2 instanceof VirtualFile ? JBIterable.of(value2) : (value2 instanceof Object[] ? JBIterable.of((Object[])value2) : (value2 instanceof Iterable ? JBIterable.from((Iterable)value2) : JBIterable.of(TreeUtil.getUserObject(node))));
        List<PsiElement> list2 = it.flatten(o -> o instanceof RootsProvider ? ((RootsProvider)o).getRoots() : Collections.singleton(o)).map(o -> o instanceof VirtualFile ? PsiUtilCore.findFileSystemItem(this.myProject, (VirtualFile)o) : o).filter(PsiElement.class).filter(PsiElement::isValid).toList();
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @Deprecated
    @Nullable
    public PsiElement getPSIElementFromNode(@Nullable TreeNode node) {
        return ContainerUtil.getFirstItem(this.getElementsFromNode(node));
    }

    @Nullable
    protected Module getNodeModule(@Nullable Object element2) {
        if (element2 instanceof PsiElement) {
            PsiElement psiElement = (PsiElement)element2;
            return ModuleUtilCore.findModuleForPsiElement(psiElement);
        }
        return null;
    }

    public final Object @NotNull [] getSelectedElements() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(20);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<Object> list2 = new ArrayList<Object>(paths.length);
        for (TreePath path2 : paths) {
            Object lastPathComponent = path2.getLastPathComponent();
            Object element2 = this.getValueFromNode(lastPathComponent);
            if (element2 instanceof Object[]) {
                Collections.addAll(list2, (Object[])element2);
                continue;
            }
            if (element2 == null) continue;
            list2.add(element2);
        }
        Object[] objectArray = ArrayUtil.toObjectArray(list2);
        if (objectArray == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(21);
        }
        return objectArray;
    }

    @Nullable
    public Object getValueFromNode(@Nullable Object node) {
        return AbstractProjectViewPane.extractValueFromNode(node);
    }

    @Deprecated
    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        return this.getValueFromNode(node);
    }

    @Nullable
    public static Object extractValueFromNode(@Nullable Object node) {
        Object userObject = TreeUtil.getUserObject(node);
        Object element2 = null;
        if (userObject instanceof AbstractTreeNode) {
            AbstractTreeNode descriptor2 = (AbstractTreeNode)userObject;
            element2 = descriptor2.getValue();
        } else if (userObject instanceof NodeDescriptor) {
            NodeDescriptor descriptor3 = (NodeDescriptor)userObject;
            element2 = descriptor3.getElement();
            if (element2 instanceof AbstractTreeNode) {
                element2 = ((AbstractTreeNode)element2).getValue();
            }
        } else if (userObject != null) {
            element2 = userObject;
        }
        return element2;
    }

    public AbstractTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public AbstractTreeStructure getTreeStructure() {
        return this.myTreeStructure;
    }

    public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(22);
        }
        List<Element> subPanes = element2.getChildren(ELEMENT_SUB_PANE);
        for (Element subPane : subPanes) {
            String subId = subPane.getAttributeValue(ATTRIBUTE_SUB_ID);
            TreeState treeState = TreeState.createFrom(subPane);
            if (treeState.isEmpty()) continue;
            this.myReadTreeState.put(subId, treeState);
        }
    }

    public void writeExternal(Element element2) {
        this.saveExpandedPaths();
        for (Map.Entry<String, TreeState> entry : this.myReadTreeState.entrySet()) {
            String subId = entry.getKey();
            TreeState treeState = entry.getValue();
            Element subPane = new Element(ELEMENT_SUB_PANE);
            if (subId != null) {
                subPane.setAttribute(ATTRIBUTE_SUB_ID, subId);
            }
            treeState.writeExternal(subPane);
            element2.addContent(subPane);
        }
    }

    protected void saveExpandedPaths() {
        this.myTreeStateRestored.set(false);
        if (this.myTree != null) {
            TreeState treeState = TreeState.createOn(this.myTree);
            if (!treeState.isEmpty()) {
                this.myReadTreeState.put(this.getSubId(), treeState);
            } else {
                this.myReadTreeState.remove(this.getSubId());
            }
        }
    }

    public final void restoreExpandedPaths() {
        if (this.myTree == null || this.myTreeStateRestored.getAndSet(true)) {
            return;
        }
        TreeState treeState = this.myReadTreeState.get(this.getSubId());
        if (treeState != null && !treeState.isEmpty()) {
            treeState.applyTo(this.myTree);
        } else if (this.myTree.isSelectionEmpty()) {
            TreeUtil.promiseSelectFirst(this.myTree);
        }
    }

    @NotNull
    protected Comparator<NodeDescriptor<?>> createComparator() {
        return new GroupByTypeComparator(ProjectView.getInstance(this.myProject), this.getId());
    }

    public void installComparator() {
        this.installComparator(this.getTreeBuilder());
    }

    void installComparator(AbstractTreeBuilder treeBuilder) {
        this.installComparator(treeBuilder, this.createComparator());
    }

    public void installComparator(@NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        if (comparator2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(23);
        }
        this.installComparator(this.getTreeBuilder(), comparator2);
    }

    protected void installComparator(AbstractTreeBuilder builder2, @NotNull Comparator<? super NodeDescriptor<?>> comparator2) {
        if (comparator2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(24);
        }
        if (builder2 != null) {
            builder2.setNodeDescriptorComparator(comparator2);
        }
    }

    public JTree getTree() {
        return this.myTree;
    }

    public PsiDirectory @NotNull [] getSelectedDirectories() {
        ArrayList<PsiDirectory> directories = new ArrayList<PsiDirectory>();
        for (PsiDirectoryNode node : this.getSelectedNodes(PsiDirectoryNode.class)) {
            PsiDirectory directory = (PsiDirectory)node.getValue();
            if (directory == null) continue;
            directories.add(directory);
            Object parentValue = node.getParent().getValue();
            if (!(parentValue instanceof PsiDirectory) || !Registry.is("projectView.choose.directory.on.compacted.middle.packages")) continue;
            while ((directory = directory.getParentDirectory()) != null && !directory.equals(parentValue)) {
                directories.add(directory);
            }
        }
        if (!directories.isEmpty()) {
            PsiDirectory[] psiDirectoryArray = directories.toArray(PsiDirectory.EMPTY_ARRAY);
            if (psiDirectoryArray == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(25);
            }
            return psiDirectoryArray;
        }
        PsiElement[] elements2 = this.getSelectedPSIElements();
        if (elements2.length == 1) {
            PsiElement element2 = elements2[0];
            if (element2 instanceof PsiDirectory) {
                PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{(PsiDirectory)element2};
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(26);
                }
                return psiDirectoryArray;
            }
            if (element2 instanceof PsiDirectoryContainer) {
                PsiDirectory[] psiDirectoryArray = ((PsiDirectoryContainer)element2).getDirectories();
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(27);
                }
                return psiDirectoryArray;
            }
            PsiFile containingFile = element2.getContainingFile();
            if (containingFile != null) {
                PsiDirectory psiDirectory = containingFile.getContainingDirectory();
                if (psiDirectory != null) {
                    PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{psiDirectory};
                    if (psiDirectoryArray == null) {
                        AbstractProjectViewPane.$$$reportNull$$$0(28);
                    }
                    return psiDirectoryArray;
                }
                VirtualFile file2 = containingFile.getVirtualFile();
                if (file2 instanceof VirtualFileWindow) {
                    VirtualFile delegate = ((VirtualFileWindow)((Object)file2)).getDelegate();
                    PsiFile delegatePsiFile = containingFile.getManager().findFile(delegate);
                    if (delegatePsiFile != null && delegatePsiFile.getContainingDirectory() != null) {
                        PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{delegatePsiFile.getContainingDirectory()};
                        if (psiDirectoryArray == null) {
                            AbstractProjectViewPane.$$$reportNull$$$0(29);
                        }
                        return psiDirectoryArray;
                    }
                }
                if (PsiDirectory.EMPTY_ARRAY == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(30);
                }
                return PsiDirectory.EMPTY_ARRAY;
            }
        } else {
            TreePath path2 = this.getSelectedPath();
            if (path2 != null) {
                Object component2 = path2.getLastPathComponent();
                if (component2 instanceof DefaultMutableTreeNode) {
                    PsiDirectory[] psiDirectoryArray = this.getSelectedDirectoriesInAmbiguousCase(((DefaultMutableTreeNode)component2).getUserObject());
                    if (psiDirectoryArray == null) {
                        AbstractProjectViewPane.$$$reportNull$$$0(31);
                    }
                    return psiDirectoryArray;
                }
                PsiDirectory[] psiDirectoryArray = this.getSelectedDirectoriesInAmbiguousCase(component2);
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(32);
                }
                return psiDirectoryArray;
            }
        }
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(33);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    protected PsiDirectory @NotNull [] getSelectedDirectoriesInAmbiguousCase(Object userObject) {
        PsiDirectory directory;
        VirtualFile file2;
        if (userObject instanceof AbstractModuleNode) {
            Module module2 = (Module)((AbstractModuleNode)userObject).getValue();
            if (module2 != null && !module2.isDisposed()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
                VirtualFile[] sourceRoots2 = moduleRootManager.getSourceRoots();
                ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(sourceRoots2.length);
                PsiManager psiManager = PsiManager.getInstance(this.myProject);
                for (VirtualFile sourceRoot : sourceRoots2) {
                    PsiDirectory directory2 = psiManager.findDirectory(sourceRoot);
                    if (directory2 == null) continue;
                    dirs.add(directory2);
                }
                PsiDirectory[] psiDirectoryArray = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
                if (psiDirectoryArray == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(34);
                }
                return psiDirectoryArray;
            }
        } else if (userObject instanceof ProjectViewNode && (file2 = ((ProjectViewNode)userObject).getVirtualFile()) != null && file2.isValid() && file2.isDirectory() && (directory = PsiManager.getInstance(this.myProject).findDirectory(file2)) != null) {
            PsiDirectory[] psiDirectoryArray = new PsiDirectory[]{directory};
            if (psiDirectoryArray == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(35);
            }
            return psiDirectoryArray;
        }
        if (PsiDirectory.EMPTY_ARRAY == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(36);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public static PsiElement @Nullable [] getTransferedPsiElements(@NotNull Transferable transferable) {
        if (transferable == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(37);
        }
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getPsiElements();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TreeNode @Nullable [] getTransferedTreeNodes(@NotNull Transferable transferable) {
        if (transferable == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(38);
        }
        try {
            Object transferData = transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            if (transferData instanceof TransferableWrapper) {
                return ((TransferableWrapper)transferData).getTreeNodes();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new ProjectViewDropTarget(this.myTree, this.myProject){

                @Override
                @Nullable
                protected PsiElement getPsiElement(@NotNull TreePath path2) {
                    if (path2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return ContainerUtil.getFirstItem(AbstractProjectViewPane.this.getElementsFromNode(path2.getLastPathComponent()));
                }

                @Override
                @Nullable
                protected Module getModule(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return AbstractProjectViewPane.this.getNodeModule(element2);
                }

                @Override
                public void cleanUpOnLeave() {
                    AbstractProjectViewPane.this.beforeDnDLeave();
                    super.cleanUpOnLeave();
                }

                @Override
                public boolean update(DnDEvent event) {
                    AbstractProjectViewPane.this.beforeDnDUpdate();
                    return super.update(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getPsiElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getModule";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myDragSource = new MyDragSource();
            this.myDndManager = DnDManager.getInstance();
            this.myDndManager.registerSource(this.myDragSource, this.myTree);
            this.myDndManager.registerTarget(this.myDropTarget, this.myTree);
        }
    }

    protected void beforeDnDUpdate() {
    }

    protected void beforeDnDLeave() {
    }

    public void setTreeBuilder(AbstractTreeBuilder treeBuilder) {
        if (treeBuilder != null) {
            Disposer.register(this, treeBuilder);
        }
        this.myTreeBuilder = treeBuilder;
    }

    @ApiStatus.Internal
    public boolean supportsAbbreviatePackageNames() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsCompactDirectories() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsFlattenModules() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsFoldersAlwaysOnTop() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsHideEmptyMiddlePackages() {
        return true;
    }

    @ApiStatus.Internal
    public boolean supportsShowExcludedFiles() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsShowLibraryContents() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsShowModules() {
        return false;
    }

    @ApiStatus.Internal
    public boolean supportsSortByType() {
        return true;
    }

    private static boolean canDragElements(Object @NotNull [] elements2, @NotNull DataContext dataContext, int dragAction) {
        if (dataContext == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(39);
        }
        if (elements2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(40);
        }
        for (Object element2 : elements2) {
            if (!(element2 instanceof Module)) continue;
            return true;
        }
        return dragAction == 2 && MoveHandler.canMove(dataContext);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(41);
        }
        if (this.myTreeBuilder == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(42);
            }
            return actionCallback;
        }
        if (this.myTreeBuilder.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(43);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.myTreeBuilder.getUi().getReady(requestor);
        if (actionCallback == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(44);
        }
        return actionCallback;
    }

    @Deprecated
    @NotNull
    public Promise<TreePath> promisePathToElement(@NotNull Object element2) {
        AbstractTreeBuilder builder2;
        if (element2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(45);
        }
        if ((builder2 = this.getTreeBuilder()) != null) {
            DefaultMutableTreeNode node = builder2.getNodeForElement(element2);
            if (node == null) {
                Promise promise2 = Promises.rejectedPromise();
                if (promise2 == null) {
                    AbstractProjectViewPane.$$$reportNull$$$0(46);
                }
                return promise2;
            }
            Promise promise3 = Promises.resolvedPromise((Object)new TreePath(node.getPath()));
            if (promise3 == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(47);
            }
            return promise3;
        }
        TreeVisitor visitor = AbstractProjectViewPane.createVisitor(element2);
        if (visitor == null || this.myTree == null) {
            Promise promise4 = Promises.rejectedPromise();
            if (promise4 == null) {
                AbstractProjectViewPane.$$$reportNull$$$0(48);
            }
            return promise4;
        }
        Promise<TreePath> promise5 = TreeUtil.promiseVisit(this.myTree, visitor);
        if (promise5 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(49);
        }
        return promise5;
    }

    @ApiStatus.Internal
    public boolean isVisibleAndSelected(Object element2) {
        JTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        TreePath path2 = TreeUtil.getSelectedPathIfOne(tree);
        if (path2 == null) {
            return false;
        }
        Rectangle bounds2 = tree.getPathBounds(path2);
        if (bounds2 == null) {
            return false;
        }
        Rectangle visible = tree.getVisibleRect();
        if (bounds2.y < visible.y || bounds2.y > visible.y + visible.height - bounds2.height) {
            return false;
        }
        AbstractTreeNode node = TreeUtil.getLastUserObject(AbstractTreeNode.class, path2);
        return node != null && node.canRepresent(element2);
    }

    AsyncProjectViewSupport getAsyncSupport() {
        return null;
    }

    @NotNull
    static List<TreeVisitor> createVisitors(Object ... objects) {
        if (objects == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(50);
        }
        List list2 = StreamEx.of((Object[])objects).map(AbstractProjectViewPane::createVisitor).nonNull().toImmutableList();
        if (list2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(51);
        }
        return list2;
    }

    @Nullable
    public static TreeVisitor createVisitor(@NotNull Object object) {
        Object node;
        if (object == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(52);
        }
        if (object instanceof AbstractTreeNode) {
            node = (AbstractTreeNode)object;
            object = ((AbstractTreeNode)node).getValue();
        }
        if (object instanceof ProjectFileNode) {
            node = (ProjectFileNode)object;
            object = node.getVirtualFile();
        }
        if (object instanceof VirtualFile) {
            return AbstractProjectViewPane.createVisitor((VirtualFile)object);
        }
        if (object instanceof PsiElement) {
            return AbstractProjectViewPane.createVisitor((PsiElement)object);
        }
        LOG.warn("unsupported object: " + object);
        return null;
    }

    @NotNull
    public static TreeVisitor createVisitor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(53);
        }
        TreeVisitor treeVisitor = AbstractProjectViewPane.createVisitor(null, file2);
        if (treeVisitor == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(54);
        }
        return treeVisitor;
    }

    @Nullable
    public static TreeVisitor createVisitor(@NotNull PsiElement element2) {
        if (element2 == null) {
            AbstractProjectViewPane.$$$reportNull$$$0(55);
        }
        return AbstractProjectViewPane.createVisitor(element2, null);
    }

    @Nullable
    public static TreeVisitor createVisitor(@Nullable PsiElement element2, @Nullable VirtualFile file2) {
        return AbstractProjectViewPane.createVisitor(element2, file2, null);
    }

    @Nullable
    static TreeVisitor createVisitor(@Nullable PsiElement element2, @Nullable VirtualFile file2, @Nullable List<? super TreePath> collector) {
        Predicate<TreePath> predicate;
        Predicate<TreePath> predicate2 = predicate = collector == null ? null : path2 -> {
            collector.add((TreePath)path2);
            return false;
        };
        if (element2 != null && element2.isValid()) {
            return new ProjectViewNodeVisitor(element2, file2, predicate);
        }
        if (file2 != null) {
            return new ProjectViewFileVisitor(file2, predicate);
        }
        LOG.warn(element2 != null ? "element invalidated: " + element2 : "cannot create visitor without element and/or file");
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_SUB_ID;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGroup";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isApplicable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClass";
                break;
            }
            case 15: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 22: 
            case 45: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/AbstractProjectViewPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManualOrderOptionText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSubIdIcon";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPSIElements";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromNode";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectories";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectoriesInAmbiguousCase";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "promisePathToElement";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitors";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultPane";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableSubIdIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doSelectModuleOrGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectModuleGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToolbarActions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFlattenModulesAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedNodes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAutoScrollEnabledFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installComparator";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTransferedPsiElements";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTransferedTreeNodes";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canDragElements";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "promisePathToElement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createVisitors";
                break;
            }
            case 52: 
            case 53: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyDragSource
    implements DnDSource {
        private MyDragSource() {
        }

        @Override
        public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
            if ((action2.getActionId() & 3) == 0) {
                return false;
            }
            Object[] elements2 = AbstractProjectViewPane.this.getSelectedElements();
            PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            DataContext dataContext = DataManager.getInstance().getDataContext(AbstractProjectViewPane.this.myTree);
            return psiElements.length > 0 || AbstractProjectViewPane.canDragElements(elements2, dataContext, action2.getActionId());
        }

        @Override
        public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
            final PsiElement[] psiElements = AbstractProjectViewPane.this.getSelectedPSIElements();
            final TreePath[] paths = AbstractProjectViewPane.this.getSelectionPaths();
            return new DnDDragStartBean(new TransferableWrapper(){

                @Override
                public List<File> asFileList() {
                    return PsiCopyPasteManager.asFileList(psiElements);
                }

                @Override
                public TreePath @Nullable [] getTreePaths() {
                    return paths;
                }

                @Override
                public TreeNode[] getTreeNodes() {
                    return TreePathUtil.toTreeNodes(this.getTreePaths());
                }

                @Override
                public PsiElement[] getPsiElements() {
                    return psiElements;
                }
            });
        }

        @Override
        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            TreePath[] paths;
            if (bean == null) {
                MyDragSource.$$$reportNull$$$0(0);
            }
            if ((paths = AbstractProjectViewPane.this.getSelectionPaths()) == null) {
                return null;
            }
            int count = paths.length;
            JLabel label2 = new JLabel(count + " " + StringUtil.pluralize("item", count));
            label2.setOpaque(true);
            label2.setForeground(RenderingUtil.getForeground(AbstractProjectViewPane.this.myTree));
            label2.setBackground(RenderingUtil.getBackground(AbstractProjectViewPane.this.myTree));
            label2.setFont(AbstractProjectViewPane.this.myTree.getFont());
            label2.setSize(label2.getPreferredSize());
            BufferedImage image = ImageUtil.createImage(label2.getWidth(), label2.getHeight(), 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            label2.paint(g2);
            g2.dispose();
            return new Pair<Image, Point>(image, new Point(-image.getWidth(null), -image.getHeight(null)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/ide/projectView/impl/AbstractProjectViewPane$MyDragSource", "createDraggedImage"));
        }
    }
}

