/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundTreeStructureProvider
implements TreeStructureProvider {
    private static final Key<TreeStructureProvider> KEY = Key.create("TreeStructureProvider");
    private static final Logger LOG = Logger.getInstance(CompoundTreeStructureProvider.class);
    private final Project myProject;

    @Nullable
    public static TreeStructureProvider get(@Nullable Project project2) {
        if (project2 == null || project2.isDisposed()) {
            return null;
        }
        TreeStructureProvider provider = project2.getUserData(KEY);
        if (provider != null) {
            return provider;
        }
        provider = new CompoundTreeStructureProvider(project2);
        project2.putUserData(KEY, provider);
        return provider;
    }

    public CompoundTreeStructureProvider(@NotNull Project project2) {
        if (project2 == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @Override
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        if (parent == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(1);
        }
        if (children2 == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(2);
        }
        for (TreeStructureProvider provider : EP.getExtensions(this.myProject)) {
            try {
                if (!(children2 = provider.modify(parent, children2, settings)).stream().anyMatch(Objects::isNull)) continue;
                LOG.warn("null child provided by " + provider);
                children2 = StreamEx.of(children2).nonNull().toImmutableList();
            }
            catch (IndexNotReadyException exception) {
                throw new ProcessCanceledException(exception);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.warn("unexpected error in " + provider, exception);
            }
        }
        children2.forEach(node -> node.setParent(parent));
        List list2 = children2;
        if (list2 == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode<?>> selection, @NotNull String dataId) {
        if (selection == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(4);
        }
        if (dataId == null) {
            CompoundTreeStructureProvider.$$$reportNull$$$0(5);
        }
        if (!selection.isEmpty()) {
            for (TreeStructureProvider provider : EP.getExtensions(this.myProject)) {
                try {
                    Object data2 = provider.getData(selection, dataId);
                    if (data2 == null) continue;
                    return data2;
                }
                catch (IndexNotReadyException data2) {
                }
                catch (ProcessCanceledException data2) {
                }
                catch (Exception exception) {
                    LOG.warn("unexpected error in " + provider, exception);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/CompoundTreeStructureProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/CompoundTreeStructureProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

