/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleGroup {
    public static final DataKey<ModuleGroup[]> ARRAY_DATA_KEY = DataKey.create("moduleGroup.array");
    private final List<String> myGroupPath;

    public ModuleGroup(@NotNull List<String> groupPath2) {
        if (groupPath2 == null) {
            ModuleGroup.$$$reportNull$$$0(0);
        }
        this.myGroupPath = groupPath2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleGroup)) {
            return false;
        }
        return this.myGroupPath.equals(((ModuleGroup)o).myGroupPath);
    }

    public int hashCode() {
        return this.myGroupPath.hashCode();
    }

    public String @NotNull [] getGroupPath() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.myGroupPath);
        if (stringArray == null) {
            ModuleGroup.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public List<String> getGroupPathList() {
        List<String> list2 = this.myGroupPath;
        if (list2 == null) {
            ModuleGroup.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public Collection<Module> modulesInGroup(@NotNull Project project2, boolean recursively) {
        if (project2 == null) {
            ModuleGroup.$$$reportNull$$$0(3);
        }
        Collection<Module> collection = this.modulesInGroup(ModuleGrouper.instanceFor(project2), recursively);
        if (collection == null) {
            ModuleGroup.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<Module> modulesInGroup(@NotNull ModuleGrouper grouper, boolean recursively) {
        if (grouper == null) {
            ModuleGroup.$$$reportNull$$$0(5);
        }
        ArrayList<Module> result2 = new ArrayList<Module>();
        Set<List<String>> moduleAsGroupsPaths = ContainerUtil.map2Set(grouper.getAllModules(), module2 -> grouper.getModuleAsGroupPath((Module)module2));
        for (Module module3 : grouper.getAllModules()) {
            List<String> group = grouper.getGroupPath(module3);
            if (!this.myGroupPath.equals(group) && (!ModuleGroup.isChild(this.myGroupPath, group) || !recursively && !ModuleGroup.isUnderGroupWithSameNameAsSomeModule(this.myGroupPath, group, moduleAsGroupsPaths))) continue;
            result2.add(module3);
        }
        ArrayList<Module> arrayList = result2;
        if (arrayList == null) {
            ModuleGroup.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean isUnderGroupWithSameNameAsSomeModule(@NotNull List<String> parent, @NotNull List<String> descendant, @NotNull Set<List<String>> moduleNamesAsGroups) {
        if (parent == null) {
            ModuleGroup.$$$reportNull$$$0(7);
        }
        if (descendant == null) {
            ModuleGroup.$$$reportNull$$$0(8);
        }
        if (moduleNamesAsGroups == null) {
            ModuleGroup.$$$reportNull$$$0(9);
        }
        return descendant.size() > parent.size() && moduleNamesAsGroups.contains(descendant.subList(0, parent.size() + 1));
    }

    @NotNull
    public Collection<ModuleGroup> childGroups(@NotNull ModuleGrouper grouper) {
        if (grouper == null) {
            ModuleGroup.$$$reportNull$$$0(10);
        }
        THashSet<ModuleGroup> result2 = new THashSet<ModuleGroup>();
        Set<List> moduleAsGroupsPaths = ContainerUtil.map2Set(grouper.getAllModules(), module2 -> grouper.getModuleAsGroupPath((Module)module2));
        for (Module module3 : grouper.getAllModules()) {
            List<String> directChild;
            List<String> group = grouper.getGroupPath(module3);
            if (!ModuleGroup.isChild(this.myGroupPath, group) || moduleAsGroupsPaths.contains(directChild = ContainerUtil.append(this.myGroupPath, group.get(this.myGroupPath.size())))) continue;
            result2.add(new ModuleGroup(directChild));
        }
        THashSet<ModuleGroup> tHashSet = result2;
        if (tHashSet == null) {
            ModuleGroup.$$$reportNull$$$0(11);
        }
        return tHashSet;
    }

    private static boolean isChild(@NotNull List<String> parent, @NotNull List<String> descendant) {
        if (parent == null) {
            ModuleGroup.$$$reportNull$$$0(12);
        }
        if (descendant == null) {
            ModuleGroup.$$$reportNull$$$0(13);
        }
        return descendant.size() > parent.size() && descendant.subList(0, parent.size()).equals(parent);
    }

    @NotNull
    public String presentableText() {
        String string = "'" + this.myGroupPath.get(this.myGroupPath.size() - 1) + "'";
        if (string == null) {
            ModuleGroup.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getQualifiedName() {
        String string = StringUtil.join(this.myGroupPath, ".");
        if (string == null) {
            ModuleGroup.$$$reportNull$$$0(15);
        }
        return string;
    }

    public String toString() {
        return this.myGroupPath.get(this.myGroupPath.size() - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ModuleGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNamesAsGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ModuleGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPathList";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "modulesInGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "childGroups";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "presentableText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "modulesInGroup";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnderGroupWithSameNameAsSomeModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "childGroups";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

