/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ProjectViewDropTarget
implements DnDNativeTarget {
    private final JTree myTree;
    private final Project myProject;

    ProjectViewDropTarget(JTree tree, Project project2) {
        this.myTree = tree;
        this.myProject = project2;
    }

    @Override
    public boolean update(DnDEvent event) {
        event.setDropPossible(false, "");
        Point point = event.getPoint();
        if (point == null) {
            return false;
        }
        TreePath target2 = this.myTree.getClosestPathForLocation(point.x, point.y);
        if (target2 == null) {
            return false;
        }
        Rectangle bounds2 = this.myTree.getPathBounds(target2);
        if (bounds2 == null || bounds2.y > point.y || point.y >= bounds2.y + bounds2.height) {
            return false;
        }
        DropHandler handler2 = this.getDropHandler(event);
        if (handler2 == null) {
            return false;
        }
        TreePath[] sources2 = ProjectViewDropTarget.getSourcePaths(event.getAttachedObject());
        if (sources2 != null) {
            if (ArrayUtilRt.find(sources2, target2) != -1) {
                return false;
            }
            if (!handler2.isValidSource(sources2, target2)) {
                return false;
            }
            if (Stream.of(sources2).allMatch(source -> handler2.isDropRedundant((TreePath)source, target2))) {
                return false;
            }
        } else {
            if (!FileCopyPasteUtil.isFileListFlavorAvailable(event)) {
                return false;
            }
            if (!SystemInfo.isMac) {
                PsiElement[] psiFiles = this.getPsiFiles(FileCopyPasteUtil.getFileListFromAttachedObject(event.getAttachedObject()));
                if (psiFiles == null || psiFiles.length == 0) {
                    return false;
                }
                if (!MoveHandler.isValidTarget(this.getPsiElement(target2), psiFiles)) {
                    return false;
                }
            }
        }
        event.setHighlighting(new RelativeRectangle(this.myTree, bounds2), 1);
        event.setDropPossible(true);
        return false;
    }

    @Override
    public void drop(DnDEvent event) {
        Point point = event.getPoint();
        if (point == null) {
            return;
        }
        TreePath target2 = this.myTree.getClosestPathForLocation(point.x, point.y);
        if (target2 == null) {
            return;
        }
        Rectangle bounds2 = this.myTree.getPathBounds(target2);
        if (bounds2 == null || bounds2.y > point.y || point.y >= bounds2.y + bounds2.height) {
            return;
        }
        DropHandler handler2 = this.getDropHandler(event);
        if (handler2 == null) {
            return;
        }
        Object attached = event.getAttachedObject();
        TreePath[] sources2 = ProjectViewDropTarget.getSourcePaths(event.getAttachedObject());
        if (sources2 == null) {
            List<File> fileList;
            if (FileCopyPasteUtil.isFileListFlavorAvailable(event) && !(fileList = FileCopyPasteUtil.getFileListFromAttachedObject(attached)).isEmpty()) {
                handler2.doDropFiles(fileList, target2);
            }
        } else {
            ProjectViewDropTarget.doValidDrop(sources2, target2, handler2);
        }
    }

    private static TreePath @Nullable [] getSourcePaths(Object transferData) {
        TransferableWrapper wrapper2 = transferData instanceof TransferableWrapper ? (TransferableWrapper)transferData : null;
        return wrapper2 == null ? null : wrapper2.getTreePaths();
    }

    private static void doValidDrop(TreePath @NotNull [] sources2, @NotNull TreePath target2, @NotNull DropHandler handler2) {
        if (target2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(0);
        }
        if (handler2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(1);
        }
        if (sources2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(2);
        }
        if ((target2 = ProjectViewDropTarget.getValidTarget(sources2, target2, handler2)) != null && (sources2 = ProjectViewDropTarget.removeRedundant(sources2, target2, handler2)).length != 0) {
            handler2.doDrop(sources2, target2);
        }
    }

    @Nullable
    private static TreePath getValidTarget(TreePath @NotNull [] sources2, @NotNull TreePath target2, @NotNull DropHandler handler2) {
        if (target2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(3);
        }
        if (handler2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(4);
        }
        if (sources2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(5);
        }
        while (target2 != null) {
            if (handler2.isValidTarget(sources2, target2)) {
                return target2;
            }
            if (!handler2.shouldDelegateToParent(sources2, target2)) break;
            target2 = target2.getParentPath();
        }
        return null;
    }

    private static TreePath @NotNull [] removeRedundant(TreePath @NotNull [] sources2, @NotNull TreePath target2, @NotNull DropHandler dropHandler) {
        if (target2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(6);
        }
        if (dropHandler == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(7);
        }
        if (sources2 == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(8);
        }
        TreePath[] treePathArray = (TreePath[])Stream.of(sources2).filter(source -> !dropHandler.isDropRedundant((TreePath)source, target2)).toArray(TreePath[]::new);
        if (treePathArray == null) {
            ProjectViewDropTarget.$$$reportNull$$$0(9);
        }
        return treePathArray;
    }

    private DropHandler getDropHandler(DnDEvent event) {
        if (event == null) {
            return null;
        }
        DnDAction action2 = event.getAction();
        if (action2 == null) {
            return null;
        }
        int id2 = action2.getActionId();
        if (id2 == 1) {
            return new CopyDropHandler();
        }
        if (id2 != 3 && id2 != 2) {
            return null;
        }
        return new MoveDropHandler();
    }

    @Nullable
    abstract PsiElement getPsiElement(@NotNull TreePath var1);

    @Nullable
    abstract Module getModule(@NotNull PsiElement var1);

    protected PsiFileSystemItem @Nullable [] getPsiFiles(@Nullable List<? extends File> fileList) {
        if (fileList == null) {
            return null;
        }
        ArrayList<PsiFileSystemItem> sourceFiles = new ArrayList<PsiFileSystemItem>();
        for (File file2 : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            PsiFileSystemItem psiFile = PsiUtilCore.findFileSystemItem(this.myProject, vFile);
            if (psiFile == null) continue;
            sourceFiles.add(psiFile);
        }
        return sourceFiles.toArray(new PsiFileSystemItem[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewDropTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewDropTarget";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRedundant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doValidDrop";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValidTarget";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeRedundant";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopyDropHandler
    extends MoveCopyDropHandler {
        private CopyDropHandler() {
        }

        @Override
        protected boolean canDrop(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            if (target2 == null) {
                CopyDropHandler.$$$reportNull$$$0(0);
            }
            if (sources2 == null) {
                CopyDropHandler.$$$reportNull$$$0(1);
            }
            PsiElement[] sourceElements = this.getPsiElements(sources2);
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(target2);
            if (targetElement == null) {
                return false;
            }
            PsiFile containingFile = targetElement.getContainingFile();
            boolean isTargetAcceptable = targetElement instanceof PsiDirectoryContainer || targetElement instanceof PsiDirectory || containingFile != null && containingFile.getContainingDirectory() != null;
            return isTargetAcceptable && CopyHandler.canCopy(sourceElements);
        }

        @Override
        public void doDrop(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            if (target2 == null) {
                CopyDropHandler.$$$reportNull$$$0(2);
            }
            if (sources2 == null) {
                CopyDropHandler.$$$reportNull$$$0(3);
            }
            PsiElement[] sourceElements = this.getPsiElements(sources2);
            this.doDrop(target2, sourceElements);
        }

        private void doDrop(@NotNull TreePath target2, PsiElement[] sources2) {
            PsiDirectory psiDirectory;
            PsiElement targetElement;
            if (target2 == null) {
                CopyDropHandler.$$$reportNull$$$0(4);
            }
            if ((targetElement = ProjectViewDropTarget.this.getPsiElement(target2)) == null) {
                return;
            }
            if (DumbService.isDumb(ProjectViewDropTarget.this.myProject)) {
                Messages.showMessageDialog(ProjectViewDropTarget.this.myProject, "Copy refactoring is not available while indexing is in progress", "Indexing", null);
                return;
            }
            if (targetElement instanceof PsiDirectoryContainer) {
                PsiDirectoryContainer directoryContainer = (PsiDirectoryContainer)targetElement;
                PsiDirectory[] psiDirectories = directoryContainer.getDirectories();
                psiDirectory = psiDirectories.length != 0 ? psiDirectories[0] : null;
            } else if (targetElement instanceof PsiDirectory) {
                psiDirectory = (PsiDirectory)targetElement;
            } else {
                PsiFile containingFile = targetElement.getContainingFile();
                DnDNativeTarget.LOG.assertTrue(containingFile != null, targetElement);
                psiDirectory = containingFile.getContainingDirectory();
            }
            CopyHandler.doCopy(sources2, psiDirectory);
        }

        @Override
        public boolean isDropRedundant(@NotNull TreePath source, @NotNull TreePath target2) {
            if (source == null) {
                CopyDropHandler.$$$reportNull$$$0(5);
            }
            if (target2 == null) {
                CopyDropHandler.$$$reportNull$$$0(6);
            }
            return false;
        }

        @Override
        public boolean shouldDelegateToParent(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            PsiElement psiElement;
            if (target2 == null) {
                CopyDropHandler.$$$reportNull$$$0(7);
            }
            if (sources2 == null) {
                CopyDropHandler.$$$reportNull$$$0(8);
            }
            return !((psiElement = ProjectViewDropTarget.this.getPsiElement(target2)) instanceof PsiDirectoryContainer) && !(psiElement instanceof PsiDirectory);
        }

        @Override
        public void doDropFiles(List<? extends File> files2, @NotNull TreePath target2) {
            if (target2 == null) {
                CopyDropHandler.$$$reportNull$$$0(9);
            }
            PsiElement[] sourceFileArray = ProjectViewDropTarget.this.getPsiFiles(files2);
            this.doDrop(target2, sourceFileArray);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sources";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewDropTarget$CopyDropHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doDrop";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropRedundant";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldDelegateToParent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doDropFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MoveDropHandler
    extends MoveCopyDropHandler {
        private MoveDropHandler() {
        }

        @Override
        protected boolean canDrop(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            DropTargetNode node;
            if (target2 == null) {
                MoveDropHandler.$$$reportNull$$$0(0);
            }
            if (sources2 == null) {
                MoveDropHandler.$$$reportNull$$$0(1);
            }
            if ((node = TreeUtil.getLastUserObject(DropTargetNode.class, target2)) != null && node.canDrop(sources2)) {
                return true;
            }
            PsiElement[] sourceElements = this.getPsiElements(sources2);
            PsiElement targetElement = ProjectViewDropTarget.this.getPsiElement(target2);
            return sourceElements.length == 0 || targetElement != null && MoveHandler.canMove(sourceElements, targetElement);
        }

        @Override
        public void doDrop(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            DropTargetNode node;
            if (target2 == null) {
                MoveDropHandler.$$$reportNull$$$0(2);
            }
            if (sources2 == null) {
                MoveDropHandler.$$$reportNull$$$0(3);
            }
            if ((node = TreeUtil.getLastUserObject(DropTargetNode.class, target2)) != null && node.canDrop(sources2)) {
                node.drop(sources2, DataManager.getInstance().getDataContext(ProjectViewDropTarget.this.myTree));
            } else {
                this.doDrop(ProjectViewDropTarget.this.getPsiElement(target2), this.getPsiElements(sources2), false);
            }
        }

        private void doDrop(PsiElement target2, PsiElement[] sources2, boolean externalDrop) {
            if (target2 == null) {
                return;
            }
            if (DumbService.isDumb(ProjectViewDropTarget.this.myProject)) {
                Messages.showMessageDialog(ProjectViewDropTarget.this.myProject, "Move refactoring is not available while indexing is in progress", "Indexing", null);
                return;
            }
            if (!ProjectViewDropTarget.this.myProject.isInitialized()) {
                Messages.showMessageDialog(ProjectViewDropTarget.this.myProject, "Move refactoring is not available while project initialization is in progress", "Project Initialization", null);
                return;
            }
            Module module2 = ProjectViewDropTarget.this.getModule(target2);
            DataContext dataContext = DataManager.getInstance().getDataContext(ProjectViewDropTarget.this.myTree);
            PsiDocumentManager.getInstance(ProjectViewDropTarget.this.myProject).commitAllDocuments();
            if (!target2.isValid()) {
                return;
            }
            for (PsiElement element2 : sources2) {
                if (element2.isValid()) continue;
                return;
            }
            DataContext context = dataId -> {
                if (LangDataKeys.TARGET_MODULE.is(dataId) && module2 != null) {
                    return module2;
                }
                if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
                    return target2;
                }
                return externalDrop ? null : dataContext.getData(dataId);
            };
            this.getActionHandler().invoke(ProjectViewDropTarget.this.myProject, sources2, context);
        }

        private RefactoringActionHandler getActionHandler() {
            return RefactoringActionHandlerFactory.getInstance().createMoveHandler();
        }

        @Override
        public boolean isDropRedundant(@NotNull TreePath source, @NotNull TreePath target2) {
            if (source == null) {
                MoveDropHandler.$$$reportNull$$$0(4);
            }
            if (target2 == null) {
                MoveDropHandler.$$$reportNull$$$0(5);
            }
            return target2.equals(source.getParentPath()) || MoveHandler.isMoveRedundant(ProjectViewDropTarget.this.getPsiElement(source), ProjectViewDropTarget.this.getPsiElement(target2));
        }

        @Override
        public boolean shouldDelegateToParent(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            PsiElement psiElement;
            if (target2 == null) {
                MoveDropHandler.$$$reportNull$$$0(6);
            }
            if (sources2 == null) {
                MoveDropHandler.$$$reportNull$$$0(7);
            }
            return !MoveHandler.isValidTarget(psiElement = ProjectViewDropTarget.this.getPsiElement(target2), this.getPsiElements(sources2));
        }

        @Override
        public void doDropFiles(List<? extends File> files2, @NotNull TreePath target2) {
            if (target2 == null) {
                MoveDropHandler.$$$reportNull$$$0(8);
            }
            PsiElement[] sourceFileArray = ProjectViewDropTarget.this.getPsiFiles(files2);
            DropTargetNode node = TreeUtil.getLastUserObject(DropTargetNode.class, target2);
            if (node != null) {
                node.dropExternalFiles((PsiFileSystemItem[])sourceFileArray, DataManager.getInstance().getDataContext(ProjectViewDropTarget.this.myTree));
            } else {
                this.doDrop(ProjectViewDropTarget.this.getPsiElement(target2), sourceFileArray, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveDropHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doDrop";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropRedundant";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldDelegateToParent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doDropFiles";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    abstract class MoveCopyDropHandler
    implements DropHandler {
        MoveCopyDropHandler() {
        }

        @Override
        public boolean isValidSource(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            if (target2 == null) {
                MoveCopyDropHandler.$$$reportNull$$$0(0);
            }
            if (sources2 == null) {
                MoveCopyDropHandler.$$$reportNull$$$0(1);
            }
            return this.canDrop(sources2, target2);
        }

        @Override
        public boolean isValidTarget(TreePath @NotNull [] sources2, @NotNull TreePath target2) {
            if (target2 == null) {
                MoveCopyDropHandler.$$$reportNull$$$0(2);
            }
            if (sources2 == null) {
                MoveCopyDropHandler.$$$reportNull$$$0(3);
            }
            return this.canDrop(sources2, target2);
        }

        protected abstract boolean canDrop(TreePath @NotNull [] var1, @NotNull TreePath var2);

        protected PsiElement @NotNull [] getPsiElements(TreePath @NotNull [] paths) {
            if (paths == null) {
                MoveCopyDropHandler.$$$reportNull$$$0(4);
            }
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>(paths.length);
            for (TreePath path2 : paths) {
                PsiElement psiElement = ProjectViewDropTarget.this.getPsiElement(path2);
                if (psiElement == null) continue;
                psiElements.add(psiElement);
            }
            if (!psiElements.isEmpty()) {
                PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(psiElements);
                if (psiElementArray == null) {
                    MoveCopyDropHandler.$$$reportNull$$$0(5);
                }
                return psiElementArray;
            }
            PsiElement[] psiElementArray = BaseRefactoringAction.getPsiElementArray(DataManager.getInstance().getDataContext(ProjectViewDropTarget.this.myTree));
            if (psiElementArray == null) {
                MoveCopyDropHandler.$$$reportNull$$$0(6);
            }
            return psiElementArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sources";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/ProjectViewDropTarget$MoveCopyDropHandler";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidSource";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidTarget";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getPsiElements";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface DropHandler {
        public boolean isValidSource(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public boolean isValidTarget(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public boolean shouldDelegateToParent(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public boolean isDropRedundant(@NotNull TreePath var1, @NotNull TreePath var2);

        public void doDrop(TreePath @NotNull [] var1, @NotNull TreePath var2);

        public void doDropFiles(List<? extends File> var1, @NotNull TreePath var2);
    }
}

