/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.ProjectViewRenderer;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectViewTree
extends DnDAwareTree {
    private static final Logger LOG = Logger.getInstance(ProjectViewTree.class);

    protected ProjectViewTree(Project project2, TreeModel model) {
        this(model);
    }

    public ProjectViewTree(TreeModel model) {
        super((TreeModel)null);
        this.setLargeModel(true);
        this.setModel(model);
        this.setCellRenderer(this.createCellRenderer());
        HintUpdateSupply.installDataContextHintUpdateSupply(this);
    }

    @NotNull
    protected TreeCellRenderer createCellRenderer() {
        return new ProjectViewRenderer();
    }

    @Deprecated
    public DefaultMutableTreeNode getSelectedNode() {
        TreePath path2 = TreeUtil.getSelectedPathIfOne(this);
        return path2 == null ? null : ObjectUtils.tryCast(path2.getLastPathComponent(), DefaultMutableTreeNode.class);
    }

    @Override
    public final int getToggleClickCount() {
        NodeDescriptor descriptor2;
        int count = super.getToggleClickCount();
        TreePath path2 = this.getSelectionPath();
        if (path2 != null && (descriptor2 = TreeUtil.getLastUserObject(NodeDescriptor.class, path2)) != null && !descriptor2.expandOnDoubleClick()) {
            LOG.debug("getToggleClickCount: -1 for ", descriptor2.getClass().getName());
            return -1;
        }
        return count;
    }

    @Override
    public void setToggleClickCount(int count) {
        if (count != 2) {
            LOG.info(new IllegalStateException("setToggleClickCount: unexpected count = " + count));
        }
        super.setToggleClickCount(count);
    }

    @Override
    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor(this);
    }

    public static boolean isFileColorsEnabledFor(JTree tree) {
        boolean enabled = FileColorManagerImpl._isEnabled() && FileColorManagerImpl._isEnabledForProjectView();
        boolean opaque = tree.isOpaque();
        if (enabled && opaque) {
            tree.setOpaque(false);
        } else if (!enabled && !opaque) {
            tree.setOpaque(true);
        }
        return enabled;
    }

    @Override
    @DirtyUI
    @Nullable
    public Color getFileColorFor(Object object) {
        Color color;
        Project project2;
        VirtualFile file2;
        Object value2;
        Object node;
        if (object instanceof DefaultMutableTreeNode) {
            node = (DefaultMutableTreeNode)object;
            object = ((DefaultMutableTreeNode)node).getUserObject();
        }
        if (object instanceof AbstractTreeNode && (value2 = ((AbstractTreeNode)(node = (AbstractTreeNode)object)).getValue()) instanceof PsiElement) {
            return ProjectViewTree.getColorForElement((PsiElement)value2);
        }
        if (object instanceof ProjectViewNode && (file2 = ((ProjectViewNode)(node = (ProjectViewNode)object)).getVirtualFile()) != null && (project2 = ((NodeDescriptor)node).getProject()) != null && !project2.isDisposed() && (color = VfsPresentationUtil.getFileBackgroundColor(project2, file2)) != null) {
            return color;
        }
        return null;
    }

    @Nullable
    public static Color getColorForElement(@Nullable PsiElement psi) {
        Color color = null;
        if (psi != null) {
            if (!psi.isValid()) {
                return null;
            }
            Project project2 = psi.getProject();
            VirtualFile file2 = PsiUtilCore.getVirtualFile(psi);
            if (file2 != null) {
                color = VfsPresentationUtil.getFileBackgroundColor(project2, file2);
            } else if (psi instanceof PsiDirectory) {
                color = VfsPresentationUtil.getFileBackgroundColor(project2, ((PsiDirectory)psi).getVirtualFile());
            } else if (psi instanceof PsiDirectoryContainer) {
                PsiDirectory[] dirs;
                for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)psi).getDirectories()) {
                    Color c = VfsPresentationUtil.getFileBackgroundColor(project2, dir.getVirtualFile());
                    if (c != null && color == null) {
                        color = c;
                        continue;
                    }
                    if (c == null) continue;
                    color = null;
                    break;
                }
            }
        }
        return color;
    }
}

