/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NonNls;

public class PsiFileUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "psiFile";

    public PsiFileUrl(String url) {
        super(url, null, ELEMENT_TYPE);
    }

    @Override
    public Object[] createPath(Project project2) {
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.url);
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return new Object[]{PsiManager.getInstance(project2).findFile(file2)};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new PsiFileUrl(url);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element2) {
        VirtualFile file2;
        if (element2 instanceof PsiFile && (file2 = ((PsiFile)element2).getVirtualFile()) != null) {
            return new PsiFileUrl(file2.getUrl());
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PsiFileUrl) {
            return StringUtil.equals(this.url, ((PsiFileUrl)o).url);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.url == null ? 0 : this.url.hashCode();
    }
}

