/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryGroupNode
extends ProjectViewNode<LibraryGroupElement> {
    public LibraryGroupNode(Project project2, @NotNull LibraryGroupElement value2, ViewSettings viewSettings) {
        if (value2 == null) {
            LibraryGroupNode.$$$reportNull$$$0(0);
        }
        super(project2, value2, viewSettings);
    }

    @Override
    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        OrderEntry[] orderEntries;
        Module module2 = ((LibraryGroupElement)this.getValue()).getModule();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
        ArrayList children2 = new ArrayList();
        for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
            JdkOrderEntry jdkOrderEntry;
            Sdk jdk;
            if (orderEntry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                Library library = libraryOrderEntry.getLibrary();
                if (library == null) continue;
                String libraryName = library.getName();
                if (libraryName == null || libraryName.length() == 0) {
                    LibraryGroupNode.addLibraryChildren(libraryOrderEntry, children2, this.getProject(), this);
                    continue;
                }
                children2.add(new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module2, libraryOrderEntry), this.getSettings()));
                continue;
            }
            if (!(orderEntry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) == null) continue;
            children2.add(new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module2, jdkOrderEntry), this.getSettings()));
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            LibraryGroupNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    public static void addLibraryChildren(LibraryOrSdkOrderEntry entry, List<? super AbstractTreeNode<?>> children2, Project project2, ProjectViewNode node) {
        VirtualFile[] files2;
        PsiManager psiManager = PsiManager.getInstance(project2);
        for (VirtualFile file2 : files2 = entry instanceof LibraryOrderEntry ? LibraryGroupNode.getLibraryRoots((LibraryOrderEntry)entry) : entry.getRootFiles(OrderRootType.CLASSES)) {
            if (!file2.isValid()) continue;
            if (file2.isDirectory()) {
                PsiDirectory psiDir = psiManager.findDirectory(file2);
                if (psiDir == null) continue;
                children2.add(new PsiDirectoryNode(project2, psiDir, node.getSettings()));
                continue;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null) continue;
            children2.add(new PsiFileNode(project2, psiFile, node.getSettings()));
        }
    }

    @Override
    public String getTestPresentation() {
        return "Libraries";
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        ProjectFileIndex index;
        if (file2 == null) {
            LibraryGroupNode.$$$reportNull$$$0(2);
        }
        if (!(index = ProjectRootManager.getInstance(this.getProject()).getFileIndex()).isInLibrary(file2)) {
            return false;
        }
        return this.someChildContainsFile(file2, false);
    }

    @Override
    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            LibraryGroupNode.$$$reportNull$$$0(3);
        }
        presentation.setPresentableText(IdeBundle.message("node.projectview.libraries", new Object[0]));
        presentation.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    @Override
    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenModuleLibrarySettings();
    }

    @Override
    public void navigate(boolean requestFocus) {
        Module module2 = ((LibraryGroupElement)this.getValue()).getModule();
        ProjectSettingsService.getInstance(this.myProject).openModuleLibrarySettings(module2);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull LibraryOrderEntry orderEntry) {
        Library library;
        if (orderEntry == null) {
            LibraryGroupNode.$$$reportNull$$$0(4);
        }
        if ((library = orderEntry.getLibrary()) == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                LibraryGroupNode.$$$reportNull$$$0(5);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        OrderRootType[] rootTypes = LibraryType.DEFAULT_EXTERNAL_ROOT_TYPES;
        if (library instanceof LibraryEx) {
            if (((LibraryEx)library).isDisposed()) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    LibraryGroupNode.$$$reportNull$$$0(6);
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            PersistentLibraryKind<?> libKind = ((LibraryEx)library).getKind();
            if (libKind != null) {
                rootTypes = LibraryType.findByKind(libKind).getExternalRootTypes();
            }
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (OrderRootType rootType : rootTypes) {
            files2.addAll(Arrays.asList(library.getFiles(rootType)));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files2);
        if (virtualFileArray == null) {
            LibraryGroupNode.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/LibraryGroupNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/LibraryGroupNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

