/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;

public class ProjectViewDirectoryHelper {
    protected static final Logger LOG = Logger.getInstance(ProjectViewDirectoryHelper.class);
    private final Project myProject;
    private final DirectoryIndex myIndex;

    public static ProjectViewDirectoryHelper getInstance(Project project2) {
        return ServiceManager.getService(project2, ProjectViewDirectoryHelper.class);
    }

    public ProjectViewDirectoryHelper(Project project2) {
        this.myProject = project2;
        this.myIndex = DirectoryIndex.getInstance(project2);
    }

    @Deprecated
    public ProjectViewDirectoryHelper(Project project2, DirectoryIndex index) {
        this.myProject = project2;
        this.myIndex = index;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(0);
        }
        boolean includeUrl = ProjectRootsUtil.isModuleContentRoot(psiDirectory);
        return this.getLocationString(psiDirectory, includeUrl, false);
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory psiDirectory, boolean includeUrl, boolean includeRootType) {
        ModuleSourceRootEditHandler<?> handler2;
        SourceFolder sourceRoot;
        if (psiDirectory == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(1);
        }
        StringBuilder result2 = new StringBuilder();
        VirtualFile directory = psiDirectory.getVirtualFile();
        if (ProjectRootsUtil.isLibraryRoot(directory, psiDirectory.getProject())) {
            result2.append(ProjectBundle.message("module.paths.root.node", "library").toLowerCase(Locale.getDefault()));
        } else if (includeRootType && (sourceRoot = ProjectRootsUtil.getModuleSourceRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject())) != null && (handler2 = ModuleSourceRootEditHandler.getEditHandler(sourceRoot.getRootType())) != null) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceRoot.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties != null && properties.isForGeneratedSources()) {
                result2.append("generated ");
            }
            result2.append(handler2.getFullRootTypeName().toLowerCase(Locale.getDefault()));
        }
        if (includeUrl) {
            if (result2.length() > 0) {
                result2.append(",").append(FontUtil.spaceAndThinSpace());
            }
            result2.append(FileUtil.getLocationRelativeToUserHome(directory.getPresentableUrl()));
        }
        return result2.length() == 0 ? null : result2.toString();
    }

    public boolean isShowFQName(ViewSettings settings, Object parentValue, PsiDirectory value2) {
        return false;
    }

    public boolean shouldHideProjectConfigurationFilesDirectory() {
        return true;
    }

    @Nullable
    public String getNodeName(ViewSettings settings, Object parentValue, PsiDirectory directory) {
        return directory.getName();
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return true;
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty) {
        return this.isEmptyMiddleDirectory(directory, strictlyEmpty, null);
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty, @Nullable PsiFileSystemItemFilter filter2) {
        return false;
    }

    public boolean supportsFlattenPackages() {
        return false;
    }

    public boolean supportsHideEmptyMiddlePackages() {
        return false;
    }

    public boolean canRepresent(Object element2, PsiDirectory directory) {
        if (element2 instanceof VirtualFile) {
            VirtualFile vFile = (VirtualFile)element2;
            return Comparing.equal(directory.getVirtualFile(), vFile);
        }
        return false;
    }

    public boolean canRepresent(Object element2, PsiDirectory directory, Object owner, ViewSettings settings) {
        if (directory != null) {
            if (this.canRepresent(element2, directory)) {
                return true;
            }
            if (settings == null) {
                return false;
            }
            if (!settings.isFlattenPackages() && settings.isHideEmptyMiddlePackages() && (element2 instanceof PsiDirectory ? ProjectViewDirectoryHelper.getParents(directory, owner).find(dir -> Comparing.equal(element2, dir)) != null : element2 instanceof VirtualFile && ProjectViewDirectoryHelper.getParents(directory, owner).find(dir -> Comparing.equal(element2, dir.getVirtualFile())) != null)) {
                return true;
            }
        }
        return false;
    }

    boolean isValidDirectory(PsiDirectory directory, Object owner, ViewSettings settings, PsiFileSystemItemFilter filter2) {
        if (directory == null || !directory.isValid()) {
            return false;
        }
        if (settings == null) {
            return true;
        }
        if (!settings.isFlattenPackages() && settings.isHideEmptyMiddlePackages()) {
            PsiDirectory parent = directory.getParent();
            if (parent == null || this.skipDirectory(parent)) {
                return true;
            }
            if (ProjectRootsUtil.isSourceRoot(directory)) {
                return true;
            }
            if (this.isEmptyMiddleDirectory(directory, true, filter2)) {
                return false;
            }
            for (PsiDirectory dir : ProjectViewDirectoryHelper.getParents(directory, owner)) {
                if (!dir.isValid()) {
                    return false;
                }
                parent = dir.getParent();
                if (parent == null || this.skipDirectory(parent)) {
                    return false;
                }
                if (this.isEmptyMiddleDirectory(dir, true, filter2)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static JBIterable<PsiDirectory> getParents(PsiDirectory directory, Object owner) {
        if (directory != null) {
            directory = directory.getParent();
        }
        JBIterable<PsiDirectory> jBIterable = directory != null && owner instanceof PsiDirectory && PsiTreeUtil.isAncestor((PsiDirectory)owner, directory, true) ? JBIterable.generate(directory, PsiDirectory::getParent).takeWhile(dir -> dir != null && !dir.equals(owner)) : JBIterable.empty();
        if (jBIterable == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories) {
        Collection<AbstractTreeNode<?>> collection = this.getDirectoryChildren(psiDirectory, settings, withSubDirectories, null);
        if (collection == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories, @Nullable PsiFileSystemItemFilter filter2) {
        Collection collection = AbstractTreeUi.calculateYieldingToWriteAction(() -> this.doGetDirectoryChildren(psiDirectory, settings, withSubDirectories, filter2));
        if (collection == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private Collection<AbstractTreeNode<?>> doGetDirectoryChildren(PsiDirectory psiDirectory, ViewSettings settings, boolean withSubDirectories, @Nullable PsiFileSystemItemFilter filter2) {
        ModuleFileIndex moduleFileIndex;
        ArrayList children2 = new ArrayList();
        Project project2 = psiDirectory.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        Module module2 = fileIndex.getModuleForFile(psiDirectory.getVirtualFile());
        ModuleFileIndex moduleFileIndex2 = moduleFileIndex = module2 == null ? null : ModuleRootManager.getInstance(module2).getFileIndex();
        if (!settings.isFlattenPackages() || this.skipDirectory(psiDirectory)) {
            this.processPsiDirectoryChildren(psiDirectory, this.directoryChildrenInProject(psiDirectory, settings), children2, fileIndex, null, settings, withSubDirectories, filter2);
        } else {
            PsiDirectory parentDir = psiDirectory.getParentDirectory();
            if (parentDir == null || this.skipDirectory(parentDir) && withSubDirectories) {
                this.addAllSubpackages(children2, psiDirectory, moduleFileIndex, settings, filter2);
            }
            if (withSubDirectories) {
                PsiDirectory[] subdirs;
                for (PsiDirectory subdir : subdirs = psiDirectory.getSubdirectories()) {
                    if (!this.skipDirectory(subdir) || filter2 != null && !filter2.shouldShow(subdir)) continue;
                    VirtualFile directoryFile = subdir.getVirtualFile();
                    if (Registry.is("ide.hide.excluded.files") ? fileIndex.isExcluded(directoryFile) : FileTypeRegistry.getInstance().isFileIgnored(directoryFile)) continue;
                    children2.add(new PsiDirectoryNode(project2, subdir, settings, filter2));
                }
            }
            this.processPsiDirectoryChildren(psiDirectory, psiDirectory.getFiles(), children2, fileIndex, moduleFileIndex, settings, withSubDirectories, filter2);
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getTopLevelRoots() {
        ArrayList<VirtualFile> topLevelContentRoots = new ArrayList<VirtualFile>();
        ProjectRootManager prm = ProjectRootManager.getInstance(this.myProject);
        for (VirtualFile root : prm.getContentRoots()) {
            VirtualFile parent = root.getParent();
            if (ProjectViewDirectoryHelper.isFileUnderContentRoot(this.myIndex, parent)) continue;
            topLevelContentRoots.add(root);
        }
        Collection<UnloadedModuleDescription> descriptions = ModuleManager.getInstance(this.myProject).getUnloadedModuleDescriptions();
        for (UnloadedModuleDescription description : descriptions) {
            for (VirtualFilePointer pointer : description.getContentRoots()) {
                VirtualFile parent;
                VirtualFile root = pointer.getFile();
                if (root == null || ProjectViewDirectoryHelper.isFileUnderContentRoot(this.myIndex, parent = root.getParent())) continue;
                topLevelContentRoots.add(root);
            }
        }
        ArrayList<VirtualFile> arrayList = topLevelContentRoots;
        if (arrayList == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    List<VirtualFile> getTopLevelModuleRoots(Module module2, ViewSettings settings) {
        List<VirtualFile> list2 = ContainerUtil.filter(ModuleRootManager.getInstance(module2).getContentRoots(), root -> {
            if (!this.shouldBeShown((VirtualFile)root, settings)) {
                return false;
            }
            VirtualFile parent = root.getParent();
            if (parent == null) {
                return true;
            }
            DirectoryInfo info = this.myIndex.getInfoForFile(parent);
            if (!module2.equals(info.getModule())) {
                return true;
            }
            return info.isExcluded(parent) && !ProjectViewDirectoryHelper.shouldShowExcludedFiles(settings);
        });
        if (list2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    List<VirtualFile> getTopLevelUnloadedModuleRoots(UnloadedModuleDescription module2, ViewSettings settings) {
        List<VirtualFile> list2 = module2.getContentRoots().stream().map(VirtualFilePointer::getFile).filter(root -> root != null && this.shouldBeShown((VirtualFile)root, settings)).collect(Collectors.toList());
        if (list2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static boolean isFileUnderContentRoot(@NotNull DirectoryIndex index, @Nullable VirtualFile file2) {
        if (index == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(9);
        }
        return file2 != null && index.getInfoForFile(file2).getContentRoot() != null;
    }

    private PsiElement @NotNull [] directoryChildrenInProject(PsiDirectory psiDirectory, final ViewSettings settings) {
        VirtualFile dir = psiDirectory.getVirtualFile();
        if (this.shouldBeShown(dir, settings)) {
            final ArrayList children2 = new ArrayList();
            psiDirectory.processChildren(new PsiElementProcessor<PsiFileSystemItem>(){

                @Override
                public boolean execute(@NotNull PsiFileSystemItem element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (ProjectViewDirectoryHelper.this.shouldBeShown(element2.getVirtualFile(), settings)) {
                        children2.add(element2);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper$1", "execute"));
                }
            });
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children2);
            if (psiElementArray == null) {
                ProjectViewDirectoryHelper.$$$reportNull$$$0(10);
            }
            return psiElementArray;
        }
        PsiManager manager = psiDirectory.getManager();
        THashSet<PsiDirectory> directoriesOnTheWayToContentRoots = new THashSet<PsiDirectory>();
        Iterator<VirtualFile> iterator2 = this.getTopLevelRoots().iterator();
        while (iterator2.hasNext()) {
            VirtualFile root;
            VirtualFile current2 = root = iterator2.next();
            while (current2 != null) {
                PsiDirectory psi;
                VirtualFile parent = current2.getParent();
                if (Comparing.equal(parent, dir) && (psi = manager.findDirectory(current2)) != null) {
                    directoriesOnTheWayToContentRoots.add(psi);
                }
                current2 = parent;
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(directoriesOnTheWayToContentRoots);
        if (psiElementArray == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(11);
        }
        return psiElementArray;
    }

    private boolean shouldBeShown(@NotNull VirtualFile dir, ViewSettings settings) {
        if (dir == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(12);
        }
        if (!dir.isValid()) {
            return false;
        }
        DirectoryInfo directoryInfo = this.myIndex.getInfoForFile(dir);
        return directoryInfo.isInProject(dir) || ProjectViewDirectoryHelper.shouldShowExcludedFiles(settings) && directoryInfo.isExcluded(dir);
    }

    private static boolean shouldShowExcludedFiles(ViewSettings settings) {
        return !Registry.is("ide.hide.excluded.files") && settings instanceof ProjectViewSettings && ((ProjectViewSettings)settings).isShowExcludedFiles();
    }

    private void processPsiDirectoryChildren(PsiDirectory psiDir, PsiElement[] children2, List<? super AbstractTreeNode<?>> container2, ProjectFileIndex projectFileIndex, @Nullable ModuleFileIndex moduleFileIndex, ViewSettings viewSettings, boolean withSubDirectories, @Nullable PsiFileSystemItemFilter filter2) {
        for (PsiElement child2 : children2) {
            LOG.assertTrue(child2.isValid());
            if (!(child2 instanceof PsiFileSystemItem)) {
                LOG.error("Either PsiFile or PsiDirectory expected as a child of " + child2.getParent() + ", but was " + child2);
                continue;
            }
            VirtualFile vFile = ((PsiFileSystemItem)child2).getVirtualFile();
            if (vFile == null || moduleFileIndex != null && !moduleFileIndex.isInContent(vFile) || filter2 != null && !filter2.shouldShow((PsiFileSystemItem)child2)) continue;
            if (child2 instanceof PsiFile) {
                container2.add(new PsiFileNode(child2.getProject(), (PsiFile)child2, viewSettings));
                continue;
            }
            if (!(child2 instanceof PsiDirectory) || !withSubDirectories) continue;
            PsiDirectory dir = (PsiDirectory)child2;
            if (!vFile.equals(projectFileIndex.getSourceRootForFile(vFile)) && viewSettings.isHideEmptyMiddlePackages() && !this.skipDirectory(psiDir) && this.isEmptyMiddleDirectory(dir, true, filter2)) {
                this.processPsiDirectoryChildren(dir, this.directoryChildrenInProject(dir, viewSettings), container2, projectFileIndex, moduleFileIndex, viewSettings, true, filter2);
                continue;
            }
            container2.add(new PsiDirectoryNode(child2.getProject(), (PsiDirectory)child2, viewSettings, filter2));
        }
    }

    private void addAllSubpackages(List<? super AbstractTreeNode<?>> container2, PsiDirectory dir, @Nullable ModuleFileIndex moduleFileIndex, ViewSettings viewSettings, @Nullable PsiFileSystemItemFilter filter2) {
        PsiDirectory[] subdirs;
        Project project2 = dir.getProject();
        for (PsiDirectory subdir : subdirs = dir.getSubdirectories()) {
            if (this.skipDirectory(subdir) || filter2 != null && !filter2.shouldShow(subdir)) continue;
            if (moduleFileIndex != null && !moduleFileIndex.isInContent(subdir.getVirtualFile())) {
                container2.add(new PsiDirectoryNode(project2, subdir, viewSettings, filter2));
                continue;
            }
            if (viewSettings.isHideEmptyMiddlePackages()) {
                if (!this.isEmptyMiddleDirectory(subdir, false, filter2)) {
                    container2.add(new PsiDirectoryNode(project2, subdir, viewSettings, filter2));
                }
            } else {
                container2.add(new PsiDirectoryNode(project2, subdir, viewSettings, filter2));
            }
            this.addAllSubpackages(container2, subdir, moduleFileIndex, viewSettings, filter2);
        }
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> createFileAndDirectoryNodes(@NotNull List<? extends VirtualFile> files2, ViewSettings viewSettings) {
        if (files2 == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(13);
        }
        ArrayList children2 = new ArrayList(files2.size());
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        for (VirtualFile virtualFile2 : files2) {
            if (virtualFile2.isDirectory()) {
                PsiDirectory directory = psiManager.findDirectory(virtualFile2);
                if (directory == null) continue;
                children2.add(new PsiDirectoryNode(this.myProject, directory, viewSettings));
                continue;
            }
            PsiFile file2 = psiManager.findFile(virtualFile2);
            if (file2 == null) continue;
            children2.add(new PsiFileNode(this.myProject, file2, viewSettings));
        }
        ArrayList arrayList = children2;
        if (arrayList == null) {
            ProjectViewDirectoryHelper.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ProjectViewDirectoryHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetDirectoryChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelRoots";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelModuleRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelUnloadedModuleRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "directoryChildrenInProject";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileAndDirectoryNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderContentRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeShown";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFileAndDirectoryNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

