/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewUnloadedModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewProjectNode
extends AbstractProjectNode {
    public ProjectViewProjectNode(@NotNull Project project2, ViewSettings viewSettings) {
        if (project2 == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(0);
        }
        super(project2, project2, viewSettings);
    }

    @Override
    public boolean canRepresent(Object element2) {
        Project project2 = (Project)this.getValue();
        return project2 == element2 || project2 != null && element2 instanceof VirtualFile && element2.equals(project2.getBaseDir());
    }

    @Override
    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        VirtualFile[] files2;
        if (this.myProject.isDisposed()) {
            List<AbstractTreeNode<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VirtualFile> topLevelContentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelRoots();
        LinkedHashSet<LoadedModuleDescriptionImpl> modules = new LinkedHashSet<LoadedModuleDescriptionImpl>(topLevelContentRoots.size());
        for (VirtualFile root : topLevelContentRoots) {
            Module module2 = ModuleUtilCore.findModuleForFile(root, this.myProject);
            if (module2 != null) {
                modules.add(new LoadedModuleDescriptionImpl(module2));
                continue;
            }
            String unloadedModuleName = ProjectRootsUtil.findUnloadedModuleByContentRoot(root, this.myProject);
            if (unloadedModuleName == null) continue;
            ContainerUtil.addIfNotNull(modules, ModuleManager.getInstance(this.myProject).getUnloadedModuleDescription(unloadedModuleName));
        }
        PsiManager psiManager = PsiManager.getInstance(this.getProject());
        ArrayList nodes = new ArrayList(this.modulesAndGroups(modules));
        VirtualFile baseDir = this.getProject().getBaseDir();
        if (baseDir == null) {
            ArrayList arrayList = nodes;
            if (arrayList == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(2);
            }
            return arrayList;
        }
        for (VirtualFile file2 : files2 = baseDir.getChildren()) {
            PsiFile psiFile;
            if (file2.isDirectory() || ProjectFileIndex.SERVICE.getInstance(this.getProject()).getModuleForFile(file2, false) != null || (psiFile = psiManager.findFile(file2)) == null) continue;
            nodes.add(new PsiFileNode(this.getProject(), psiFile, this.getSettings()));
        }
        if (this.getSettings().isShowLibraryContents()) {
            nodes.add(new ExternalLibrariesNode(this.getProject(), this.getSettings()));
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected AbstractTreeNode createModuleGroup(@NotNull Module module2) {
        PsiDirectory psi;
        List<VirtualFile> roots;
        if (module2 == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(4);
        }
        if ((roots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelModuleRoots(module2, this.getSettings())).size() == 1 && (psi = PsiManager.getInstance(this.myProject).findDirectory(roots.get(0))) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewModuleNode(this.getProject(), module2, this.getSettings());
    }

    protected AbstractTreeNode createUnloadedModuleNode(@NotNull UnloadedModuleDescription moduleDescription) {
        PsiDirectory psi;
        List<VirtualFile> roots;
        if (moduleDescription == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(5);
        }
        if ((roots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelUnloadedModuleRoots(moduleDescription, this.getSettings())).size() == 1 && (psi = PsiManager.getInstance(this.myProject).findDirectory(roots.get(0))) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewUnloadedModuleNode(this.getProject(), moduleDescription, this.getSettings());
    }

    @NotNull
    protected AbstractTreeNode createModuleGroupNode(@NotNull ModuleGroup moduleGroup) {
        if (moduleGroup == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(6);
        }
        return new ProjectViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescription";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUnloadedModuleNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createModuleGroupNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

