/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDirectoryNode
extends BasePsiNode<PsiDirectory>
implements NavigatableWithText {
    private final Set<VirtualFile> chain;
    private final PsiFileSystemItemFilter myFilter;

    public PsiDirectoryNode(Project project2, @NotNull PsiDirectory value2, ViewSettings viewSettings) {
        if (value2 == null) {
            PsiDirectoryNode.$$$reportNull$$$0(0);
        }
        this(project2, value2, viewSettings, null);
    }

    public PsiDirectoryNode(Project project2, @NotNull PsiDirectory value2, ViewSettings viewSettings, @Nullable PsiFileSystemItemFilter filter2) {
        if (value2 == null) {
            PsiDirectoryNode.$$$reportNull$$$0(1);
        }
        super(project2, value2, viewSettings);
        this.chain = new SmartHashSet<VirtualFile>();
        this.myFilter = filter2;
    }

    @Nullable
    public PsiFileSystemItemFilter getFilter() {
        return this.myFilter;
    }

    protected boolean shouldShowModuleName() {
        return !PlatformUtils.isCidr();
    }

    protected boolean shouldShowSourcesRoot() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateImpl(@NotNull PresentationData data2) {
        String name;
        if (data2 == null) {
            PsiDirectoryNode.$$$reportNull$$$0(2);
        }
        Project project2 = this.getProject();
        assert (project2 != null) : this;
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        assert (psiDirectory != null) : this;
        VirtualFile directoryFile = psiDirectory.getVirtualFile();
        Object parentValue = this.getParentValue();
        Set<VirtualFile> set = this.chain;
        synchronized (set) {
            if (this.chain.isEmpty()) {
                VirtualFile ancestor = PsiDirectoryNode.getVirtualFile(parentValue);
                if (ancestor != null) {
                    for (VirtualFile file2 = directoryFile; file2 != null && VfsUtilCore.isAncestor(ancestor, file2, true); file2 = file2.getParent()) {
                        this.chain.add(file2);
                    }
                }
                if (this.chain.isEmpty()) {
                    this.chain.add(directoryFile);
                }
            }
        }
        if (ProjectRootsUtil.isModuleContentRoot(directoryFile, project2)) {
            ProjectFileIndex fi = ProjectRootManager.getInstance(project2).getFileIndex();
            Module module2 = fi.getModuleForFile(directoryFile);
            data2.setPresentableText(directoryFile.getName());
            if (module2 != null) {
                if (!(parentValue instanceof Module)) {
                    if (ModuleType.isInternal(module2) || !this.shouldShowModuleName()) {
                        data2.addText(directoryFile.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (PsiDirectoryNode.moduleNameMatchesDirectoryName(module2, directoryFile, fi)) {
                        data2.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        data2.addText(directoryFile.getName() + " ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        data2.addText("[" + module2.getName() + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                } else {
                    data2.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                boolean shouldShowUrl = this.getSettings().isShowURL() && (parentValue instanceof Module || parentValue instanceof Project);
                data2.setLocationString(ProjectViewDirectoryHelper.getInstance(project2).getLocationString(psiDirectory, shouldShowUrl, this.shouldShowSourcesRoot()));
                this.setupIcon(data2, psiDirectory);
                return;
            }
        }
        String string = name = parentValue instanceof Project ? psiDirectory.getVirtualFile().getPresentableUrl() : ProjectViewDirectoryHelper.getInstance(psiDirectory.getProject()).getNodeName(this.getSettings(), parentValue, psiDirectory);
        if (name == null) {
            this.setValue(null);
            return;
        }
        data2.setPresentableText(name);
        data2.setLocationString(ProjectViewDirectoryHelper.getInstance(project2).getLocationString(psiDirectory, false, false));
        this.setupIcon(data2, psiDirectory);
    }

    private static boolean moduleNameMatchesDirectoryName(@NotNull Module module2, @NotNull VirtualFile directoryFile, @NotNull ProjectFileIndex fileIndex) {
        Module parentModule;
        VirtualFile parentDirectory;
        int parentPrefixLength;
        String directoryName;
        if (module2 == null) {
            PsiDirectoryNode.$$$reportNull$$$0(3);
        }
        if (directoryFile == null) {
            PsiDirectoryNode.$$$reportNull$$$0(4);
        }
        if (fileIndex == null) {
            PsiDirectoryNode.$$$reportNull$$$0(5);
        }
        if (Registry.is("ide.hide.real.module.name")) {
            return true;
        }
        String moduleName = module2.getName();
        if (moduleName.equalsIgnoreCase(directoryName = directoryFile.getName())) {
            return true;
        }
        return ModuleGrouperKt.isQualifiedModuleNamesEnabled(module2.getProject()) && StringUtil.endsWithIgnoreCase(moduleName, directoryName) && (parentPrefixLength = moduleName.length() - directoryName.length() - 1) > 0 && moduleName.charAt(parentPrefixLength) == '.' && ProjectRootsUtil.isModuleContentRoot(parentDirectory = directoryFile.getParent(), module2.getProject()) && (parentModule = fileIndex.getModuleForFile(parentDirectory)) != null && parentModule.getName().length() == parentPrefixLength && moduleName.startsWith(parentModule.getName());
    }

    protected void setupIcon(PresentationData data2, PsiDirectory psiDirectory) {
        VirtualFile virtualFile2 = psiDirectory.getVirtualFile();
        if (PlatformUtils.isAppCode()) {
            Icon icon2 = IconUtil.getIcon((VirtualFile)virtualFile2, (int)0, (Project)this.myProject);
            if (icon2 != null) {
                data2.setIcon(icon2);
            }
        } else {
            Icon icon3 = CompoundIconProvider.findIcon(psiDirectory, 0);
            if (icon3 != null) {
                data2.setIcon(icon3);
            }
        }
    }

    @Override
    public Collection<AbstractTreeNode<?>> getChildrenImpl() {
        return ProjectViewDirectoryHelper.getInstance(this.myProject).getDirectoryChildren((PsiDirectory)this.getValue(), this.getSettings(), true, this.getFilter());
    }

    @Override
    public String getTestPresentation() {
        return "PsiDirectory: " + ((PsiDirectory)this.getValue()).getName();
    }

    public boolean isFQNameShown() {
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).isShowFQName(this.getSettings(), this.getParentValue(), (PsiDirectory)this.getValue());
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        PsiDirectory value2;
        if (file2 == null) {
            PsiDirectoryNode.$$$reportNull$$$0(6);
        }
        if ((value2 = (PsiDirectory)this.getValue()) == null) {
            return false;
        }
        VirtualFile directory = value2.getVirtualFile();
        if (directory.getFileSystem() instanceof LocalFileSystem) {
            file2 = VfsUtil.getLocalFile(file2);
        }
        if (!VfsUtilCore.isAncestor(directory, file2, false)) {
            return false;
        }
        Project project2 = value2.getProject();
        PsiFileSystemItemFilter filter2 = this.getFilter();
        if (filter2 != null) {
            PsiFile psiFile = PsiManager.getInstance(project2).findFile(file2);
            if (psiFile != null && !filter2.shouldShow(psiFile)) {
                return false;
            }
            PsiDirectory psiDirectory = PsiManager.getInstance(project2).findDirectory(file2);
            if (psiDirectory != null && !filter2.shouldShow(psiDirectory)) {
                return false;
            }
        }
        if (Registry.is("ide.hide.excluded.files")) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
            return !fileIndex.isExcluded(file2);
        }
        return !FileTypeRegistry.getInstance().isFileIgnored(file2);
    }

    @Nullable
    private static VirtualFile getVirtualFile(Object element2) {
        if (element2 instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)element2;
            return directory.getVirtualFile();
        }
        return element2 instanceof VirtualFile ? (VirtualFile)element2 : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canRepresent(Object element2) {
        VirtualFile file2 = PsiDirectoryNode.getVirtualFile(element2);
        if (file2 != null) {
            Set<VirtualFile> set = this.chain;
            synchronized (set) {
                if (this.chain.contains(file2)) {
                    return true;
                }
            }
        }
        if (super.canRepresent(element2)) {
            return true;
        }
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).canRepresent(element2, (PsiDirectory)this.getValue(), this.getParentValue(), this.getSettings());
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return ProjectViewDirectoryHelper.getInstance(this.getProject()).isValidDirectory((PsiDirectory)this.getValue(), this.getParentValue(), this.getSettings(), this.getFilter());
    }

    @Override
    public boolean canNavigate() {
        VirtualFile file2 = this.getVirtualFile();
        Project project2 = this.getProject();
        ProjectSettingsService service = ProjectSettingsService.getInstance(this.myProject);
        return file2 != null && (ProjectRootsUtil.isModuleContentRoot(file2, project2) && service.canOpenModuleSettings() || ProjectRootsUtil.isModuleSourceRoot(file2, project2) && service.canOpenContentEntriesSettings() || ProjectRootsUtil.isLibraryRoot(file2, project2) && service.canOpenModuleLibrarySettings());
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean requestFocus) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getValue());
        if (module2 != null) {
            VirtualFile file2 = this.getVirtualFile();
            Project project2 = this.getProject();
            ProjectSettingsService service = ProjectSettingsService.getInstance(this.myProject);
            if (ProjectRootsUtil.isModuleContentRoot(file2, project2)) {
                service.openModuleSettings(module2);
            } else if (ProjectRootsUtil.isLibraryRoot(file2, project2)) {
                OrderEntry orderEntry = LibraryUtil.findLibraryEntry(file2, module2.getProject());
                if (orderEntry != null) {
                    service.openLibraryOrSdkSettings(orderEntry);
                }
            } else {
                service.openContentEntriesSettings(module2);
            }
        }
    }

    @Override
    public String getNavigateActionText(boolean focusEditor) {
        VirtualFile file2 = this.getVirtualFile();
        Project project2 = this.getProject();
        if (file2 != null && project2 != null) {
            if (ProjectRootsUtil.isModuleContentRoot(file2, project2) || ProjectRootsUtil.isModuleSourceRoot(file2, project2)) {
                return ActionsBundle.message("action.ModuleSettings.navigate", new Object[0]);
            }
            if (ProjectRootsUtil.isLibraryRoot(file2, project2)) {
                return ActionsBundle.message("action.LibrarySettings.navigate", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public int getWeight() {
        ViewSettings settings = this.getSettings();
        if (settings == null || settings.isFoldersAlwaysOnTop()) {
            return 20;
        }
        return this.isFQNameShown() ? 70 : 0;
    }

    @Override
    public String getTitle() {
        PsiDirectory directory = (PsiDirectory)this.getValue();
        if (directory != null) {
            return PsiDirectoryFactory.getInstance(this.getProject()).getQualifiedName(directory, true);
        }
        return super.getTitle();
    }

    @Override
    public Comparable getSortKey() {
        if (ProjectAttachProcessor.canAttachToProject()) {
            VirtualFile file2 = this.getVirtualFile();
            if (Comparing.equal(file2, this.myProject.getBaseDir())) {
                return "";
            }
            return this.toString();
        }
        return null;
    }

    @Override
    public Comparable getTypeSortKey() {
        String extension;
        VirtualFile file2 = this.getVirtualFile();
        if (file2 != null && (extension = file2.getExtension()) != null) {
            return new PsiFileNode.ExtensionSortKey(extension);
        }
        return null;
    }

    @Override
    public String getQualifiedNameSortKey() {
        PsiDirectoryFactory factory = PsiDirectoryFactory.getInstance(this.getProject());
        return factory.getQualifiedName((PsiDirectory)this.getValue(), true);
    }

    @Override
    public int getTypeSortWeight(boolean sortByType) {
        return 3;
    }

    @Override
    public boolean shouldDrillDownOnEmptyElement() {
        return true;
    }

    @Override
    public boolean isAlwaysShowPlus() {
        VirtualFile file2 = this.getVirtualFile();
        return file2 == null || file2.getChildren().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PsiDirectoryNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "moduleNameMatchesDirectoryName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

