/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.CompoundProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.scopeView.ScopeTreeStructureExpander;
import com.intellij.ide.scopeView.nodes.BasePsiNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PackageTreeExpansionMonitor;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.problems.ProblemListener;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.search.scope.ProblemsScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.InvalidPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.UIBundle;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeTreeViewPanel
extends JPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ScopeTreeViewPanel.class);
    private final IdeView myIdeView;
    private final MyPsiTreeChangeAdapter myPsiTreeChangeAdapter;
    private final DnDAwareTree myTree;
    @NotNull
    private final Project myProject;
    private FileTreeModelBuilder myBuilder;
    private String CURRENT_SCOPE_NAME;
    private TreeExpansionMonitor<PackageDependenciesNode> myTreeExpansionMonitor;
    private CopyPasteDelegator myCopyPasteDelegator;
    private final MyDeletePSIElementProvider myDeletePSIElementProvider;
    private final ModuleDeleteProvider myDeleteModuleProvider;
    private final DependencyValidationManager myDependencyValidationManager;
    private final FileStatusListener myFileStatusListener;
    private final MergingUpdateQueue myUpdateQueue;
    protected ActionCallback myActionCallback;

    public ScopeTreeViewPanel(@NotNull Project project2) {
        if (project2 == null) {
            ScopeTreeViewPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myIdeView = new MyIdeView();
        this.myPsiTreeChangeAdapter = new MyPsiTreeChangeAdapter();
        this.myTree = new DnDAwareTree(){

            @Override
            public boolean isFileColorsEnabled() {
                return ProjectViewTree.isFileColorsEnabledFor(this);
            }

            @Override
            @Nullable
            public Color getFileColorForPath(@NotNull TreePath path2) {
                if (path2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(path2.getLastPathComponent() instanceof PackageDependenciesNode)) {
                    return null;
                }
                PackageDependenciesNode node = (PackageDependenciesNode)path2.getLastPathComponent();
                return ProjectViewTree.getColorForElement(node.getPsiElement());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/scopeView/ScopeTreeViewPanel$1", "getFileColorForPath"));
            }
        };
        this.myDeletePSIElementProvider = new MyDeletePSIElementProvider();
        this.myDeleteModuleProvider = new ModuleDeleteProvider();
        this.myFileStatusListener = new FileStatusListener(){

            @Override
            public void fileStatusesChanged() {
                TreeUtil.visitVisibleRows(ScopeTreeViewPanel.this.myTree, path2 -> TreeUtil.getLastUserObject(PackageDependenciesNode.class, path2), node -> node.updateColor());
            }

            @Override
            public void fileStatusChanged(@NotNull VirtualFile virtualFile2) {
                NamedScope currentScope;
                PackageSet value2;
                if (virtualFile2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!virtualFile2.isValid()) {
                    return;
                }
                PsiFile file2 = PsiManager.getInstance(ScopeTreeViewPanel.this.myProject).findFile(virtualFile2);
                if (file2 != null && (value2 = (currentScope = ScopeTreeViewPanel.this.getCurrentScope()).getValue()) != null && value2.contains(file2, NamedScopesHolder.getHolder(ScopeTreeViewPanel.this.myProject, currentScope.getName(), ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                    if (!ScopeTreeViewPanel.this.myBuilder.hasFileNode(virtualFile2)) {
                        return;
                    }
                    PackageDependenciesNode node = ScopeTreeViewPanel.this.myBuilder.getFileParentNode(virtualFile2);
                    PackageDependenciesNode[] nodes = FileTreeModelBuilder.findNodeForPsiElement(node, file2);
                    if (nodes != null) {
                        for (PackageDependenciesNode dependenciesNode : nodes) {
                            dependenciesNode.updateColor();
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/ide/scopeView/ScopeTreeViewPanel$2", "fileStatusChanged"));
            }
        };
        this.myUpdateQueue = new MergingUpdateQueue("ScopeViewUpdate", 300, this.isTreeShowing(), this.myTree);
        this.myProject = project2;
        this.initTree();
        this.add((Component)ScrollPaneFactory.createScrollPane(this.myTree), "Center");
        this.myDependencyValidationManager = DependencyValidationManager.getInstance(this.myProject);
        UiNotifyConnector uiNotifyConnector = new UiNotifyConnector(this.myTree, this.myUpdateQueue);
        Disposer.register(this, this.myUpdateQueue);
        Disposer.register(this, uiNotifyConnector);
        if (this.isTreeShowing()) {
            this.myUpdateQueue.showNotify();
        }
    }

    public void initListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, new MyModuleRootListener());
        PsiManager.getInstance(this.myProject).addPsiTreeChangeListener(this.myPsiTreeChangeAdapter);
        connection.subscribe(ProblemListener.TOPIC, new MyProblemListener());
        connection.subscribe(ChangeListListener.TOPIC, new MyChangesListListener());
        FileStatusManager.getInstance(this.myProject).addFileStatusListener(this.myFileStatusListener, this.myProject);
    }

    @Override
    public void dispose() {
        FileTreeModelBuilder.clearCaches(this.myProject);
        PsiManager.getInstance(this.myProject).removePsiTreeChangeListener(this.myPsiTreeChangeAdapter);
    }

    public void selectNode(final PsiElement element2, final PsiFileSystemItem file2, final boolean requestFocus) {
        Runnable runnable2 = () -> this.myUpdateQueue.queue(new Update((Object)"Select"){

            @Override
            public void run() {
                if (ScopeTreeViewPanel.this.myProject.isDisposed()) {
                    return;
                }
                PackageDependenciesNode node = ScopeTreeViewPanel.this.myBuilder.findNode(file2, element2);
                if (node != null && node.getPsiElement() != element2) {
                    TreePath path2 = new TreePath(node.getPath());
                    if (ScopeTreeViewPanel.this.myTree.isCollapsed(path2)) {
                        ScopeTreeViewPanel.this.myTree.expandPath(path2);
                        ScopeTreeViewPanel.this.myTree.makeVisible(path2);
                    }
                }
                if ((node = ScopeTreeViewPanel.this.myBuilder.findNode(file2, element2)) != null) {
                    TreeUtil.selectPath(ScopeTreeViewPanel.this.myTree, new TreePath(node.getPath()));
                    if (requestFocus) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(ScopeTreeViewPanel.this.myTree, true));
                    }
                }
            }
        });
        this.doWhenDone(runnable2);
    }

    private void doWhenDone(Runnable runnable2) {
        if (this.myActionCallback == null || ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            this.myActionCallback.doWhenDone(runnable2);
        }
    }

    public void selectScope(NamedScope scope) {
        this.myUpdateQueue.cancelAllUpdates();
        this.refreshScope(scope);
        if (scope != CustomScopesProviderEx.getAllScope() && scope != null) {
            this.CURRENT_SCOPE_NAME = scope.getName();
        }
    }

    public JPanel getPanel() {
        return this;
    }

    private void initTree() {
        ScopeTreeStructureExpander[] extensions2;
        HintUpdateSupply.installDataContextHintUpdateSupply(this.myTree);
        this.myTree.setCellRenderer(new MyTreeCellRenderer());
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        TreeUtil.installActions(this.myTree);
        EditSourceOnDoubleClickHandler.install(this.myTree);
        new TreeSpeedSearch(this.myTree);
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this);
        this.myTreeExpansionMonitor = PackageTreeExpansionMonitor.install(this.myTree, this.myProject);
        for (ScopeTreeStructureExpander expander : extensions2 = ScopeTreeStructureExpander.EP_NAME.getExtensions(this.myProject)) {
            this.myTree.addTreeWillExpandListener(expander);
        }
        if (extensions2.length == 0) {
            this.myTree.addTreeWillExpandListener(new SortingExpandListener());
        }
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                DefaultMutableTreeNode selectedNode;
                Object component2;
                if (10 == e.getKeyCode() && (component2 = ScopeTreeViewPanel.this.myTree.getLastSelectedPathComponent()) instanceof DefaultMutableTreeNode && (selectedNode = (DefaultMutableTreeNode)component2).isLeaf()) {
                    OpenSourceUtil.openSourcesFrom(DataManager.getInstance().getDataContext(ScopeTreeViewPanel.this.myTree), false);
                }
            }
        });
    }

    private PsiElement @NotNull [] getSelectedPsiElements() {
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            HashSet<PsiElement> result2 = new HashSet<PsiElement>();
            for (TreePath path2 : treePaths) {
                PackageDependenciesNode node;
                PsiElement psiElement;
                Object component2 = path2.getLastPathComponent();
                if (!(component2 instanceof PackageDependenciesNode) || (psiElement = (node = (PackageDependenciesNode)component2).getPsiElement()) == null || !psiElement.isValid()) continue;
                result2.add(psiElement);
            }
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
            if (psiElementArray == null) {
                ScopeTreeViewPanel.$$$reportNull$$$0(1);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            ScopeTreeViewPanel.$$$reportNull$$$0(2);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public void refreshScope(@Nullable NamedScope scope) {
        FileTreeModelBuilder.clearCaches(this.myProject);
        if (scope == null) {
            scope = CustomScopesProviderEx.getAllScope();
        }
        final NamedScopesHolder holder = NamedScopesHolder.getHolder(this.myProject, scope.getName(), this.myDependencyValidationManager);
        final PackageSet packageSet = scope.getValue() != null ? scope.getValue() : new InvalidPackageSet("");
        DependenciesPanel.DependencyPanelSettings settings = new DependenciesPanel.DependencyPanelSettings();
        settings.UI_FILTER_LEGALS = true;
        settings.UI_GROUP_BY_SCOPE_TYPE = false;
        settings.UI_SHOW_FILES = true;
        ProjectView projectView = ProjectView.getInstance(this.myProject);
        settings.UI_FLATTEN_PACKAGES = projectView.isFlattenPackages("Scope");
        settings.UI_COMPACT_EMPTY_MIDDLE_PACKAGES = projectView.isHideEmptyMiddlePackages("Scope");
        settings.UI_SHOW_MODULES = projectView.isShowModules("Scope");
        settings.UI_SHOW_MODULE_GROUPS = !projectView.isFlattenModules("Scope");
        this.myBuilder = new FileTreeModelBuilder(this.myProject, new Marker(){

            @Override
            public boolean isMarked(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return packageSet != null && (packageSet instanceof PackageSetBase ? ((PackageSetBase)packageSet).contains(file2, ScopeTreeViewPanel.this.myProject, holder) : packageSet.contains(PackageSetBase.getPsiFile(file2, ScopeTreeViewPanel.this.myProject), holder));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scopeView/ScopeTreeViewPanel$5", "isMarked"));
            }
        }, settings);
        this.myTree.setPaintBusy(true);
        this.myBuilder.setTree(this.myTree);
        this.myTree.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
        this.myActionCallback = new ActionCallback();
        ComponentUtil.putClientProperty(this.myTree, TreeState.CALLBACK, new WeakReference<ActionCallback>(this.myActionCallback));
        this.myTree.setModel(this.myBuilder.build(this.myProject, true, () -> {
            this.myTree.setPaintBusy(false);
            this.myTree.getEmptyText().setText(UIBundle.message("message.nothingToShow", new Object[0]));
            this.myActionCallback.setDone();
        }));
        ((PackageDependenciesNode)this.myTree.getModel().getRoot()).sortChildren();
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        FileTreeModelBuilder.clearCaches(this.myProject);
    }

    protected NamedScope getCurrentScope() {
        NamedScope scope = NamedScopesHolder.getScope(this.myProject, this.CURRENT_SCOPE_NAME);
        if (scope == null) {
            scope = CustomScopesProviderEx.getAllScope();
        }
        return scope;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object pathComponent;
        TreePath selectionPath;
        PackageDependenciesNode node;
        TreePath selectionPath2;
        if (dataId == null) {
            ScopeTreeViewPanel.$$$reportNull$$$0(3);
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId) && (selectionPath2 = this.myTree.getSelectionPath()) != null && (node = (PackageDependenciesNode)selectionPath2.getLastPathComponent()) instanceof ModuleNode) {
            return ((ModuleNode)node).getModule();
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (selectionPath2 = this.myTree.getSelectionPath()) != null) {
            node = (PackageDependenciesNode)selectionPath2.getLastPathComponent();
            return node != null && node.isValid() ? node.getPsiElement() : null;
        }
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null && LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            HashSet<PsiElement> psiElements = new HashSet<PsiElement>();
            for (TreePath treePath : treePaths) {
                PsiElement psiElement;
                PackageDependenciesNode node2 = (PackageDependenciesNode)treePath.getLastPathComponent();
                if (!node2.isValid() || (psiElement = node2.getPsiElement()) == null) continue;
                psiElements.add(psiElement);
            }
            return psiElements.isEmpty() ? null : PsiUtilCore.toPsiElementArray(psiElements);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            if (this.getSelectedModules() != null) {
                return this.myDeleteModuleProvider;
            }
            return this.myDeletePSIElementProvider;
        }
        if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId) && (selectionPath = this.myTree.getSelectionPath()) != null && (pathComponent = selectionPath.getLastPathComponent()) instanceof DirectoryNode) {
            return ((DirectoryNode)pathComponent).getTargetDirectory();
        }
        return null;
    }

    private Module @Nullable [] getSelectedModules() {
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            HashSet<Module> result2 = new HashSet<Module>();
            for (TreePath path2 : treePaths) {
                PackageDependenciesNode node = (PackageDependenciesNode)path2.getLastPathComponent();
                if (node instanceof ModuleNode) {
                    result2.add(((ModuleNode)node).getModule());
                    continue;
                }
                if (!(node instanceof ModuleGroupNode)) continue;
                ModuleGroupNode groupNode = (ModuleGroupNode)node;
                ModuleGroup moduleGroup = groupNode.getModuleGroup();
                result2.addAll(moduleGroup.modulesInGroup(this.myProject, true));
            }
            return result2.isEmpty() ? null : result2.toArray(Module.EMPTY_ARRAY);
        }
        return null;
    }

    private void reload(@Nullable DefaultMutableTreeNode rootToReload) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        if (rootToReload != null && rootToReload != treeModel.getRoot()) {
            List<TreePath> treePaths = TreeUtil.collectExpandedPaths(this.myTree, new TreePath(rootToReload.getPath()));
            List<TreePath> selectionPaths = TreeUtil.collectSelectedPaths(this.myTree, new TreePath(rootToReload.getPath()));
            TreePath path2 = new TreePath(rootToReload.getPath());
            boolean wasCollapsed = this.myTree.isCollapsed(path2);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.isTreeShowing() || rootToReload.getParent() == null) {
                    return;
                }
                TreeUtil.sort(rootToReload, (Comparator)this.getNodeComparator());
                treeModel.reload(rootToReload);
                if (!wasCollapsed) {
                    this.myTree.collapsePath(path2);
                    for (TreePath treePath : treePaths) {
                        this.myTree.expandPath(treePath);
                    }
                    for (TreePath selectionPath : selectionPaths) {
                        TreeUtil.selectPath(this.myTree, selectionPath);
                    }
                }
            }, ModalityState.any());
        } else {
            TreeUtil.sort(treeModel, (Comparator)this.getNodeComparator());
            treeModel.reload();
        }
    }

    private DependencyNodeComparator getNodeComparator() {
        return new DependencyNodeComparator(ProjectView.getInstance(this.myProject).isSortByType("Scope"));
    }

    public void setSortByType() {
        this.myTreeExpansionMonitor.freeze();
        this.reload(null);
        this.myTreeExpansionMonitor.restore();
    }

    public DnDAwareTree getTree() {
        return this.myTree;
    }

    private void addNode(VirtualFile file2, String scopeName) {
        this.queueUpdate(file2, psiFile -> this.myBuilder.addFileNode((PsiFile)psiFile), scopeName);
    }

    private void removeNode(VirtualFile file2, String scopeName) {
        this.queueUpdate(file2, psiFile -> this.myBuilder.removeNode((PsiElement)psiFile, psiFile.getContainingDirectory()), scopeName);
    }

    private void queueUpdate(final VirtualFile fileToRefresh, final Function<? super PsiFile, ? extends DefaultMutableTreeNode> rootToReloadGetter, String scopeName) {
        if (this.myProject.isDisposed()) {
            return;
        }
        AbstractProjectViewPane pane2 = ProjectView.getInstance(this.myProject).getCurrentProjectViewPane();
        if (pane2 == null || !"Scope".equals(pane2.getId()) || !scopeName.equals(pane2.getSubId())) {
            return;
        }
        this.myUpdateQueue.queue(new Update((Object)fileToRefresh){

            @Override
            public void run() {
                if (ScopeTreeViewPanel.this.myProject.isDisposed() || !fileToRefresh.isValid()) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance(ScopeTreeViewPanel.this.myProject).findFile(fileToRefresh);
                if (psiFile != null) {
                    ScopeTreeViewPanel.this.reload((DefaultMutableTreeNode)rootToReloadGetter.fun(psiFile));
                }
            }

            @Override
            public boolean isExpired() {
                return !ScopeTreeViewPanel.this.isTreeShowing();
            }
        });
    }

    private boolean isTreeShowing() {
        return this.myTree.isShowing() || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/ScopeTreeViewPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/ScopeTreeViewPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SortingExpandListener
    implements TreeWillExpandListener {
        private SortingExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
            TreePath path2 = event.getPath();
            if (path2 == null) {
                return;
            }
            PackageDependenciesNode node = (PackageDependenciesNode)path2.getLastPathComponent();
            node.sortChildren();
            ((DefaultTreeModel)ScopeTreeViewPanel.this.myTree.getModel()).reload(node);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) {
        }
    }

    private class MyChangesListListener
    extends ChangeListAdapter {
        private MyChangesListListener() {
        }

        @Override
        public void changeListAdded(ChangeList list2) {
            this.fireListeners(list2, null);
        }

        @Override
        public void changeListRemoved(ChangeList list2) {
            this.fireListeners(list2, null);
        }

        @Override
        public void changeListRenamed(ChangeList list2, String oldName) {
            this.fireListeners(list2, oldName);
        }

        private void fireListeners(ChangeList list2, @Nullable String oldName) {
            AbstractProjectViewPane pane2 = ProjectView.getInstance(ScopeTreeViewPanel.this.myProject).getCurrentProjectViewPane();
            if (pane2 == null || !"Scope".equals(pane2.getId())) {
                return;
            }
            String subId = pane2.getSubId();
            if (!(list2.getName().equals(subId) || oldName != null && oldName.equals(subId))) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> ScopeTreeViewPanel.this.myDependencyValidationManager.fireScopeListeners(), ScopeTreeViewPanel.this.myProject.getDisposed());
        }

        @Override
        public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
            String name = fromList.getName();
            HashSet files2 = new HashSet();
            this.collectFiles(changes, files2);
            for (VirtualFile file2 : files2) {
                ScopeTreeViewPanel.this.removeNode(file2, name);
            }
        }

        @Override
        public void changesAdded(Collection<Change> changes, ChangeList toList) {
            String name = toList.getName();
            HashSet files2 = new HashSet();
            this.collectFiles(changes, files2);
            for (VirtualFile file2 : files2) {
                ScopeTreeViewPanel.this.addNode(file2, name);
            }
        }

        private void collectFiles(Collection<? extends Change> changes, Set<? super VirtualFile> files2) {
            ChangesUtil.getAfterRevisionsFiles(changes.stream()).forEach(files2::add);
        }
    }

    private class MyProblemListener
    implements ProblemListener {
        private MyProblemListener() {
        }

        @Override
        public void problemsAppeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(0);
            }
            ScopeTreeViewPanel.this.addNode(file2, ProblemsScope.getNameText());
        }

        @Override
        public void problemsDisappeared(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProblemListener.$$$reportNull$$$0(1);
            }
            ScopeTreeViewPanel.this.removeNode(file2, ProblemsScope.getNameText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyProblemListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsAppeared";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "problemsDisappeared";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        @Override
        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(0);
            }
            PsiElement[] elements2 = ScopeTreeViewPanel.this.getSelectedPsiElements();
            return DeleteHandler.shouldEnableDeleteAction(elements2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(1);
            }
            ArrayList<PsiElement> validElements = new ArrayList<PsiElement>();
            for (PsiElement psiElement : ScopeTreeViewPanel.this.getSelectedPsiElements()) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements2 = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message("progress.deleting", new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements2, ScopeTreeViewPanel.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyDeletePSIElementProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        @Override
        public void selectElement(PsiElement element2) {
            if (element2 != null) {
                Editor editor;
                VirtualFile virtualFile2;
                PackageSet packageSet = ScopeTreeViewPanel.this.getCurrentScope().getValue();
                PsiFile psiFile = element2.getContainingFile();
                if (packageSet == null) {
                    return;
                }
                VirtualFile virtualFile3 = psiFile != null ? psiFile.getVirtualFile() : (virtualFile2 = element2 instanceof PsiDirectory ? ((PsiDirectory)element2).getVirtualFile() : null);
                if (virtualFile2 != null) {
                    ProjectView projectView = ProjectView.getInstance(ScopeTreeViewPanel.this.myProject);
                    NamedScopesHolder holder = NamedScopesHolder.getHolder(ScopeTreeViewPanel.this.myProject, ScopeTreeViewPanel.this.CURRENT_SCOPE_NAME, ScopeTreeViewPanel.this.myDependencyValidationManager);
                    if (packageSet instanceof PackageSetBase && !((PackageSetBase)packageSet).contains(virtualFile2, ScopeTreeViewPanel.this.myProject, holder) || psiFile != null && !packageSet.contains(psiFile, holder)) {
                        projectView.changeView("ProjectPane");
                    }
                    projectView.select(element2, virtualFile2, false);
                }
                if ((editor = EditorHelper.openInEditor(element2)) != null) {
                    ToolWindowManager.getInstance(ScopeTreeViewPanel.this.myProject).activateEditorComponent();
                }
            }
        }

        @Nullable
        private PsiDirectory getDirectory() {
            TreePath[] selectedPaths = ScopeTreeViewPanel.this.myTree.getSelectionPaths();
            if (selectedPaths != null) {
                if (selectedPaths.length != 1) {
                    return null;
                }
                TreePath path2 = selectedPaths[0];
                PackageDependenciesNode node = (PackageDependenciesNode)path2.getLastPathComponent();
                if (!node.isValid()) {
                    return null;
                }
                if (node instanceof DirectoryNode) {
                    return (PsiDirectory)node.getPsiElement();
                }
                if (node instanceof BasePsiNode) {
                    PsiElement psiElement = node.getPsiElement();
                    LOG.assertTrue(psiElement != null);
                    PsiFile psiFile = psiElement.getContainingFile();
                    LOG.assertTrue(psiFile != null);
                    return psiFile.getContainingDirectory();
                }
                if (node instanceof FileNode) {
                    PsiFile psiFile = (PsiFile)node.getPsiElement();
                    return psiFile != null ? psiFile.getContainingDirectory() : null;
                }
            }
            return null;
        }

        @Override
        public PsiDirectory @NotNull [] getDirectories() {
            PsiDirectory[] psiDirectoryArray;
            PsiDirectory directory = this.getDirectory();
            if (directory == null) {
                psiDirectoryArray = PsiDirectory.EMPTY_ARRAY;
            } else {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = directory;
            }
            if (psiDirectoryArray == null) {
                MyIdeView.$$$reportNull$$$0(0);
            }
            return psiDirectoryArray;
        }

        @Override
        @Nullable
        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyIdeView", "getDirectories"));
        }
    }

    private class MyModuleRootListener
    implements ModuleRootListener {
        private MyModuleRootListener() {
        }

        @Override
        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyModuleRootListener.$$$reportNull$$$0(0);
            }
            ScopeTreeViewPanel.this.myUpdateQueue.cancelAllUpdates();
            ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update((Object)"RootsChanged"){

                @Override
                public void run() {
                    ScopeTreeViewPanel.this.myTreeExpansionMonitor.freeze();
                    ScopeTreeViewPanel.this.refreshScope(ScopeTreeViewPanel.this.getCurrentScope());
                    ScopeTreeViewPanel.this.doWhenDone(() -> ScopeTreeViewPanel.this.myTreeExpansionMonitor.restore());
                }

                @Override
                public boolean isExpired() {
                    return !ScopeTreeViewPanel.this.isTreeShowing();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyModuleRootListener", "rootsChanged"));
        }
    }

    private class MyPsiTreeChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeAdapter() {
        }

        @Override
        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(0);
            }
            PsiElement element2 = event.getParent();
            PsiElement child2 = event.getChild();
            if (child2 == null) {
                return;
            }
            if (element2.getContainingFile() == null) {
                this.queueUpdate(() -> {
                    if (!child2.isValid()) {
                        return;
                    }
                    this.processNodeCreation(child2);
                }, false);
            }
        }

        private void processNodeCreation(PsiElement psiElement) {
            if (psiElement instanceof PsiFile && !this.isInjected((PsiFile)psiElement)) {
                PackageDependenciesNode rootToReload = ScopeTreeViewPanel.this.myBuilder.addFileNode((PsiFile)psiElement);
                if (rootToReload != null) {
                    ScopeTreeViewPanel.this.reload(rootToReload);
                }
            } else if (psiElement instanceof PsiDirectory) {
                PsiElement[] children2 = psiElement.getChildren();
                if (children2.length > 0) {
                    this.queueRefreshScope(ScopeTreeViewPanel.this.getCurrentScope(), (PsiDirectory)psiElement);
                } else {
                    PackageDependenciesNode node = ScopeTreeViewPanel.this.myBuilder.addDirNode((PsiDirectory)psiElement);
                    if (node != null) {
                        ScopeTreeViewPanel.this.reload((DefaultMutableTreeNode)node.getParent());
                    }
                }
            }
        }

        @Override
        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(1);
            }
            PsiElement child2 = event.getChild();
            PsiElement parent = event.getParent();
            if (parent instanceof PsiDirectory && (child2 instanceof PsiFile && !this.isInjected((PsiFile)child2) || child2 instanceof PsiDirectory)) {
                this.queueUpdate(() -> {
                    DefaultMutableTreeNode rootToReload = ScopeTreeViewPanel.this.myBuilder.removeNode(child2, (PsiDirectory)parent);
                    if (rootToReload != null) {
                        ScopeTreeViewPanel.this.reload(rootToReload);
                    }
                }, true);
            }
        }

        @Override
        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(2);
            }
            PsiElement oldParent = event.getOldParent();
            PsiElement child2 = event.getChild();
            if (oldParent instanceof PsiDirectory && child2 instanceof PsiFileSystemItem && (!(child2 instanceof PsiFile) || !this.isInjected((PsiFile)child2))) {
                this.queueUpdate(() -> {
                    DefaultMutableTreeNode rootToReload = ScopeTreeViewPanel.this.myBuilder.removeNode(child2, (PsiDirectory)(child2 instanceof PsiDirectory ? child2 : oldParent));
                    if (rootToReload != null) {
                        ScopeTreeViewPanel.this.reload(rootToReload);
                    }
                }, true);
            }
        }

        @Override
        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(3);
            }
            PsiElement newParent = event.getNewParent();
            PsiElement child2 = event.getChild();
            if (newParent instanceof PsiDirectory && child2 instanceof PsiFileSystemItem && (!(child2 instanceof PsiFile) || !this.isInjected((PsiFile)child2))) {
                PsiFileSystemItem file2 = (PsiFileSystemItem)child2;
                this.queueUpdate(() -> {
                    VirtualFile virtualFile2 = file2.getVirtualFile();
                    if (virtualFile2 != null && virtualFile2.isValid()) {
                        PsiFileSystemItem newFile;
                        PsiFileSystemItem psiFileSystemItem = file2.isValid() ? file2 : (newFile = file2.isDirectory() ? PsiManager.getInstance(ScopeTreeViewPanel.this.myProject).findDirectory(virtualFile2) : PsiManager.getInstance(ScopeTreeViewPanel.this.myProject).findFile(virtualFile2));
                        if (newFile != null) {
                            PackageDependenciesNode rootToReload;
                            PackageDependenciesNode packageDependenciesNode = rootToReload = newFile.isDirectory() ? ScopeTreeViewPanel.this.myBuilder.addDirNode((PsiDirectory)newFile) : ScopeTreeViewPanel.this.myBuilder.addFileNode((PsiFile)newFile);
                            if (rootToReload != null) {
                                ScopeTreeViewPanel.this.reload(rootToReload);
                            }
                        }
                    }
                }, true);
            }
        }

        @Override
        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            PsiElement parent;
            PsiFile file2;
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(4);
            }
            if ((file2 = (parent = event.getParent()).getContainingFile()) != null && file2.getFileType() == StdFileTypes.JAVA) {
                if (!file2.getViewProvider().isPhysical() && !this.isInjected(file2)) {
                    return;
                }
                this.queueUpdate(() -> {
                    if (file2.isValid() && file2.getViewProvider().isPhysical()) {
                        NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
                        PackageSet packageSet = scope.getValue();
                        if (packageSet == null) {
                            return;
                        }
                        if (packageSet.contains(file2, NamedScopesHolder.getHolder(ScopeTreeViewPanel.this.myProject, scope.getName(), ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                            ScopeTreeViewPanel.this.reload(ScopeTreeViewPanel.this.myBuilder.getFileParentNode(file2.getVirtualFile()));
                        }
                    }
                }, false);
            }
        }

        @Override
        public final void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(5);
            }
            String propertyName = event.getPropertyName();
            PsiElement element2 = event.getElement();
            if (element2 != null) {
                PackageSet value2;
                NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
                if (propertyName.equals("fileName") || propertyName.equals("propFileTypes")) {
                    this.queueUpdate(() -> {
                        if (element2.isValid()) {
                            this.processRenamed(scope, element2.getContainingFile());
                        }
                    }, false);
                } else if (propertyName.equals("directoryName") && (!((value2 = ScopeTreeViewPanel.this.getCurrentScope().getValue()) instanceof PackageSetBase) || ((PackageSetBase)value2).contains(((PsiDirectory)element2).getVirtualFile(), ScopeTreeViewPanel.this.myProject, ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                    this.queueRefreshScope(scope, (PsiDirectory)element2);
                }
            }
        }

        @Override
        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(6);
            }
            NamedScope scope = ScopeTreeViewPanel.this.getCurrentScope();
            PsiElement element2 = event.getNewChild();
            PsiFile psiFile = event.getFile();
            if (psiFile != null && !this.isInjected(psiFile)) {
                if (psiFile.getLanguage() == psiFile.getViewProvider().getBaseLanguage()) {
                    this.queueUpdate(() -> this.processRenamed(scope, psiFile), false);
                }
            } else if (element2 instanceof PsiDirectory && element2.isValid()) {
                this.queueRefreshScope(scope, (PsiDirectory)element2);
            }
        }

        private boolean isInjected(PsiFile psiFile) {
            return InjectedLanguageManager.getInstance(ScopeTreeViewPanel.this.myProject).isInjectedFragment(psiFile);
        }

        private void queueRefreshScope(NamedScope scope, PsiDirectory dir) {
            ScopeTreeViewPanel.this.myUpdateQueue.cancelAllUpdates();
            this.queueUpdate(() -> {
                ScopeTreeViewPanel.this.myTreeExpansionMonitor.freeze();
                ScopeTreeViewPanel.this.refreshScope(scope);
                ScopeTreeViewPanel.this.doWhenDone(() -> {
                    ScopeTreeViewPanel.this.myTreeExpansionMonitor.restore();
                    PackageDependenciesNode dirNode = ScopeTreeViewPanel.this.myBuilder.findNode(dir, dir);
                    if (dirNode != null) {
                        TreeUtil.selectPath(ScopeTreeViewPanel.this.myTree, new TreePath(dirNode.getPath()));
                    }
                });
            }, false);
        }

        private void processRenamed(NamedScope scope, PsiFile file2) {
            if (!file2.isValid() || !file2.getViewProvider().isPhysical()) {
                return;
            }
            PackageSet packageSet = scope.getValue();
            if (packageSet == null) {
                return;
            }
            if (packageSet.contains(file2, NamedScopesHolder.getHolder(ScopeTreeViewPanel.this.myProject, scope.getName(), ScopeTreeViewPanel.this.myDependencyValidationManager))) {
                ScopeTreeViewPanel.this.reload(ScopeTreeViewPanel.this.myBuilder.addFileNode(file2));
            } else {
                DefaultMutableTreeNode rootToReload = ScopeTreeViewPanel.this.myBuilder.removeNode(file2, file2.getParent());
                if (rootToReload != null) {
                    ScopeTreeViewPanel.this.reload(rootToReload);
                }
            }
        }

        private void queueUpdate(Runnable request2, boolean updateImmediately) {
            final Runnable wrapped = () -> {
                if (ScopeTreeViewPanel.this.myProject.isDisposed()) {
                    return;
                }
                request2.run();
            };
            if (updateImmediately && ScopeTreeViewPanel.this.isTreeShowing()) {
                ScopeTreeViewPanel.this.myUpdateQueue.run(new Update((Object)request2){

                    @Override
                    public void run() {
                        wrapped.run();
                    }
                });
            } else {
                ScopeTreeViewPanel.this.myUpdateQueue.queue(new Update((Object)request2){

                    @Override
                    public void run() {
                        wrapped.run();
                    }

                    @Override
                    public boolean isExpired() {
                        return !ScopeTreeViewPanel.this.isTreeShowing();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyPsiTreeChangeAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildRemoval";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildMovement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final WolfTheProblemSolver myWolfTheProblemSolver;

        private MyTreeCellRenderer() {
            this.myWolfTheProblemSolver = WolfTheProblemSolver.getInstance(ScopeTreeViewPanel.this.myProject);
        }

        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value2 instanceof PackageDependenciesNode) {
                String locationString;
                PackageDependenciesNode node = (PackageDependenciesNode)value2;
                try {
                    this.setIcon(node.getIcon());
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                SimpleTextAttributes regularAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                TextAttributes textAttributes = regularAttributes.toTextAttributes();
                if (node instanceof BasePsiNode && ((BasePsiNode)node).isDeprecated()) {
                    textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.DEPRECATED_ATTRIBUTES).clone();
                }
                PsiElement psiElement = node.getPsiElement();
                textAttributes.setForegroundColor(CopyPasteManager.getInstance().isCutElement(psiElement) ? CopyPasteManager.CUT_COLOR : node.getColor());
                if (ScopeTreeViewPanel.this.getCurrentScope() != ProblemsScope.INSTANCE) {
                    boolean isProblem;
                    PsiFile containingFile = psiElement != null ? psiElement.getContainingFile() : null;
                    VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(psiElement);
                    if (containingFile != null) {
                        isProblem = this.myWolfTheProblemSolver.isProblemFile(virtualFile2);
                    } else if (virtualFile2 != null) {
                        isProblem = this.myWolfTheProblemSolver.hasProblemFilesBeneath(file2 -> VfsUtilCore.isAncestor(virtualFile2, file2, false));
                    } else {
                        Module module2 = node instanceof ModuleNode ? ((ModuleNode)node).getModule() : null;
                        boolean bl = isProblem = module2 != null && this.myWolfTheProblemSolver.hasProblemFilesBeneath(module2);
                    }
                    if (isProblem) {
                        textAttributes.setEffectColor(JBColor.RED);
                        textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    }
                }
                this.append(node.toString(), SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes));
                String oldToString = this.toString();
                CompoundProjectViewNodeDecorator.get(ScopeTreeViewPanel.this.myProject).decorate(node, this);
                if (this.toString().equals(oldToString) && (locationString = node.getComment()) != null && locationString.length() > 0) {
                    this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/scopeView/ScopeTreeViewPanel$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }
}

