/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NewActionGroup;
import com.intellij.ide.scratch.LRUPopupBuilder;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchFileActions {
    private static int ourCurrentBuffer = 0;

    private static int nextBufferIndex() {
        ourCurrentBuffer = ourCurrentBuffer % Registry.intValue("ide.scratch.buffers") + 1;
        return ourCurrentBuffer;
    }

    @NotNull
    static ScratchFileCreationHelper.Context createContext(@NotNull AnActionEvent e, @NotNull Project project2) {
        if (e == null) {
            ScratchFileActions.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(1);
        }
        PsiFile file2 = e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = e.getData(CommonDataKeys.EDITOR);
        if (file2 == null && editor != null) {
            file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        }
        ScratchFileCreationHelper.Context context = new ScratchFileCreationHelper.Context();
        context.text = StringUtil.notNullize(ScratchFileActions.getSelectionText(editor));
        if (!context.text.isEmpty()) {
            context.language = ScratchFileActions.getLanguageFromCaret(project2, editor, file2);
            ScratchFileActions.checkLanguageAndTryToFixText(project2, context, e.getDataContext());
        } else {
            context.text = StringUtil.notNullize(e.getData(PlatformDataKeys.PREDEFINED_TEXT));
        }
        context.ideView = e.getData(LangDataKeys.IDE_VIEW);
        ScratchFileCreationHelper.Context context2 = context;
        if (context2 == null) {
            ScratchFileActions.$$$reportNull$$$0(2);
        }
        return context2;
    }

    static PsiFile doCreateNewScratch(@NotNull Project project2, @NotNull ScratchFileCreationHelper.Context context) {
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ScratchFileActions.$$$reportNull$$$0(4);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("scratch");
        Language language2 = Objects.requireNonNull(context.language);
        if (context.fileExtension == null) {
            LanguageFileType fileType = language2.getAssociatedFileType();
            context.fileExtension = fileType == null ? "" : fileType.getDefaultExtension();
        }
        ScratchFileCreationHelper.EXTENSION.forLanguage(language2).beforeCreate(project2, context);
        VirtualFile dir = context.ideView != null ? PsiUtilCore.getVirtualFile(ArrayUtil.getFirstElement(context.ideView.getDirectories())) : null;
        RootType rootType = dir == null ? null : ScratchFileService.findRootType(dir);
        String relativePath = rootType != ScratchRootType.getInstance() ? "" : FileUtil.getRelativePath(ScratchFileService.getInstance().getRootPath(rootType), dir.getPath(), '/');
        String fileName = (StringUtil.isEmpty(relativePath) ? "" : relativePath + "/") + PathUtil.makeFileName(ObjectUtils.notNull(context.filePrefix, "scratch") + (context.fileCounter != null ? (Serializable)context.fileCounter.create() : ""), context.fileExtension);
        VirtualFile file2 = ScratchRootType.getInstance().createScratchFile(project2, fileName, language2, context.text, context.createOption);
        if (file2 == null) {
            return null;
        }
        PsiNavigationSupport.getInstance().createNavigatable(project2, file2, context.caretOffset).navigate(true);
        PsiFile psiFile = PsiManager.getInstance(project2).findFile(file2);
        if (context.ideView != null && psiFile != null) {
            context.ideView.selectElement(psiFile);
        }
        return psiFile;
    }

    private static void checkLanguageAndTryToFixText(@NotNull Project project2, @NotNull ScratchFileCreationHelper.Context context, @NotNull DataContext dataContext) {
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ScratchFileActions.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            ScratchFileActions.$$$reportNull$$$0(7);
        }
        if (context.language == null) {
            return;
        }
        ScratchFileCreationHelper handler2 = ScratchFileCreationHelper.EXTENSION.forLanguage(context.language);
        if (handler2.prepareText(project2, context, dataContext)) {
            return;
        }
        PsiFile psiFile = ScratchFileCreationHelper.parseHeader(project2, context.language, context.text);
        PsiErrorElement firstError = SyntaxTraverser.psiTraverser(psiFile).traverse().filter(PsiErrorElement.class).first();
        if (firstError != null && firstError.getParent() == psiFile) {
            context.language = null;
        }
    }

    @Nullable
    static String getSelectionText(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getSelectionModel().getSelectedText();
    }

    @Nullable
    static Language getLanguageFromCaret(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        if (project2 == null) {
            ScratchFileActions.$$$reportNull$$$0(8);
        }
        if (editor == null || psiFile == null) {
            return null;
        }
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        int offset = caret.getOffset();
        PsiElement element2 = InjectedLanguageManager.getInstance(project2).findInjectedElementAt(psiFile, offset);
        PsiFile file2 = element2 != null ? element2.getContainingFile() : psiFile;
        Language language2 = file2.getLanguage();
        if (language2 == PlainTextLanguage.INSTANCE && file2.getFileType() instanceof InternalFileType) {
            return StdLanguages.XML;
        }
        return language2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateNewScratch";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkLanguageAndTryToFixText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageFromCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LanguageAction
    extends DumbAwareAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                LanguageAction.$$$reportNull$$$0(0);
            }
            Project project2 = e.getProject();
            JBIterable<Object> files2 = JBIterable.of((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
            if (project2 == null || files2.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Condition<VirtualFile> isScratch = this.fileFilter(project2);
            if (!files2.filter(Conditions.not(isScratch)).isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Set languages = files2.filter(isScratch).map(this.fileLanguage(project2)).filter(Conditions.notNull()).addAllTo(new LinkedHashSet());
            String langName = languages.size() == 1 ? ((Language)languages.iterator().next()).getDisplayName() : languages.size() + " different";
            e.getPresentation().setText(String.format("Change %s (%s)...", this.getLanguageTerm(), langName));
            e.getPresentation().setEnabledAndVisible(true);
        }

        @NotNull
        protected String getLanguageTerm() {
            return "Language";
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                LanguageAction.$$$reportNull$$$0(1);
            }
            Project project2 = e.getProject();
            JBIterable<VirtualFile> files2 = JBIterable.of((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)).filter(this.fileFilter(project2));
            if (project2 == null || files2.isEmpty()) {
                return;
            }
            this.actionPerformedImpl(e, project2, "Change " + this.getLanguageTerm(), files2);
        }

        @NotNull
        protected Condition<VirtualFile> fileFilter(Project project2) {
            Condition<VirtualFile> condition2 = file2 -> !file2.isDirectory() && ScratchRootType.getInstance().containsFile((VirtualFile)file2);
            if (condition2 == null) {
                LanguageAction.$$$reportNull$$$0(2);
            }
            return condition2;
        }

        @NotNull
        protected Function<VirtualFile, Language> fileLanguage(final @NotNull Project project2) {
            if (project2 == null) {
                LanguageAction.$$$reportNull$$$0(3);
            }
            return new Function<VirtualFile, Language>(){
                final ScratchFileService fileService = ScratchFileService.getInstance();

                @Override
                public Language fun(VirtualFile file2) {
                    Language lang2 = this.fileService.getScratchesMapping().getMapping(file2);
                    return lang2 != null ? lang2 : LanguageUtil.getLanguageForPsi(project2, file2);
                }
            };
        }

        protected void actionPerformedImpl(@NotNull AnActionEvent e, @NotNull Project project2, @NotNull String title, @NotNull JBIterable<? extends VirtualFile> files2) {
            if (e == null) {
                LanguageAction.$$$reportNull$$$0(4);
            }
            if (project2 == null) {
                LanguageAction.$$$reportNull$$$0(5);
            }
            if (title == null) {
                LanguageAction.$$$reportNull$$$0(6);
            }
            if (files2 == null) {
                LanguageAction.$$$reportNull$$$0(7);
            }
            ScratchFileService fileService = ScratchFileService.getInstance();
            PerFileMappings<Language> mapping2 = fileService.getScratchesMapping();
            LRUPopupBuilder.forFileLanguages(project2, title, files2, mapping2).showInBestPositionFor(e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchFileActions$LanguageAction";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$LanguageAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fileLanguage";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformedImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NewBufferAction
    extends DumbAwareAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(0);
            }
            boolean enabled = e.getProject() != null && Registry.intValue("ide.scratch.buffers") > 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                NewBufferAction.$$$reportNull$$$0(1);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            ScratchFileCreationHelper.Context context = ScratchFileActions.createContext(e, project2);
            context.filePrefix = "buffer";
            context.createOption = ScratchFileService.Option.create_if_missing;
            context.fileCounter = () -> ScratchFileActions.nextBufferIndex();
            if (context.language == null) {
                context.language = PlainTextLanguage.INSTANCE;
            }
            ScratchFileActions.doCreateNewScratch(project2, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewBufferAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class NewFileAction
    extends DumbAwareAction {
        private static final Icon ICON = LayeredIcon.create((Icon)AllIcons.FileTypes.Text, (Icon)AllIcons.Actions.Scratch);
        @NonNls
        private static final String ACTION_ID = "NewScratchFile";
        private final NotNullLazyValue<String> myActionText = NotNullLazyValue.createValue(() -> NewActionGroup.isActionInNewPopupMenu(this) ? ActionsBundle.actionText(ACTION_ID) : ActionsBundle.message("action.NewScratchFile.text.with.new", new Object[0]));

        public NewFileAction() {
            this.getTemplatePresentation().setIcon(ICON);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(0);
            }
            this.getTemplatePresentation().setText(this.myActionText.getValue());
            Project project2 = e.getProject();
            String place = e.getPlace();
            boolean enabled = project2 != null && (e.isFromActionToolbar() || ActionPlaces.isMainMenuOrActionSearch(place) || ActionPlaces.isPopupPlace(place) && e.getData(LangDataKeys.IDE_VIEW) != null);
            e.getPresentation().setEnabledAndVisible(enabled);
            this.updatePresentationTextAndIcon(e, e.getPresentation());
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2;
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(1);
            }
            if ((project2 = e.getProject()) == null) {
                return;
            }
            ScratchFileCreationHelper.Context context = ScratchFileActions.createContext(e, project2);
            Consumer<Language> consumer = l -> {
                context.language = l;
                ScratchFileCreationHelper.EXTENSION.forLanguage(context.language).prepareText(project2, context, DataContext.EMPTY_CONTEXT);
                ScratchFileActions.doCreateNewScratch(project2, context);
            };
            if (context.language != null) {
                consumer.consume(context.language);
            } else {
                LRUPopupBuilder.forFileLanguages(project2, ActionsBundle.message("action.NewScratchFile.text.with.new", new Object[0]), null, consumer).showCenteredInCurrentWindow(project2);
            }
        }

        private void updatePresentationTextAndIcon(@NotNull AnActionEvent e, @NotNull Presentation presentation) {
            if (e == null) {
                NewFileAction.$$$reportNull$$$0(2);
            }
            if (presentation == null) {
                NewFileAction.$$$reportNull$$$0(3);
            }
            presentation.setText(this.myActionText.getValue());
            presentation.setIcon(ICON);
            if ("MainMenu".equals(e.getPlace()) && !NewActionGroup.isActionInNewPopupMenu(this)) {
                presentation.setIcon(null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileActions$NewFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentationTextAndIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

