/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.lang.Language;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScratchFileService {
    public static ScratchFileService getInstance() {
        return ServiceHolder.instance;
    }

    @NotNull
    public abstract String getRootPath(@NotNull RootType var1);

    @Nullable
    public abstract RootType getRootType(@Nullable VirtualFile var1);

    public abstract VirtualFile findFile(@NotNull RootType var1, @NotNull String var2, @NotNull Option var3) throws IOException;

    @NotNull
    public abstract PerFileMappings<Language> getScratchesMapping();

    @Nullable
    public static RootType findRootType(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile parent = file2.isDirectory() ? file2 : file2.getParent();
        return ScratchFileService.getInstance().getRootType(parent);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isInScratchRoot(@Nullable VirtualFile file2) {
        return ScratchFileService.findRootType(file2) != null;
    }

    private static class ServiceHolder {
        static final ScratchFileService instance = ServiceManager.getService(ScratchFileService.class);

        private ServiceHolder() {
        }
    }

    public static enum Option {
        existing_only,
        create_if_missing,
        create_new_always;

    }
}

