/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.lang.Language;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScratchProjectViewPane
extends ProjectViewPane {
    public static final String ID = "Scratches";

    public static boolean isScratchesMergedIntoProjectTab() {
        return Registry.is("ide.scratch.in.project.view") && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public ScratchProjectViewPane(final Project project2) {
        super(project2);
        ScratchProjectViewPane.registerUpdaters(project2, this, new Runnable(){
            AbstractProjectViewPane updateTarget;

            @Override
            public void run() {
                if (this.updateTarget == null) {
                    AbstractProjectViewPane abstractProjectViewPane = this.updateTarget = !ScratchProjectViewPane.isScratchesMergedIntoProjectTab() ? ScratchProjectViewPane.this : ProjectView.getInstance(project2).getProjectViewPaneById("ProjectPane");
                }
                if (this.updateTarget != null) {
                    this.updateTarget.updateFromRoot(true);
                }
            }
        });
    }

    @Override
    @NotNull
    public String getTitle() {
        return ID;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.Scope.Scratches;
        if (icon2 == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    @Override
    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new MyTreeStructure(this.myProject);
    }

    @Override
    public int getWeight() {
        return 11;
    }

    private static void registerUpdaters(@NotNull Project project2, @NotNull Disposable disposable2, final @NotNull Runnable onUpdate) {
        if (project2 == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(2);
        }
        if (onUpdate == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(3);
        }
        String scratchPath = FileUtil.toSystemIndependentName(FileUtil.toCanonicalPath(PathManager.getScratchPath()));
        VirtualFileManager.getInstance().addAsyncFileListener(events -> {
            boolean update2 = JBIterable.from(events).find(e -> {
                ProgressManager.checkCanceled();
                boolean isDirectory = ScratchProjectViewPane.isDirectory(e);
                VirtualFile parent = ScratchProjectViewPane.getNewParent(e);
                return parent != null && (ScratchUtil.isScratch(parent) || isDirectory && parent.getPath().startsWith(scratchPath));
            }) != null;
            return !update2 ? null : new AsyncFileListener.ChangeApplier(){

                @Override
                public void afterVfsChange() {
                    onUpdate.run();
                }
            };
        }, disposable2);
        ReadAction.nonBlocking(() -> {
            for (RootType rootType : RootType.getAllRootTypes()) {
                if (rootType.isHidden()) continue;
                rootType.registerTreeUpdater(project2, disposable2, onUpdate);
            }
        }).expireWith(disposable2).submit((Executor)NonUrgentExecutor.getInstance());
    }

    @Override
    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            @Override
            protected boolean canSelect(PsiFileSystemItem file2) {
                VirtualFile vFile = PsiUtilCore.getVirtualFile(file2);
                if ((vFile = BackedVirtualFile.getOriginFileIfBacked(vFile)) == null || !vFile.isValid()) {
                    return false;
                }
                return ScratchUtil.isScratch(vFile);
            }

            @Override
            public String toString() {
                return ScratchProjectViewPane.this.getTitle();
            }

            @Override
            public String getMinorViewId() {
                return ScratchProjectViewPane.this.getId();
            }

            @Override
            public float getWeight() {
                return ScratchProjectViewPane.this.getWeight();
            }
        };
    }

    private static VirtualFile getNewParent(@NotNull VFileEvent e) {
        if (e == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(4);
        }
        if (e instanceof VFileMoveEvent) {
            return ((VFileMoveEvent)e).getNewParent();
        }
        if (e instanceof VFileCopyEvent) {
            return ((VFileCopyEvent)e).getNewParent();
        }
        if (e instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)e).getParent();
        }
        return Objects.requireNonNull(e.getFile()).getParent();
    }

    private static boolean isDirectory(@NotNull VFileEvent e) {
        if (e == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(5);
        }
        if (e instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)e).isDirectory();
        }
        return Objects.requireNonNull(e.getFile()).isDirectory();
    }

    @Nullable
    private static PsiDirectory getDirectory(@NotNull Project project2, @NotNull RootType rootType) {
        VirtualFile virtualFile2;
        if (project2 == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(6);
        }
        if (rootType == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(7);
        }
        return (virtualFile2 = ScratchProjectViewPane.getVirtualFile(rootType)) == null ? null : PsiManager.getInstance(project2).findDirectory(virtualFile2);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull RootType rootType) {
        if (rootType == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(8);
        }
        String path2 = ScratchFileService.getInstance().getRootPath(rootType);
        return LocalFileSystem.getInstance().findFileByPath(path2);
    }

    @Override
    public boolean isInitiallyVisible() {
        return !ScratchProjectViewPane.isScratchesMergedIntoProjectTab();
    }

    @NotNull
    public static AbstractTreeNode createRootNode(@NotNull Project project2, @NotNull ViewSettings settings) {
        if (project2 == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(10);
        }
        return new MyProjectNode(project2, settings);
    }

    @Nullable
    private static AbstractTreeNode<?> createRootNode(@NotNull Project project2, @NotNull RootType rootType, @NotNull ViewSettings settings) {
        if (project2 == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(11);
        }
        if (rootType == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(13);
        }
        if (rootType.isHidden()) {
            return null;
        }
        MyRootNode node = new MyRootNode(project2, rootType, settings);
        return node.isEmpty() ? null : node;
    }

    private static void customizePresentation(@NotNull BasePsiNode node, @NotNull PresentationData data2) {
        Icon icon2;
        MyRootNode rootNode;
        if (node == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(14);
        }
        if (data2 == null) {
            ScratchProjectViewPane.$$$reportNull$$$0(15);
        }
        VirtualFile file2 = Objects.requireNonNull(node.getVirtualFile());
        Project project2 = Objects.requireNonNull(node.getProject());
        AbstractTreeNode parent = node.getParent();
        MyRootNode myRootNode = parent instanceof MyRootNode ? (MyRootNode)parent : (rootNode = parent instanceof PsiDirectoryNode ? (MyRootNode)((PsiDirectoryNode)parent).getFilter() : null);
        if (rootNode == null) {
            return;
        }
        RootType rootType = rootNode.getRootType();
        String name = rootType.substituteName(project2, file2);
        if (name != null) {
            data2.setPresentableText(name);
        }
        if ((icon2 = rootType.substituteIcon(project2, file2)) != null) {
            data2.setIcon(icon2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerUpdaters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNewParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRootNode";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRootNode
    extends ProjectViewNode<RootType>
    implements PsiFileSystemItemFilter {
        MyRootNode(Project project2, @NotNull RootType type, ViewSettings settings) {
            if (type == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            super(project2, type, settings);
        }

        @NotNull
        public RootType getRootType() {
            RootType rootType = (RootType)Objects.requireNonNull(this.getValue());
            if (rootType == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            return rootType;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            return ((RootType)this.getValue()).containsFile(file2);
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return ScratchProjectViewPane.getVirtualFile(this.getRootType());
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRoots() {
            Collection<VirtualFile> collection = MyRootNode.getDefaultRootsFor(this.getVirtualFile());
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            return MyRootNode.getDirectoryChildrenImpl(this.getProject(), this.getDirectory(), this.getSettings(), this);
        }

        PsiDirectory getDirectory() {
            return ScratchProjectViewPane.getDirectory(this.getProject(), (RootType)this.getValue());
        }

        @Override
        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyRootNode.$$$reportNull$$$0(4);
            }
            presentation.setIcon(AllIcons.Nodes.Folder);
            presentation.setPresentableText(this.getRootType().getDisplayName());
        }

        @Override
        public boolean canRepresent(Object element2) {
            return Comparing.equal(this.getDirectory(), element2);
        }

        public boolean isEmpty() {
            VirtualFile root = this.getVirtualFile();
            if (root == null) {
                return true;
            }
            RootType rootType = this.getRootType();
            Project project2 = Objects.requireNonNull(this.getProject());
            for (VirtualFile f : root.getChildren()) {
                if (rootType.isIgnored(project2, f)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean shouldShow(@NotNull PsiFileSystemItem item) {
            if (item == null) {
                MyRootNode.$$$reportNull$$$0(5);
            }
            return !this.getRootType().isIgnored(this.getProject(), item.getVirtualFile());
        }

        @NotNull
        static Collection<AbstractTreeNode<?>> getDirectoryChildrenImpl(final @NotNull Project project2, @Nullable PsiDirectory directory, final @NotNull ViewSettings settings, final @NotNull PsiFileSystemItemFilter filter2) {
            if (project2 == null) {
                MyRootNode.$$$reportNull$$$0(6);
            }
            if (settings == null) {
                MyRootNode.$$$reportNull$$$0(7);
            }
            if (filter2 == null) {
                MyRootNode.$$$reportNull$$$0(8);
            }
            final ArrayList result2 = new ArrayList();
            PsiElementProcessor<PsiFileSystemItem> processor2 = new PsiElementProcessor<PsiFileSystemItem>(){

                @Override
                public boolean execute(@NotNull PsiFileSystemItem element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (filter2.shouldShow(element2)) {
                        if (element2 instanceof PsiDirectory) {
                            result2.add(new PsiDirectoryNode(project2, (PsiDirectory)element2, settings, filter2){

                                @Override
                                public Collection<AbstractTreeNode<?>> getChildrenImpl() {
                                    return MyRootNode.getDirectoryChildrenImpl(this.getProject(), (PsiDirectory)this.getValue(), this.getSettings(), this.getFilter());
                                }

                                @Override
                                protected void updateImpl(@NotNull PresentationData data2) {
                                    if (data2 == null) {
                                        MyRootNode.1.$$$reportNull$$$0(0);
                                    }
                                    super.updateImpl(data2);
                                    ScratchProjectViewPane.customizePresentation(this, data2);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1$1", "updateImpl"));
                                }
                            });
                        } else if (element2 instanceof PsiFile) {
                            result2.add(new PsiFileNode(project2, (PsiFile)element2, settings){

                                @Override
                                public Comparable getTypeSortKey() {
                                    PsiFile value2 = (PsiFile)this.getValue();
                                    Language language2 = value2 == null ? null : value2.getLanguage();
                                    LanguageFileType fileType = language2 == null ? null : language2.getAssociatedFileType();
                                    return fileType == null ? null : new PsiFileNode.ExtensionSortKey(fileType.getDefaultExtension());
                                }

                                @Override
                                protected void updateImpl(@NotNull PresentationData data2) {
                                    if (data2 == null) {
                                        2.$$$reportNull$$$0(0);
                                    }
                                    super.updateImpl(data2);
                                    ScratchProjectViewPane.customizePresentation(this, data2);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1$2", "updateImpl"));
                                }
                            });
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode$1", "execute"));
                }
            };
            Collection collection = AbstractTreeUi.calculateYieldingToWriteAction(() -> {
                if (directory == null || !directory.isValid()) {
                    return Collections.emptyList();
                }
                directory.processChildren(processor2);
                return result2;
            });
            if (collection == null) {
                MyRootNode.$$$reportNull$$$0(9);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldShow";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirectoryChildrenImpl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyProjectNode
    extends ProjectViewNode<String> {
        MyProjectNode(Project project2, ViewSettings settings) {
            super(project2, ScratchesNamedScope.scratchesAndConsoles(), settings);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyProjectNode.$$$reportNull$$$0(0);
            }
            return ScratchUtil.isScratch(file2);
        }

        @Override
        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            ArrayList list2 = new ArrayList();
            Project project2 = Objects.requireNonNull(this.getProject());
            for (RootType rootType : RootType.getAllRootTypes()) {
                ContainerUtil.addIfNotNull(list2, ScratchProjectViewPane.createRootNode(project2, rootType, this.getSettings()));
            }
            ArrayList arrayList = list2;
            if (arrayList == null) {
                MyProjectNode.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @Override
        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyProjectNode.$$$reportNull$$$0(2);
            }
            presentation.setPresentableText((String)this.getValue());
            presentation.setIcon(AllIcons.Scope.Scratches);
        }

        @Override
        public boolean canRepresent(Object element2) {
            VirtualFile virtualFile2;
            PsiElement item = element2 instanceof PsiElement ? (PsiElement)element2 : null;
            VirtualFile virtualFile3 = virtualFile2 = item == null ? null : PsiUtilCore.getVirtualFile(item);
            if (virtualFile2 == null) {
                return false;
            }
            return Comparing.equal(virtualFile2.getPath(), FileUtil.toSystemIndependentName(PathManager.getScratchPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyProjectNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTreeStructure
    extends ProjectTreeStructure {
        MyTreeStructure(@NotNull Project project2) {
            if (project2 == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            super(project2, ScratchProjectViewPane.ID);
        }

        @Override
        protected AbstractTreeNode createRoot(@NotNull Project project2, @NotNull ViewSettings settings) {
            if (project2 == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                MyTreeStructure.$$$reportNull$$$0(2);
            }
            return ScratchProjectViewPane.createRootNode(project2, settings);
        }

        @Override
        @Nullable
        public List<TreeStructureProvider> getProviders() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyTreeStructure";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyStructureProvider
    implements TreeStructureProvider,
    DumbAware {
        @Override
        @NotNull
        public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
            Project project2;
            if (parent == null) {
                MyStructureProvider.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                MyStructureProvider.$$$reportNull$$$0(1);
            }
            Project project3 = project2 = parent instanceof ProjectViewProjectNode ? parent.getProject() : null;
            if (project2 == null || !ScratchProjectViewPane.isScratchesMergedIntoProjectTab()) {
                Collection<AbstractTreeNode<?>> collection = children2;
                if (collection == null) {
                    MyStructureProvider.$$$reportNull$$$0(2);
                }
                return collection;
            }
            if (children2.isEmpty() && JBIterable.from(RootType.getAllRootTypes()).filterMap(o -> ScratchProjectViewPane.createRootNode(project2, o, settings)).isEmpty()) {
                Collection<AbstractTreeNode<?>> collection = children2;
                if (collection == null) {
                    MyStructureProvider.$$$reportNull$$$0(3);
                }
                return collection;
            }
            ArrayList list2 = new ArrayList(children2.size() + 1);
            list2.addAll(children2);
            list2.add(ScratchProjectViewPane.createRootNode(project2, settings));
            ArrayList arrayList = list2;
            if (arrayList == null) {
                MyStructureProvider.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        @Nullable
        public Object getData(@NotNull Collection<AbstractTreeNode<?>> selected2, @NotNull String dataId) {
            AbstractTreeNode<?> single;
            if (selected2 == null) {
                MyStructureProvider.$$$reportNull$$$0(5);
            }
            if (dataId == null) {
                MyStructureProvider.$$$reportNull$$$0(6);
            }
            if (LangDataKeys.PASTE_TARGET_PSI_ELEMENT.is(dataId) && (single = JBIterable.from(selected2).single()) instanceof MyRootNode) {
                VirtualFile file2 = ((MyRootNode)single).getVirtualFile();
                Project project2 = single.getProject();
                return file2 == null || project2 == null ? null : PsiManager.getInstance(project2).findDirectory(file2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyStructureProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/scratch/ScratchProjectViewPane$MyStructureProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "modify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "modify";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

