/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeScriptEngineManagerImpl
extends IdeScriptEngineManager {
    private static final Logger LOG = Logger.getInstance(IdeScriptEngineManager.class);
    private final Future<Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory>> myStateFuture = AppExecutorUtil.getAppExecutorService().submit(() -> {
        long start2 = System.currentTimeMillis();
        try {
            Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> map2 = IdeScriptEngineManagerImpl.calcFactories();
            return map2;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.info(ScriptEngineManager.class.getName() + " initialized in " + (end - start2) + " ms");
        }
    });

    IdeScriptEngineManagerImpl() {
    }

    @Override
    @NotNull
    public List<IdeScriptEngineManager.EngineInfo> getEngineInfos() {
        return new ArrayList<IdeScriptEngineManager.EngineInfo>(this.getFactories().keySet());
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngine(@NotNull IdeScriptEngineManager.EngineInfo engineInfo, @Nullable ClassLoader loader) {
        ScriptEngineFactory engineFactory;
        if (engineInfo == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(0);
        }
        if ((engineFactory = this.getFactories().get(engineInfo)) == null) {
            return null;
        }
        return IdeScriptEngineManagerImpl.createIdeScriptEngine(engineFactory, loader);
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineByName(@NotNull String engineName, @Nullable ClassLoader loader) {
        if (engineName == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(1);
        }
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = this.getFactories();
        for (IdeScriptEngineManager.EngineInfo info : state.keySet()) {
            if (!info.engineName.equals(engineName)) continue;
            return IdeScriptEngineManagerImpl.createIdeScriptEngine(state.get(info), loader);
        }
        return null;
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineByFileExtension(@NotNull String extension, @Nullable ClassLoader loader) {
        if (extension == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(2);
        }
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = this.getFactories();
        for (IdeScriptEngineManager.EngineInfo info : state.keySet()) {
            if (!info.fileExtensions.contains(extension)) continue;
            return IdeScriptEngineManagerImpl.createIdeScriptEngine(state.get(info), loader);
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.myStateFuture.isDone();
    }

    @NotNull
    private Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> getFactories() {
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = null;
        try {
            state = this.myStateFuture.get();
        }
        catch (Exception e) {
            LOG.error(e);
        }
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> map2 = state != null ? state : Collections.emptyMap();
        if (map2 == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    private static Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> calcFactories() {
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> map2 = JBIterable.empty().append(new ScriptEngineManager().getEngineFactories()).append(new ScriptEngineManager(AllPluginsLoader.INSTANCE).getEngineFactories()).unique(o -> o.getClass().getName()).toMap(factory -> {
            Class<?> aClass = factory.getClass();
            ClassLoader classLoader = aClass.getClassLoader();
            IdeaPluginDescriptor plugin = classLoader instanceof PluginClassLoader ? ((PluginClassLoader)classLoader).getPluginDescriptor() : null;
            return new IdeScriptEngineManager.EngineInfo(factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion(), factory.getExtensions(), aClass.getName(), plugin);
        }, o -> o);
        if (map2 == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @Nullable
    private static IdeScriptEngine createIdeScriptEngine(@Nullable ScriptEngineFactory scriptEngineFactory, @Nullable ClassLoader loader) {
        if (scriptEngineFactory == null) {
            return null;
        }
        EngineImpl engine = new EngineImpl(scriptEngineFactory, ObjectUtils.notNull(loader, AllPluginsLoader.INSTANCE));
        IdeScriptEngineManagerImpl.redirectOutputToLog(engine);
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(scriptEngineFactory.getClass());
        String factoryClass = pluginInfo.isSafeToReport() ? scriptEngineFactory.getClass().getName() : "third.party";
        FeatureUsageData data2 = new FeatureUsageData().addData("factory", factoryClass).addPluginInfo(pluginInfo);
        FUCounterUsageLogger.getInstance().logEvent("ide.script.engine", "used", data2);
        return engine;
    }

    private static void redirectOutputToLog(@NotNull IdeScriptEngine engine) {
        if (engine == null) {
            IdeScriptEngineManagerImpl.$$$reportNull$$$0(5);
        }
        class Log
        extends Writer {
            final boolean error;

            Log(boolean error) {
                this.error = error;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0 && Character.isWhitespace(cbuf[off + len - 1])) {
                    --len;
                }
                if (len == 0) {
                    return;
                }
                String s = new String(cbuf, off, len);
                if (this.error) {
                    LOG.warn(s);
                } else {
                    LOG.info(s);
                }
            }
        }
        engine.setStdOut(new Log(false));
        engine.setStdErr(new Log(true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engineName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/script/IdeScriptEngineManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/script/IdeScriptEngineManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEngine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEngineByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEngineByFileExtension";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "redirectOutputToLog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AllPluginsLoader
    extends ClassLoader {
        static final AllPluginsLoader INSTANCE = new AllPluginsLoader();
        final ConcurrentMap<Long, ClassLoader> myLuckyGuess = ContainerUtil.newConcurrentMap();

        AllPluginsLoader() {
            super(null);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            int p0 = name.indexOf("$");
            boolean hasBase = p0 > 0;
            int p1 = hasBase ? name.indexOf("$", p0 + 1) : -1;
            String base = hasBase ? name.substring(0, Math.max(p0, p1)) : name;
            long hash2 = StringHash.calc(base);
            Class<?> c = null;
            ClassLoader guess1 = (ClassLoader)this.myLuckyGuess.get(hash2);
            ClassLoader guess2 = (ClassLoader)this.myLuckyGuess.get(0L);
            for (ClassLoader loader : JBIterable.of(guess1, guess2)) {
                if (loader == this) {
                    throw new ClassNotFoundException(name);
                }
                if (loader == null) continue;
                try {
                    c = loader.loadClass(name);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (c == null) {
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    ClassLoader l = descriptor2.getPluginClassLoader();
                    if (l == null || l == guess1 || l == guess2) continue;
                    try {
                        if (hasBase) {
                            l.loadClass(base);
                            this.myLuckyGuess.putIfAbsent(hash2, l);
                        }
                        try {
                            c = l.loadClass(name);
                            this.myLuckyGuess.putIfAbsent(hash2, l);
                            this.myLuckyGuess.put(0L, l);
                        }
                        catch (ClassNotFoundException e) {
                            if (hasBase || name.startsWith("java.")) break;
                            if (!name.startsWith("groovy.")) continue;
                        }
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (c != null) {
                return c;
            }
            this.myLuckyGuess.putIfAbsent(hash2, this);
            throw new ClassNotFoundException(name);
        }

        private static boolean isAllowedPluginResource(String name) {
            return "META-INF/services/javax.script.ScriptEngineFactory".equals(name);
        }

        @Override
        protected URL findResource(String name) {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    URL url;
                    ClassLoader l = descriptor2.getPluginClassLoader();
                    URL uRL = url = l == null ? null : l.getResource(name);
                    if (url == null) continue;
                    return url;
                }
            }
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                LinkedHashSet result2 = null;
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    Enumeration<URL> urls;
                    ClassLoader l = descriptor2.getPluginClassLoader();
                    Enumeration<URL> enumeration = urls = l == null ? null : l.getResources(name);
                    if (urls == null || !urls.hasMoreElements()) continue;
                    if (result2 == null) {
                        result2 = new LinkedHashSet();
                    }
                    ContainerUtil.addAll(result2, urls);
                }
                if (result2 != null) {
                    return Collections.enumeration(result2);
                }
            }
            return this.getClass().getClassLoader().getResources(name);
        }

        @NotNull
        public List<URL> getUrls() {
            List<URL> list2 = JBIterable.of(PluginManagerCore.getPlugins()).map(PluginDescriptor::getPluginClassLoader).unique().flatMap(o -> {
                try {
                    return (List)o.getClass().getMethod("getUrls", new Class[0]).invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }).unique().toList();
            if (list2 == null) {
                AllPluginsLoader.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeScriptEngineManagerImpl$AllPluginsLoader", "getUrls"));
        }
    }

    static class EngineImpl
    implements IdeScriptEngine {
        private final ScriptEngine myEngine;
        private final ClassLoader myLoader;

        EngineImpl(@NotNull ScriptEngineFactory factory, @Nullable ClassLoader loader) {
            if (factory == null) {
                EngineImpl.$$$reportNull$$$0(0);
            }
            this.myLoader = loader;
            this.myEngine = ClassLoaderUtil.computeWithClassLoader(this.myLoader, () -> factory.getScriptEngine());
        }

        @Override
        public Object getBinding(@NotNull String name) {
            if (name == null) {
                EngineImpl.$$$reportNull$$$0(1);
            }
            return this.myEngine.get(name);
        }

        @Override
        public void setBinding(@NotNull String name, Object value2) {
            if (name == null) {
                EngineImpl.$$$reportNull$$$0(2);
            }
            this.myEngine.put(name, value2);
        }

        @Override
        @NotNull
        public Writer getStdOut() {
            Writer writer = this.myEngine.getContext().getWriter();
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(3);
            }
            return writer;
        }

        @Override
        public void setStdOut(@NotNull Writer writer) {
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(4);
            }
            this.myEngine.getContext().setWriter(writer);
        }

        @Override
        @NotNull
        public Writer getStdErr() {
            Writer writer = this.myEngine.getContext().getErrorWriter();
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(5);
            }
            return writer;
        }

        @Override
        public void setStdErr(@NotNull Writer writer) {
            if (writer == null) {
                EngineImpl.$$$reportNull$$$0(6);
            }
            this.myEngine.getContext().setErrorWriter(writer);
        }

        @Override
        @NotNull
        public Reader getStdIn() {
            Reader reader = this.myEngine.getContext().getReader();
            if (reader == null) {
                EngineImpl.$$$reportNull$$$0(7);
            }
            return reader;
        }

        @Override
        public void setStdIn(@NotNull Reader reader) {
            if (reader == null) {
                EngineImpl.$$$reportNull$$$0(8);
            }
            this.myEngine.getContext().setReader(reader);
        }

        @Override
        @NotNull
        public String getLanguage() {
            String string = this.myEngine.getFactory().getLanguageName();
            if (string == null) {
                EngineImpl.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getFileExtensions() {
            List<String> list2 = this.myEngine.getFactory().getExtensions();
            if (list2 == null) {
                EngineImpl.$$$reportNull$$$0(10);
            }
            return list2;
        }

        @Override
        public Object eval(@NotNull String script) throws IdeScriptException {
            if (script == null) {
                EngineImpl.$$$reportNull$$$0(11);
            }
            return ClassLoaderUtil.computeWithClassLoader(this.myLoader, () -> {
                try {
                    return this.myEngine.eval(script);
                }
                catch (Throwable ex) {
                    while (ex instanceof ScriptException && ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    throw new IdeScriptException(ex);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/script/IdeScriptEngineManagerImpl$EngineImpl";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/script/IdeScriptEngineManagerImpl$EngineImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdOut";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdErr";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdIn";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileExtensions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinding";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setBinding";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdOut";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdErr";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdIn";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "eval";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

