/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.startup.ProjectLoadListener;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.GuiUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class StartupManagerImpl
extends StartupManagerEx {
    private static final Logger LOG = Logger.getInstance(StartupManagerImpl.class);
    private static final long EDT_WARN_THRESHOLD_IN_NANO = TimeUnit.MILLISECONDS.toNanos(100L);
    private final Object myLock;
    private final Deque<Runnable> myStartupActivities;
    private final Deque<Runnable> myDumbAwarePostStartupActivities;
    private final Deque<Runnable> myNotDumbAwarePostStartupActivities;
    private volatile boolean postStartupActivitiesPassed;
    private volatile boolean myStartupActivitiesPassed;
    private final Project myProject;

    public StartupManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myStartupActivities = new ArrayDeque<Runnable>();
        this.myDumbAwarePostStartupActivities = new ArrayDeque<Runnable>();
        this.myNotDumbAwarePostStartupActivities = new ArrayDeque<Runnable>();
        this.myProject = project2;
    }

    private void checkNonDefaultProject() {
        LOG.assertTrue(!this.myProject.isDefault(), "Please don't register startup activities for the default project: they won't ever be run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(1);
        }
        this.checkNonDefaultProject();
        LOG.assertTrue(!this.myStartupActivitiesPassed, "Registering startup activity that will never be run");
        Object object = this.myLock;
        synchronized (object) {
            this.myStartupActivities.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPostStartupActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(2);
        }
        this.checkBeforeAddingPostStartupActivity();
        Deque<Runnable> list2 = DumbService.isDumbAware(runnable2) ? this.myDumbAwarePostStartupActivities : this.myNotDumbAwarePostStartupActivities;
        Object object = this.myLock;
        synchronized (object) {
            this.checkThatPostActivitiesNotPassed();
            list2.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPostStartupDumbAwareActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(3);
        }
        this.checkBeforeAddingPostStartupActivity();
        Object object = this.myLock;
        synchronized (object) {
            this.myDumbAwarePostStartupActivities.add(runnable2);
        }
    }

    private void checkBeforeAddingPostStartupActivity() {
        this.checkNonDefaultProject();
        this.checkThatPostActivitiesNotPassed();
    }

    private void checkThatPostActivitiesNotPassed() {
        if (this.postStartupActivitiesPassed) {
            LOG.error("Registering post-startup activity that will never be run: disposed=" + this.myProject.isDisposed() + "; open=" + this.myProject.isOpen() + "; passed=" + this.myStartupActivitiesPassed);
        }
    }

    @Override
    public boolean startupActivityPassed() {
        return this.myStartupActivitiesPassed;
    }

    @Override
    public boolean postStartupActivityPassed() {
        return this.postStartupActivitiesPassed;
    }

    public final void projectOpened(@Nullable ProgressIndicator indicator) {
        if (indicator != null && ApplicationManager.getApplication().isInternal()) {
            indicator.setText(IdeBundle.message("startup.indicator.text.running.startup.activities", new Object[0]));
        }
        this.doRunStartUpActivities(indicator);
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isDispatchThread()) {
            this.runPostStartupActivities();
        } else {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            app.executeOnPooledThread(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
                    this.runPostStartupActivities();
                    ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLoadListener.TOPIC).postStartUpActivitiesPassed();
                });
            });
        }
    }

    private void doRunStartUpActivities(@Nullable ProgressIndicator indicator) {
        LOG.assertTrue(!this.myStartupActivitiesPassed);
        Activity activity = StartUpMeasurer.startMainActivity("project startup");
        this.runActivities(this.myStartupActivities, indicator, null);
        ExtensionsAreaImpl area = (ExtensionsAreaImpl)ApplicationManager.getApplication().getExtensionArea();
        this.executeActivitiesFromExtensionPoint(indicator, (ExtensionPointImpl<StartupActivity>)area.getExtensionPoint("com.intellij.startupActivity"));
        this.myStartupActivitiesPassed = true;
        activity.end();
    }

    private void executeActivitiesFromExtensionPoint(@Nullable ProgressIndicator indicator, @NotNull ExtensionPointImpl<StartupActivity> extensionPoint) {
        if (extensionPoint == null) {
            StartupManagerImpl.$$$reportNull$$$0(4);
        }
        extensionPoint.processImplementations(true, (supplier, pluginDescriptor) -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PluginId id2 = pluginDescriptor.getPluginId();
            if (id2 != PluginManagerCore.CORE_ID && id2 != PluginManagerCore.JAVA_PLUGIN_ID && !id2.getIdString().equals("com.jetbrains.performancePlugin") && !id2.getIdString().equals("com.intellij.kotlinNative.platformDeps")) {
                LOG.error("Only bundled plugin can define " + extensionPoint.getName() + ": " + pluginDescriptor);
                return;
            }
            if (indicator != null) {
                indicator.checkCanceled();
            }
            try {
                this.runActivity(null, (StartupActivity)supplier.get(), (PluginDescriptor)pluginDescriptor, indicator);
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
                // empty catch block
            }
        });
    }

    public void runStartupActivities() {
        if (!this.myStartupActivitiesPassed) {
            this.doRunStartUpActivities(null);
        }
    }

    public final void runPostStartupActivities() {
        LOG.assertTrue(this.myStartupActivitiesPassed);
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        Activity dumbAwareActivity = StartUpMeasurer.startMainActivity("project post-startup dumb-aware activities");
        AtomicReference<Activity> edtActivity = new AtomicReference<Activity>();
        AtomicBoolean uiFreezeWarned = new AtomicBoolean();
        AtomicBoolean eventAboutDumbUnawareActivities = new AtomicBoolean();
        AtomicInteger counter = new AtomicInteger();
        DumbService dumbService = DumbService.getInstance(this.myProject);
        StartupActivity.POST_STARTUP_ACTIVITY.processWithPluginDescriptor((extension, pluginDescriptor) -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (DumbService.isDumbAware(extension)) {
                this.runActivity(null, (StartupActivity)extension, (PluginDescriptor)pluginDescriptor, ProgressIndicatorProvider.getGlobalProgressIndicator());
                return;
            }
            if (edtActivity.get() == null) {
                edtActivity.set(StartUpMeasurer.startMainActivity("project post-startup edt activities"));
            }
            counter.incrementAndGet();
            this.runDumbUnawareActivity(dumbService, () -> {
                this.runActivity(uiFreezeWarned, (StartupActivity)extension, (PluginDescriptor)pluginDescriptor, ProgressIndicatorProvider.getGlobalProgressIndicator());
                StartupManagerImpl.dumbUnawarePostActivitiesPassed(edtActivity, eventAboutDumbUnawareActivities, counter.decrementAndGet());
            });
        });
        StartupManagerImpl.dumbUnawarePostActivitiesPassed(edtActivity, eventAboutDumbUnawareActivities, counter.get());
        if (this.myProject.isDisposed()) {
            return;
        }
        StartupActivity.POST_STARTUP_ACTIVITY.addExtensionPointListener(new ExtensionPointListener<StartupActivity>(){

            @Override
            public void extensionAdded(@NotNull StartupActivity extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (DumbService.isDumbAware(extension)) {
                    StartupManagerImpl.this.runActivity(new AtomicBoolean(), extension, pluginDescriptor, ProgressIndicatorProvider.getGlobalProgressIndicator());
                } else {
                    StartupManagerImpl.this.runDumbUnawareActivity(DumbService.getInstance(StartupManagerImpl.this.myProject), () -> StartupManagerImpl.this.runActivity(null, extension, pluginDescriptor, ProgressIndicatorProvider.getGlobalProgressIndicator()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/startup/impl/StartupManagerImpl$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
        this.runActivities(this.myDumbAwarePostStartupActivities, null, null);
        dumbAwareActivity.end();
        snapshot.logResponsivenessSinceCreation("Post-startup activities under progress");
        this.runDumbUnawarePostStartupActivitiesRegisteredDynamically();
    }

    private static void dumbUnawarePostActivitiesPassed(@NotNull AtomicReference<Activity> edtActivity, @NotNull AtomicBoolean eventAboutDumbUnawareActivities, int count) {
        if (edtActivity == null) {
            StartupManagerImpl.$$$reportNull$$$0(5);
        }
        if (eventAboutDumbUnawareActivities == null) {
            StartupManagerImpl.$$$reportNull$$$0(6);
        }
        if (count != 0) {
            return;
        }
        Activity activity = edtActivity.getAndSet(null);
        if (activity != null) {
            activity.end();
        }
        if (eventAboutDumbUnawareActivities.compareAndSet(false, true)) {
            ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLoadListener.TOPIC).dumbUnawarePostStartUpActivitiesPassed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActivity(@Nullable AtomicBoolean uiFreezeWarned, @NotNull StartupActivity extension, @NotNull PluginDescriptor pluginDescriptor, @Nullable ProgressIndicator indicator) {
        if (extension == null) {
            StartupManagerImpl.$$$reportNull$$$0(7);
        }
        if (pluginDescriptor == null) {
            StartupManagerImpl.$$$reportNull$$$0(8);
        }
        if (indicator != null) {
            indicator.pushState();
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        try {
            extension.runActivity(this.myProject);
        }
        catch (ServiceNotReadyException e) {
            LOG.error(new Exception(e));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            if (indicator != null) {
                indicator.popState();
            }
        }
        String pluginId = pluginDescriptor.getPluginId().getIdString();
        long duration = StartUpMeasurer.addCompletedActivity(startTime, extension.getClass(), ActivityCategory.POST_STARTUP_ACTIVITY, pluginId, StartUpMeasurer.MEASURE_THRESHOLD);
        if (uiFreezeWarned != null && duration > EDT_WARN_THRESHOLD_IN_NANO) {
            StartupManagerImpl.reportUiFreeze(uiFreezeWarned);
        }
    }

    private static void reportUiFreeze(@NotNull AtomicBoolean uiFreezeWarned) {
        Application app;
        if (uiFreezeWarned == null) {
            StartupManagerImpl.$$$reportNull$$$0(9);
        }
        if (!(app = ApplicationManager.getApplication()).isUnitTestMode() && app.isDispatchThread() && uiFreezeWarned.compareAndSet(false, true)) {
            LOG.info("Some post-startup activities freeze UI for noticeable time. Please consider making them DumbAware to run them in background under modal progress, or just making them faster to speed up project opening.");
        }
    }

    public final void runPostStartupActivitiesRegisteredDynamically() {
        if (this.postStartupActivitiesPassed) {
            return;
        }
        this.runActivities(this.myDumbAwarePostStartupActivities, null, "project dumb post-startup");
        this.runDumbUnawarePostStartupActivitiesRegisteredDynamically();
    }

    private void runDumbUnawarePostStartupActivitiesRegisteredDynamically() {
        final DumbService dumbService = DumbService.getInstance(this.myProject);
        this.runDumbUnawareActivity(dumbService, new Runnable(){

            @Override
            public void run() {
                List dumbUnaware;
                StartupManagerImpl.this.runActivities(StartupManagerImpl.this.myDumbAwarePostStartupActivities, null, "project dumb post-startup");
                while (!(dumbUnaware = StartupManagerImpl.this.takeDumbUnawareStartupActivities()).isEmpty()) {
                    for (Runnable activity : dumbUnaware) {
                        StartupManagerImpl.this.runDumbUnawareActivity(dumbService, () -> StartupManagerImpl.runActivity(activity));
                    }
                }
                if (dumbService.isDumb()) {
                    DumbService.getInstance(StartupManagerImpl.this.myProject).unsafeRunWhenSmart(this);
                } else {
                    StartupManagerImpl.this.postStartupActivitiesPassed = true;
                }
            }
        });
        if (!this.myProject.isDisposed() && !ProjectManagerImpl.isLight(this.myProject)) {
            this.scheduleBackgroundPostStartupActivities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<Runnable> takeDumbUnawareStartupActivities() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myNotDumbAwarePostStartupActivities.isEmpty()) {
            List<Runnable> list2 = Collections.emptyList();
            // MONITOREXIT : object
            if (list2 != null) return list2;
            StartupManagerImpl.$$$reportNull$$$0(10);
            return list2;
        }
        ArrayList<Runnable> result2 = new ArrayList<Runnable>(this.myNotDumbAwarePostStartupActivities);
        this.myNotDumbAwarePostStartupActivities.clear();
        ArrayList<Runnable> arrayList = result2;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        StartupManagerImpl.$$$reportNull$$$0(11);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActivities(@NotNull Deque<? extends Runnable> activities, @Nullable ProgressIndicator indicator, @Nullable String activityName) {
        if (activities == null) {
            StartupManagerImpl.$$$reportNull$$$0(12);
        }
        if (activities.isEmpty()) {
            return;
        }
        Activity activity = activityName == null ? null : StartUpMeasurer.startMainActivity(activityName);
        while (true) {
            Runnable runnable2;
            Object object = this.myLock;
            synchronized (object) {
                runnable2 = activities.pollFirst();
            }
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (runnable2 == null) break;
            long startTime = StartUpMeasurer.getCurrentTime();
            ClassLoader loader = runnable2.getClass().getClassLoader();
            String pluginId = loader instanceof PluginClassLoader ? ((PluginClassLoader)loader).getPluginId().getIdString() : PluginManagerCore.CORE_ID.getIdString();
            StartupManagerImpl.runActivity(runnable2);
            StartUpMeasurer.addCompletedActivity(startTime, runnable2.getClass(), ActivityCategory.POST_STARTUP_ACTIVITY, pluginId, StartUpMeasurer.MEASURE_THRESHOLD);
        }
        if (activity != null) {
            activity.end();
        }
    }

    private void scheduleBackgroundPostStartupActivities() {
        if (this.myProject.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            List<StartupActivity.Background> activities = StartupActivity.BACKGROUND_POST_STARTUP_ACTIVITY.getExtensionList();
            StartupActivity.BACKGROUND_POST_STARTUP_ACTIVITY.addExtensionPointListener(new ExtensionPointListener<StartupActivity.Background>(){

                @Override
                public void extensionAdded(@NotNull StartupActivity.Background extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (pluginDescriptor == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    extension.runActivity(StartupManagerImpl.this.myProject);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "extension";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pluginDescriptor";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ide/startup/impl/StartupManagerImpl$3";
                    objectArray[2] = "extensionAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)this.myProject);
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
                for (StartupActivity activity : activities) {
                    ProgressManager.checkCanceled();
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    activity.runActivity(this.myProject);
                }
            });
        }, (long)Registry.intValue("ide.background.post.startup.activity.delay"), TimeUnit.MILLISECONDS);
        Disposer.register(this.myProject, () -> scheduledFuture.cancel(false));
    }

    public static void runActivity(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(13);
        }
        ProgressManager.checkCanceled();
        try {
            runnable2.run();
        }
        catch (ServiceNotReadyException e) {
            LOG.error(new Exception(e));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable ex) {
            LOG.error(ex);
        }
    }

    @Override
    public void runWhenProjectIsInitialized(@NotNull Runnable action2) {
        if (action2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(14);
        }
        this.checkNonDefaultProject();
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (this.myStartupActivitiesPassed && (this.myProject.isOpen() || this.myProject.isDefault() || this.postStartupActivitiesPassed && ApplicationManager.getApplication().isUnitTestMode())) {
                action2.run();
                return;
            }
            this.registerPostStartupDumbAwareActivity(() -> {
                if (DumbService.isDumbAware(action2)) {
                    StartupManagerImpl.runActivity(action2);
                } else {
                    this.runDumbUnawareActivity(DumbService.getInstance(this.myProject), action2);
                }
            });
        }, ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runAfterOpened(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(15);
        }
        this.checkNonDefaultProject();
        if (this.postStartupActivitiesPassed) {
            runnable2.run();
        } else {
            Object object = this.myLock;
            synchronized (object) {
                if (this.postStartupActivitiesPassed) {
                    runnable2.run();
                    return;
                }
                this.myDumbAwarePostStartupActivities.add(runnable2);
            }
        }
    }

    private void runDumbUnawareActivity(@NotNull DumbService dumbService, @NotNull Runnable action2) {
        if (dumbService == null) {
            StartupManagerImpl.$$$reportNull$$$0(16);
        }
        if (action2 == null) {
            StartupManagerImpl.$$$reportNull$$$0(17);
        }
        GuiUtils.invokeLaterIfNeeded(() -> dumbService.unsafeRunWhenSmart(action2), ModalityState.NON_MODAL, this.myProject.getDisposed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareForNextTest() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStartupActivities.clear();
            this.myDumbAwarePostStartupActivities.clear();
            this.myNotDumbAwarePostStartupActivities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkCleared() {
        try {
            Object object = this.myLock;
            synchronized (object) {
                assert (this.myStartupActivities.isEmpty()) : "Activities: " + this.myStartupActivities;
                assert (this.myDumbAwarePostStartupActivities.isEmpty()) : "DumbAware Post Activities: " + this.myDumbAwarePostStartupActivities;
                assert (this.myNotDumbAwarePostStartupActivities.isEmpty()) : "Post Activities: " + this.myNotDumbAwarePostStartupActivities;
            }
        }
        finally {
            this.prepareForNextTest();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtActivity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventAboutDumbUnawareActivities";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFreezeWarned";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/startup/impl/StartupManagerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/startup/impl/StartupManagerImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "takeDumbUnawareStartupActivities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerStartupActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerPostStartupActivity";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerPostStartupDumbAwareActivity";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeActivitiesFromExtensionPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dumbUnawarePostActivitiesPassed";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportUiFreeze";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runActivities";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runWhenProjectIsInitialized";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runAfterOpened";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runDumbUnawareActivity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

