/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorBasedStructureViewModel
implements StructureViewModel,
ProvidingTreeModel {
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final List<FileEditorPositionListener> myListeners;
    private final List<ModelListener> myModelListeners;
    private final CaretListener myEditorCaretListener;
    private Disposable myEditorCaretListenerDisposable;

    protected TextEditorBasedStructureViewModel(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(0);
        }
        this(PsiEditorUtil.findEditor(psiFile), psiFile);
    }

    protected TextEditorBasedStructureViewModel(Editor editor) {
        this(editor, null);
    }

    protected TextEditorBasedStructureViewModel(Editor editor, PsiFile file2) {
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myModelListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEditor = editor;
        this.myPsiFile = file2;
        this.myEditorCaretListener = new CaretListener(){

            @Override
            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getEditor().equals(TextEditorBasedStructureViewModel.this.myEditor)) {
                    for (FileEditorPositionListener listener2 : TextEditorBasedStructureViewModel.this.myListeners) {
                        listener2.onCurrentElementChanged();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel$1", "caretPositionChanged"));
            }
        };
    }

    @Override
    public final void addEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(1);
        }
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            this.myEditorCaretListenerDisposable = Disposer.newDisposable();
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(this.myEditorCaretListener, this.myEditorCaretListenerDisposable);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public final void removeEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener2);
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            Disposer.dispose(this.myEditorCaretListenerDisposable);
            this.myEditorCaretListenerDisposable = null;
        }
    }

    @Override
    public void dispose() {
        if (this.myEditorCaretListenerDisposable != null) {
            Disposer.dispose(this.myEditorCaretListenerDisposable);
        }
        this.myModelListeners.clear();
    }

    public void fireModelUpdate() {
        for (ModelListener listener2 : this.myModelListeners) {
            listener2.onModelChanged();
        }
    }

    @Override
    public boolean shouldEnterElement(Object element2) {
        return false;
    }

    @Override
    public Object getCurrentEditorElement() {
        Object o2;
        if (this.myEditor == null) {
            return null;
        }
        PsiFile file2 = this.getPsiFile();
        if (!file2.isValid()) {
            return null;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        Object o1 = this.findAcceptableElement(file2.getViewProvider().findElementAt(offset, file2.getLanguage()));
        Object object = o2 = offset == 0 ? o1 : this.findAcceptableElement(file2.getViewProvider().findElementAt(offset - 1, file2.getLanguage()));
        if (o1 != o2 && o1 instanceof PsiElement && o2 instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)o1, (PsiElement)o2, false)) {
            return o2;
        }
        return o1;
    }

    @Nullable
    protected Object findAcceptableElement(PsiElement element2) {
        while (element2 != null && !(element2 instanceof PsiFile)) {
            if (this.isSuitable(element2)) {
                return element2;
            }
            element2 = element2.getParent();
        }
        return null;
    }

    protected PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    protected boolean isSuitable(PsiElement element2) {
        Class[] suitableClasses;
        if (element2 == null) {
            return false;
        }
        for (Class suitableClass : suitableClasses = this.getSuitableClasses()) {
            if (!ReflectionUtil.isAssignable(suitableClass, element2.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addModelListener(@NotNull ModelListener modelListener2) {
        if (modelListener2 == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(3);
        }
        this.myModelListeners.add(modelListener2);
    }

    @Override
    public void removeModelListener(@NotNull ModelListener modelListener2) {
        if (modelListener2 == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(4);
        }
        this.myModelListeners.remove(modelListener2);
    }

    protected Class @NotNull [] getSuitableClasses() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(5);
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @Override
    public Grouper @NotNull [] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(6);
        }
        return Grouper.EMPTY_ARRAY;
    }

    @Override
    public Sorter @NotNull [] getSorters() {
        if (Sorter.EMPTY_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(7);
        }
        return Sorter.EMPTY_ARRAY;
    }

    @Override
    public Filter @NotNull [] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(8);
        }
        return Filter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        List<NodeProvider> list2 = Collections.emptyList();
        if (list2 == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    public boolean isEnabled(@NotNull NodeProvider provider) {
        if (provider == null) {
            TextEditorBasedStructureViewModel.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/TextEditorBasedStructureViewModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/TextEditorBasedStructureViewModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addEditorPositionListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorPositionListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

