/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final Object myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement == null ? null : TreeAnchorizer.getService().createAnchor(psiElement);
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        PsiTreeElementBase psiTreeElementBase = this;
        if (psiTreeElementBase == null) {
            PsiTreeElementBase.$$$reportNull$$$0(0);
        }
        return psiTreeElementBase;
    }

    @Override
    @NotNull
    public Object getKey() {
        String string = String.valueOf(this.getElement());
        if (string == null) {
            PsiTreeElementBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public final T getElement() {
        return (T)(this.myValue == null ? null : (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myValue));
    }

    @Override
    public Icon getIcon(boolean open2) {
        T element2 = this.getElement();
        if (element2 != null) {
            int flags = 2;
            if (!(element2 instanceof PsiFile) || !element2.isWritable()) {
                flags |= 1;
            }
            return element2.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    @Override
    public String getLocationString() {
        return null;
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element2 = this.getElement();
        return element2 != null ? element2.toString() : "";
    }

    public final StructureViewTreeElement @NotNull [] getChildren() {
        StructureViewTreeElement[] structureViewTreeElementArray = AbstractTreeUi.calculateYieldingToWriteAction(() -> this.doGetChildren(true));
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(2);
        }
        return structureViewTreeElementArray;
    }

    public final StructureViewTreeElement @NotNull [] getChildrenWithoutCustomRegions() {
        StructureViewTreeElement[] structureViewTreeElementArray = AbstractTreeUi.calculateYieldingToWriteAction(() -> this.doGetChildren(false));
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(3);
        }
        return structureViewTreeElementArray;
    }

    private StructureViewTreeElement @NotNull [] doGetChildren(boolean withCustomRegions) {
        T element2 = this.getElement();
        if (element2 == null) {
            if (EMPTY_ARRAY == null) {
                PsiTreeElementBase.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        return PsiTreeElementBase.mergeWithExtensions(element2, this.getChildrenBase(), withCustomRegions);
    }

    @Override
    public void navigate(boolean requestFocus) {
        T element2 = this.getElement();
        if (element2 != null) {
            ((Navigatable)element2).navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        T element2 = this.getElement();
        return element2 instanceof Navigatable && ((Navigatable)element2).canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        Object value2 = this.getValue();
        return value2 == null ? that.getValue() == null : value2.equals(that.getValue());
    }

    public int hashCode() {
        Object value2 = this.getValue();
        return value2 == null ? 0 : value2.hashCode();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    public static StructureViewTreeElement @NotNull [] mergeWithExtensions(@NotNull PsiElement element2, @NotNull Collection<StructureViewTreeElement> baseChildren, boolean withCustomRegions) {
        if (element2 == null) {
            PsiTreeElementBase.$$$reportNull$$$0(5);
        }
        if (baseChildren == null) {
            PsiTreeElementBase.$$$reportNull$$$0(6);
        }
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(withCustomRegions ? CustomRegionStructureUtil.groupByCustomRegions(element2, baseChildren) : baseChildren);
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element2.getProject());
        Class<?> aClass = element2.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass)) {
            StructureViewTreeElement[] children2 = extension.getChildren(element2);
            if (children2 != null) {
                ContainerUtil.addAll(result2, children2);
            }
            extension.filterChildren(result2, children2);
        }
        StructureViewTreeElement[] structureViewTreeElementArray = result2.toArray(StructureViewTreeElement.EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(7);
        }
        return structureViewTreeElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/common/PsiTreeElementBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenWithoutCustomRegions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/common/PsiTreeElementBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

