/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.util.Collection;

public abstract class ChangeListTodosPanel
extends TodoPanel {
    private final Alarm myAlarm;

    public ChangeListTodosPanel(Project project2, TodoPanelSettings settings, Content content2) {
        super(project2, settings, false, content2);
        ChangeListManager.getInstance(project2).addChangeListListener(new MyChangeListManagerListener(), this);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this);
    }

    private final class MyChangeListManagerListener
    extends ChangeListAdapter {
        private MyChangeListManagerListener() {
        }

        @Override
        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
            AppUIUtil.invokeOnEdt(() -> ChangeListTodosPanel.this.setDisplayName(TodoView.getTabNameForChangeList(newDefaultList.getName())));
        }

        @Override
        public void changeListRenamed(ChangeList list2, String oldName) {
            AppUIUtil.invokeOnEdt(() -> ChangeListTodosPanel.this.setDisplayName(TodoView.getTabNameForChangeList(list2.getName())));
        }

        @Override
        public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
            ChangeListTodosPanel.this.rebuildWithAlarm(ChangeListTodosPanel.this.myAlarm);
        }
    }
}

