/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;

public class ChangeListTodosTreeStructure
extends TodoTreeStructure {
    public ChangeListTodosTreeStructure(Project project2) {
        super(project2);
    }

    @Override
    public boolean accept(PsiFile psiFile) {
        if (!psiFile.isValid()) {
            return false;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        ChangeListManager listManager = ChangeListManager.getInstance(this.myProject);
        FileStatus status = listManager.getStatus(file2);
        if (status == FileStatus.NOT_CHANGED) {
            return false;
        }
        FilePath filePath2 = VcsUtil.getFilePath(file2);
        Collection<Change> changes = listManager.getDefaultChangeList().getChanges();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || !afterRevision.getFile().equals(filePath2)) continue;
            return this.myTodoFilter != null && this.myTodoFilter.accept(this.mySearchHelper, psiFile) || this.myTodoFilter == null && this.mySearchHelper.getTodoItemsCount(psiFile) > 0;
        }
        return false;
    }

    @Override
    public boolean getIsPackagesShown() {
        return this.myArePackagesShown;
    }

    @Override
    Object getFirstSelectableElement() {
        return ((ToDoRootNode)this.myRootElement).getSummaryNode();
    }

    @Override
    protected AbstractTreeNode createRootElement() {
        return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
    }
}

