/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ConfigurableFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SetTodoFilterAction
extends AnAction
implements CustomComponentAction {
    private final Project myProject;
    private final TodoPanelSettings myToDoSettings;
    private final Consumer<? super TodoFilter> myTodoFilterConsumer;

    public SetTodoFilterAction(Project project2, TodoPanelSettings toDoSettings, Consumer<? super TodoFilter> todoFilterConsumer) {
        super(IdeBundle.message("action.filter.todo.items", new Object[0]), null, AllIcons.General.Filter);
        this.myProject = project2;
        this.myToDoSettings = toDoSettings;
        this.myTodoFilterConsumer = todoFilterConsumer;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SetTodoFilterAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        JComponent button2 = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        DefaultActionGroup group = SetTodoFilterAction.createPopupActionGroup(this.myProject, this.myToDoSettings, this.myTodoFilterConsumer);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("TodoViewToolbar", group);
        popupMenu.getComponent().show(button2, button2.getWidth(), 0);
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            SetTodoFilterAction.$$$reportNull$$$0(1);
        }
        if (place == null) {
            SetTodoFilterAction.$$$reportNull$$$0(2);
        }
        return new ActionButton(this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    public static DefaultActionGroup createPopupActionGroup(final Project project2, TodoPanelSettings settings, Consumer<? super TodoFilter> todoFilterConsumer) {
        TodoFilter[] filters = TodoConfiguration.getInstance().getTodoFilters();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new TodoFilterApplier(IdeBundle.message("action.todo.show.all", new Object[0]), IdeBundle.message("action.description.todo.show.all", new Object[0]), null, settings, todoFilterConsumer));
        for (TodoFilter filter2 : filters) {
            group.add(new TodoFilterApplier(filter2.getName(), null, filter2, settings, todoFilterConsumer));
        }
        group.addSeparator();
        group.add(new AnAction(IdeBundle.messagePointer("action.todo.edit.filters", new Object[0]), IdeBundle.messagePointer("action.todo.edit.filters", new Object[0]), AllIcons.General.Settings){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                util.editConfigurable(project2, (Configurable)ConfigurableFactory.Companion.getInstance().getTodoConfigurable(project2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/SetTodoFilterAction$1", "actionPerformed"));
            }
        });
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/todo/SetTodoFilterAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TodoFilterApplier
    extends ToggleAction {
        private final TodoFilter myFilter;
        private final TodoPanelSettings mySettings;
        private final Consumer<? super TodoFilter> myTodoFilterConsumer;

        TodoFilterApplier(String text2, String description, TodoFilter filter2, TodoPanelSettings settings, Consumer<? super TodoFilter> todoFilterConsumer) {
            super(null, description, null);
            this.mySettings = settings;
            this.myTodoFilterConsumer = todoFilterConsumer;
            this.getTemplatePresentation().setText(text2, false);
            this.myFilter = filter2;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (this.myFilter != null) {
                e.getPresentation().setEnabled(!this.myFilter.isEmpty());
            }
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(1);
            }
            return Comparing.equal(this.myFilter != null ? this.myFilter.getName() : null, this.mySettings.todoFilterName);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(2);
            }
            if (state) {
                this.myTodoFilterConsumer.consume(this.myFilter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/todo/SetTodoFilterAction$TodoFilterApplier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

