/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ui.ItemRemovable;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

final class FiltersTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final String[] ourColumnNames = new String[]{IdeBundle.message("column.todo.filters.name", new Object[0]), IdeBundle.message("column.todo.filter.patterns", new Object[0])};
    private final Class[] ourColumnClasses = new Class[]{String.class, String.class};
    private final List<? extends TodoFilter> myFilters;

    FiltersTableModel(List<? extends TodoFilter> filters) {
        this.myFilters = filters;
    }

    @Override
    public String getColumnName(int column) {
        return this.ourColumnNames[column];
    }

    public Class getColumnClass(int column) {
        return this.ourColumnClasses[column];
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.myFilters.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        TodoFilter filter2 = this.myFilters.get(row);
        switch (column) {
            case 0: {
                return filter2.getName();
            }
            case 1: {
                StringBuilder sb = new StringBuilder();
                Iterator<TodoPattern> i = filter2.iterator();
                while (i.hasNext()) {
                    TodoPattern pattern = i.next();
                    sb.append(pattern.getPatternString());
                    if (!i.hasNext()) continue;
                    sb.append(" | ");
                }
                return sb.toString();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void removeRow(int index) {
        this.myFilters.remove(index);
        this.fireTableRowsDeleted(index, index);
    }
}

